/*
 * Decompiled with CFR 0.152.
 */
package org.joone.helpers.structure;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.joone.engine.InputPatternListener;
import org.joone.engine.Layer;
import org.joone.engine.Monitor;
import org.joone.engine.OutputPatternListener;
import org.joone.engine.Synapse;
import org.joone.helpers.structure.Connection;
import org.joone.net.NeuralNet;

public class NeuralNetMatrix {
    private ArrayList layers;
    private ArrayList connectionSet;
    private Monitor monitor;
    private Layer inputLayer = null;
    private Layer outputLayer = null;
    private int inputLayerInd = -1;
    private int outputLayerInd = -1;
    transient Hashtable synTemp;
    int[] translation = null;

    public NeuralNetMatrix() {
    }

    public NeuralNetMatrix(NeuralNet neuralNet) {
        this.setNeuralNet(neuralNet);
    }

    public void setNeuralNet(NeuralNet neuralNet) {
        Layer layer;
        int n = neuralNet.getLayers().size();
        this.inputLayer = neuralNet.findInputLayer();
        this.outputLayer = neuralNet.findOutputLayer();
        this.monitor = neuralNet.getMonitor();
        this.layers = new ArrayList(neuralNet.getLayers());
        this.synTemp = new Hashtable();
        for (int i = 0; i < n; ++i) {
            layer = (Layer)this.layers.get(i);
            this.checkInputs(i, layer);
            this.checkOutputs(i, layer);
        }
        Enumeration enumeration = this.synTemp.keys();
        this.connectionSet = new ArrayList();
        while (enumeration.hasMoreElements()) {
            int n2;
            layer = enumeration.nextElement();
            Connection connection = (Connection)this.synTemp.get(layer);
            int n3 = connection.getInput();
            if (n3 * (n2 = connection.getOutput()) <= 0) continue;
            this.connectionSet.add(connection);
        }
    }

    public Synapse[][] getConnectionMatrix() {
        Synapse[][] synapseArray = new Synapse[this.layers.size()][this.layers.size()];
        for (int i = 0; i < this.connectionSet.size(); ++i) {
            Connection connection = (Connection)this.connectionSet.get(i);
            int n = connection.getInput();
            int n2 = connection.getOutput();
            synapseArray[n - 1][n2 - 1] = connection.getSynapse();
        }
        return synapseArray;
    }

    public boolean isThereAnyPath(Layer layer, Layer layer2) {
        boolean bl = false;
        int n = this.getLayerInd(layer);
        int n2 = this.getLayerInd(layer2);
        bl = this.isThereAnyPath(n, n2, this.getConnectionMatrix());
        return bl;
    }

    private boolean isThereAnyPath(int n, int n2, Synapse[][] synapseArray) {
        boolean bl = false;
        for (int i = 0; i < this.layers.size() && !bl; ++i) {
            Synapse synapse = synapseArray[n][i];
            if (synapse == null || synapse.isLoopBack()) continue;
            bl = i == n2 ? true : this.isThereAnyPath(i, n2, synapseArray);
        }
        return bl;
    }

    public Synapse[][] getOrderedConnectionMatrix() {
        this.getOrderedLayers();
        Synapse[][] synapseArray = new Synapse[this.layers.size()][this.layers.size()];
        for (int i = 0; i < this.connectionSet.size(); ++i) {
            Connection connection = (Connection)this.connectionSet.get(i);
            int n = connection.getInput();
            int n2 = connection.getOutput();
            synapseArray[this.translation[n - 1]][this.translation[n2 - 1]] = connection.getSynapse();
        }
        return synapseArray;
    }

    public boolean[][] getBinaryOrderedConnectionMatrix() {
        this.getOrderedLayers();
        boolean[][] blArray = new boolean[this.layers.size()][this.layers.size()];
        for (int i = 0; i < this.connectionSet.size(); ++i) {
            Connection connection = (Connection)this.connectionSet.get(i);
            int n = connection.getInput();
            int n2 = connection.getOutput();
            blArray[this.translation[n - 1]][this.translation[n2 - 1]] = true;
        }
        return blArray;
    }

    public Layer[] getOrderedLayers() {
        int n;
        Synapse[][] synapseArray = this.getConnectionMatrix();
        if (synapseArray == null) {
            return null;
        }
        int[] nArray = new int[this.layers.size()];
        ArrayList arrayList = this.getInputLayers(synapseArray);
        for (n = 0; n < arrayList.size(); ++n) {
            int n2 = (Integer)arrayList.get(n);
            nArray[n2] = 1;
        }
        n = this.assignOrderToLayers(nArray, synapseArray) ? '\u0001' : '\u0000';
        while (n != 0) {
            n = this.assignOrderToLayers(nArray, synapseArray) ? '\u0001' : '\u0000';
        }
        this.translation = new int[this.layers.size()];
        Layer[] layerArray = new Layer[this.layers.size()];
        int n3 = 1;
        int n4 = 0;
        while (n4 < this.layers.size()) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] != n3) continue;
                layerArray[n4] = (Layer)this.layers.get(i);
                this.translation[i] = n4++;
            }
            ++n3;
        }
        return layerArray;
    }

    private boolean assignOrderToLayers(int[] nArray, Synapse[][] synapseArray) {
        boolean bl = false;
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (n <= 0) continue;
            for (int j = 0; j < synapseArray[i].length; ++j) {
                if (synapseArray[i][j] == null || synapseArray[i][j].isLoopBack() || n < nArray[j]) continue;
                nArray[j] = n + 1;
                bl = true;
            }
        }
        return bl;
    }

    public ArrayList getInputLayers(Synapse[][] synapseArray) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < synapseArray.length; ++i) {
            boolean bl = false;
            for (int j = 0; j < synapseArray[i].length; ++j) {
                if (synapseArray[j][i] == null || synapseArray[j][i].isLoopBack()) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(new Integer(i));
        }
        return arrayList;
    }

    public Serializable cloneElement(Serializable serializable) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(serializable);
            objectOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
            Object object = objectInputStream.readObject();
            objectInputStream.close();
            return (Serializable)object;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        return null;
    }

    private void checkInputs(int n, Layer layer) {
        Vector vector = layer.getAllInputs();
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            InputPatternListener inputPatternListener = (InputPatternListener)vector.elementAt(i);
            if (inputPatternListener == null || !(inputPatternListener instanceof Synapse)) continue;
            Connection connection = this.getSynapse((Synapse)inputPatternListener);
            connection.setOutput(n + 1);
            connection.setOutIndex(i);
        }
    }

    private void checkOutputs(int n, Layer layer) {
        Vector vector = layer.getAllOutputs();
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            OutputPatternListener outputPatternListener = (OutputPatternListener)vector.elementAt(i);
            if (outputPatternListener == null || !(outputPatternListener instanceof Synapse)) continue;
            Connection connection = this.getSynapse((Synapse)outputPatternListener);
            connection.setInput(n + 1);
            connection.setInpIndex(i);
        }
    }

    private Connection getSynapse(Synapse synapse) {
        Connection connection = (Connection)this.synTemp.get(synapse);
        if (connection == null) {
            connection = new Connection();
            connection.setSynapse(synapse);
            this.synTemp.put(synapse, connection);
        }
        return connection;
    }

    public ArrayList getLayers() {
        return this.layers;
    }

    public void setLayers(ArrayList arrayList) {
        this.layers = arrayList;
    }

    public ArrayList getConnectionSet() {
        return this.connectionSet;
    }

    public void setConnectionSet(ArrayList arrayList) {
        this.connectionSet = arrayList;
    }

    public Monitor getMonitor() {
        return this.monitor;
    }

    public void setMonitor(Monitor monitor) {
        this.monitor = monitor;
    }

    public Layer getInputLayer() {
        return this.inputLayer;
    }

    public void setInputLayer(Layer layer) {
        this.inputLayer = layer;
    }

    public Layer getOutputLayer() {
        return this.outputLayer;
    }

    public void setOutputLayer(Layer layer) {
        this.outputLayer = layer;
    }

    public int getNumLayers() {
        return this.layers.size();
    }

    public int getInputLayerInd() {
        if (this.inputLayerInd == -1) {
            this.inputLayerInd = this.getLayerInd(this.inputLayer);
        }
        return this.inputLayerInd;
    }

    public int getOutputLayerInd() {
        if (this.outputLayerInd == -1) {
            this.outputLayerInd = this.getLayerInd(this.outputLayer);
        }
        return this.outputLayerInd;
    }

    public int getLayerInd(Layer layer) {
        int n = -1;
        for (int i = 0; i < this.layers.size(); ++i) {
            Layer layer2 = (Layer)this.layers.get(i);
            if (layer2 != layer) continue;
            n = i;
            break;
        }
        return n;
    }
}

