/*
 * Decompiled with CFR 0.152.
 */
package org.joone.helpers.factory;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.TreeSet;
import java.util.Vector;
import org.joone.engine.DelayLayer;
import org.joone.engine.DirectSynapse;
import org.joone.engine.FullSynapse;
import org.joone.engine.GaussianLayer;
import org.joone.engine.KohonenSynapse;
import org.joone.engine.Layer;
import org.joone.engine.LinearLayer;
import org.joone.engine.Monitor;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.NeuralNetListener;
import org.joone.engine.Pattern;
import org.joone.engine.SigmoidLayer;
import org.joone.engine.SoftmaxLayer;
import org.joone.engine.Synapse;
import org.joone.engine.WTALayer;
import org.joone.engine.learning.ComparingSynapse;
import org.joone.engine.learning.TeachingSynapse;
import org.joone.engine.listeners.ErrorBasedTerminator;
import org.joone.helpers.factory.ImmediateDirectSynapse;
import org.joone.io.MemoryInputSynapse;
import org.joone.io.MemoryOutputSynapse;
import org.joone.io.StreamInputSynapse;
import org.joone.net.NetCheck;
import org.joone.net.NeuralNet;
import org.joone.net.NeuralNetAttributes;

public class JooneTools {
    public static final int LINEAR = 1;
    public static final int LOGISTIC = 2;
    public static final int SOFTMAX = 3;
    public static final int WTA = 4;
    public static final int GAUSSIAN = 5;
    public static final int BPROP_ONLINE = 0;
    public static final int BPROP_BATCH = 1;
    public static final int RPROP = 2;

    public static NeuralNet create_standard(int[] nArray, int n) throws IllegalArgumentException {
        int n2;
        NeuralNet neuralNet = new NeuralNet();
        if (nArray == null || nArray.length < 2) {
            throw new IllegalArgumentException("create_standard: Nodes is empty");
        }
        Layer[] layerArray = new Layer[nArray.length];
        layerArray[0] = new LinearLayer();
        layerArray[0].setRows(nArray[0]);
        layerArray[0].setLayerName("input");
        neuralNet.addLayer(layerArray[0], 0);
        if (nArray.length > 2) {
            for (n2 = 1; n2 < nArray.length - 1; ++n2) {
                layerArray[n2] = new SigmoidLayer();
                layerArray[n2].setRows(nArray[n2]);
                layerArray[n2].setLayerName("hidden" + n2);
                neuralNet.addLayer(layerArray[n2], 1);
            }
        }
        n2 = nArray.length - 1;
        switch (n) {
            case 1: {
                layerArray[n2] = new LinearLayer();
                break;
            }
            case 2: {
                layerArray[n2] = new SigmoidLayer();
                break;
            }
            case 3: {
                layerArray[n2] = new SoftmaxLayer();
                break;
            }
            default: {
                throw new IllegalArgumentException("create_standard: output type not supported");
            }
        }
        layerArray[n2].setRows(nArray[n2]);
        layerArray[n2].setLayerName("output");
        neuralNet.addLayer(layerArray[n2], 2);
        for (int i = 0; i < layerArray.length - 1; ++i) {
            JooneTools.connect(layerArray[i], new FullSynapse(), layerArray[i + 1]);
        }
        Monitor monitor = neuralNet.getMonitor();
        monitor.addLearner(0, "org.joone.engine.BasicLearner");
        monitor.addLearner(1, "org.joone.engine.BatchLearner");
        monitor.addLearner(2, "org.joone.engine.RpropLearner");
        monitor.setLearningRate(0.7);
        monitor.setMomentum(0.7);
        return neuralNet;
    }

    public static NeuralNet create_timeDelay(int[] nArray, int n, int n2) throws IllegalArgumentException {
        int n3;
        NeuralNet neuralNet = new NeuralNet();
        if (nArray == null || nArray.length < 2) {
            throw new IllegalArgumentException("create_standard: nodes: not enough elements");
        }
        Layer[] layerArray = new Layer[nArray.length];
        layerArray[0] = new DelayLayer();
        layerArray[0].setRows(nArray[0]);
        ((DelayLayer)layerArray[0]).setTaps(n);
        layerArray[0].setLayerName("input");
        neuralNet.addLayer(layerArray[0], 0);
        if (nArray.length > 2) {
            for (n3 = 1; n3 < nArray.length - 1; ++n3) {
                layerArray[n3] = new SigmoidLayer();
                layerArray[n3].setRows(nArray[n3]);
                layerArray[n3].setLayerName("hidden" + n3);
                neuralNet.addLayer(layerArray[n3], 1);
            }
        }
        n3 = nArray.length - 1;
        switch (n2) {
            case 1: {
                layerArray[n3] = new LinearLayer();
                break;
            }
            case 2: {
                layerArray[n3] = new SigmoidLayer();
                break;
            }
            case 3: {
                layerArray[n3] = new SoftmaxLayer();
                break;
            }
            default: {
                throw new IllegalArgumentException("create_standard: output type not supported");
            }
        }
        layerArray[n3].setRows(nArray[n3]);
        layerArray[n3].setLayerName("output");
        neuralNet.addLayer(layerArray[n3], 2);
        for (int i = 0; i < layerArray.length - 1; ++i) {
            JooneTools.connect(layerArray[i], new FullSynapse(), layerArray[i + 1]);
        }
        Monitor monitor = neuralNet.getMonitor();
        monitor.addLearner(0, "org.joone.engine.BasicLearner");
        monitor.addLearner(1, "org.joone.engine.BatchLearner");
        monitor.addLearner(2, "org.joone.engine.RpropLearner");
        monitor.setLearningRate(0.7);
        monitor.setMomentum(0.7);
        return neuralNet;
    }

    public static NeuralNet create_unsupervised(int[] nArray, int n) throws IllegalArgumentException {
        NeuralNet neuralNet = new NeuralNet();
        if (nArray == null || nArray.length < 3) {
            throw new IllegalArgumentException("create_unsupervised: nodes: not enough elements");
        }
        Layer[] layerArray = new Layer[2];
        layerArray[0] = new LinearLayer();
        layerArray[0].setRows(nArray[0]);
        layerArray[0].setLayerName("input");
        neuralNet.addLayer(layerArray[0], 0);
        switch (n) {
            case 4: {
                layerArray[1] = new WTALayer();
                ((WTALayer)layerArray[1]).setLayerWidth(nArray[1]);
                ((WTALayer)layerArray[1]).setLayerHeight(nArray[2]);
                break;
            }
            case 5: {
                layerArray[1] = new GaussianLayer();
                ((GaussianLayer)layerArray[1]).setLayerWidth(nArray[1]);
                ((GaussianLayer)layerArray[1]).setLayerHeight(nArray[2]);
                break;
            }
            default: {
                throw new IllegalArgumentException("create_unsupervised: output type not supported");
            }
        }
        layerArray[1].setLayerName("output");
        neuralNet.addLayer(layerArray[1], 2);
        JooneTools.connect(layerArray[0], new KohonenSynapse(), layerArray[1]);
        Monitor monitor = neuralNet.getMonitor();
        monitor.setLearningRate(0.7);
        return neuralNet;
    }

    public static double[] interrogate(NeuralNet neuralNet, double[] dArray) {
        neuralNet.removeAllInputs();
        neuralNet.removeAllOutputs();
        DirectSynapse directSynapse = new DirectSynapse();
        ImmediateDirectSynapse immediateDirectSynapse = new ImmediateDirectSynapse();
        neuralNet.addInputSynapse(directSynapse);
        neuralNet.addOutputSynapse(immediateDirectSynapse);
        Pattern pattern = new Pattern(dArray);
        pattern.setCount(1);
        neuralNet.getMonitor().setLearning(false);
        boolean bl = neuralNet.getMonitor().isSingleThreadMode();
        neuralNet.singleStepForward(pattern);
        double[] dArray2 = immediateDirectSynapse.getResult();
        neuralNet.getMonitor().setSingleThreadMode(bl);
        return dArray2;
    }

    public static double train(NeuralNet neuralNet, double[][] dArray, double[][] dArray2, int n, double d, int n2, Object object, boolean bl) {
        Monitor monitor;
        MemoryInputSynapse memoryInputSynapse = new MemoryInputSynapse();
        memoryInputSynapse.setInputArray(dArray);
        memoryInputSynapse.setAdvancedColumnSelector("1-" + dArray[0].length);
        MemoryInputSynapse memoryInputSynapse2 = null;
        if (dArray2 != null) {
            memoryInputSynapse2 = new MemoryInputSynapse();
            memoryInputSynapse2.setInputArray(dArray2);
            memoryInputSynapse2.setAdvancedColumnSelector("1-" + dArray2[0].length);
        }
        if ((monitor = neuralNet.getMonitor()).isValidation()) {
            if (monitor.getValidationPatterns() == 0) {
                monitor.setValidationPatterns(dArray.length);
            }
        } else if (monitor.getTrainingPatterns() == 0) {
            monitor.setTrainingPatterns(dArray.length);
        }
        return JooneTools.train_on_stream(neuralNet, memoryInputSynapse, memoryInputSynapse2, n, d, n2, object, bl);
    }

    public static void train_unsupervised(NeuralNet neuralNet, double[][] dArray, int n, int n2, Object object, boolean bl) {
        neuralNet.getMonitor().setSupervised(false);
        JooneTools.train(neuralNet, dArray, null, n, 0.0, n2, object, bl);
    }

    public static double train_on_stream(NeuralNet neuralNet, StreamInputSynapse streamInputSynapse, StreamInputSynapse streamInputSynapse2, int n, double d, int n2, Object object, boolean bl) {
        neuralNet.removeAllInputs();
        neuralNet.removeAllOutputs();
        neuralNet.addInputSynapse(streamInputSynapse);
        if (streamInputSynapse2 != null) {
            TeachingSynapse teachingSynapse = new TeachingSynapse();
            teachingSynapse.setDesired(streamInputSynapse2);
            neuralNet.addOutputSynapse(teachingSynapse);
            neuralNet.setTeacher(teachingSynapse);
        }
        return JooneTools.train_complete(neuralNet, n, d, n2, object, bl);
    }

    public static double train_complete(NeuralNet neuralNet, int n, double d, int n2, Object object, boolean bl) {
        neuralNet.removeAllListeners();
        Monitor monitor = neuralNet.getMonitor();
        if (object != null) {
            monitor.addNeuralNetListener(JooneTools.createListener(neuralNet, object, n2));
        }
        ErrorBasedTerminator errorBasedTerminator = null;
        if (d > 0.0) {
            errorBasedTerminator = new ErrorBasedTerminator(d);
            errorBasedTerminator.setNeuralNet(neuralNet);
            monitor.addNeuralNetListener(errorBasedTerminator);
        }
        monitor.setTotCicles(n);
        monitor.setLearning(!monitor.isValidation());
        TreeSet treeSet = neuralNet.check();
        if (treeSet.isEmpty() || !JooneTools.errorsFound(treeSet)) {
            neuralNet.go(!bl);
            if (bl) {
                return 0.0;
            }
            NeuralNetAttributes neuralNetAttributes = neuralNet.getDescriptor();
            if (errorBasedTerminator != null) {
                if (errorBasedTerminator.isStopRequestPerformed()) {
                    neuralNetAttributes.setLastEpoch(errorBasedTerminator.getStoppedCycle());
                } else {
                    neuralNetAttributes.setLastEpoch(monitor.getTotCicles());
                }
            }
            if (monitor.isValidation()) {
                neuralNetAttributes.setValidationError(monitor.getGlobalError());
            } else {
                neuralNetAttributes.setTrainingError(monitor.getGlobalError());
            }
            return monitor.getGlobalError();
        }
        throw new IllegalArgumentException("Cannot start, errors found:" + treeSet.toString());
    }

    protected static boolean errorsFound(TreeSet treeSet) {
        boolean bl = false;
        for (NetCheck netCheck : treeSet) {
            if (!netCheck.isFatal()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static double test(NeuralNet neuralNet, double[][] dArray, double[][] dArray2) {
        neuralNet.getMonitor().setValidation(true);
        return JooneTools.train(neuralNet, dArray, dArray2, 1, 0.0, 0, null, false);
    }

    public static double test_on_stream(NeuralNet neuralNet, StreamInputSynapse streamInputSynapse, StreamInputSynapse streamInputSynapse2) {
        neuralNet.getMonitor().setValidation(true);
        return JooneTools.train_on_stream(neuralNet, streamInputSynapse, streamInputSynapse2, 1, 0.0, 0, null, false);
    }

    public static double[][] compare(NeuralNet neuralNet, double[][] dArray, double[][] dArray2) {
        MemoryInputSynapse memoryInputSynapse = new MemoryInputSynapse();
        memoryInputSynapse.setInputArray(dArray);
        memoryInputSynapse.setAdvancedColumnSelector("1-" + dArray[0].length);
        MemoryInputSynapse memoryInputSynapse2 = null;
        if (dArray2 != null) {
            memoryInputSynapse2 = new MemoryInputSynapse();
            memoryInputSynapse2.setInputArray(dArray2);
            memoryInputSynapse2.setAdvancedColumnSelector("1-" + dArray2[0].length);
        }
        Monitor monitor = neuralNet.getMonitor();
        neuralNet.getMonitor().setValidation(true);
        if (monitor.getValidationPatterns() == 0) {
            monitor.setValidationPatterns(dArray.length);
        }
        return JooneTools.compare_on_stream(neuralNet, memoryInputSynapse, memoryInputSynapse2);
    }

    public static double[][] compare_on_stream(NeuralNet neuralNet, StreamInputSynapse streamInputSynapse, StreamInputSynapse streamInputSynapse2) {
        neuralNet.removeAllInputs();
        neuralNet.removeAllOutputs();
        neuralNet.addInputSynapse(streamInputSynapse);
        ComparingSynapse comparingSynapse = new ComparingSynapse();
        comparingSynapse.setDesired(streamInputSynapse2);
        neuralNet.addOutputSynapse(comparingSynapse);
        MemoryOutputSynapse memoryOutputSynapse = new MemoryOutputSynapse();
        comparingSynapse.addResultSynapse(memoryOutputSynapse);
        JooneTools.train_complete(neuralNet, 1, 0.0, 0, null, false);
        Vector vector = memoryOutputSynapse.getAllPatterns();
        int n = vector.size();
        int n2 = ((Pattern)vector.get(0)).getArray().length;
        double[][] dArray = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            dArray[i] = ((Pattern)vector.get(i)).getArray();
        }
        return dArray;
    }

    public static double[][] getDataFromStream(StreamInputSynapse streamInputSynapse, int n, int n2, int n3, int n4) {
        streamInputSynapse.Inspections();
        Vector vector = streamInputSynapse.getInputPatterns();
        int n5 = n2 - n + 1;
        int n6 = n4 - n3 + 1;
        double[][] dArray = new double[n5][n6];
        for (int i = 0; i < n5; ++i) {
            double[] dArray2 = ((Pattern)vector.get(i + n - 1)).getArray();
            for (int j = 0; j < n6; ++j) {
                dArray[i][j] = dArray2[j + n3 - 1];
            }
        }
        return dArray;
    }

    public static void save(NeuralNet neuralNet, String string) throws FileNotFoundException, IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        JooneTools.save_toStream(neuralNet, fileOutputStream);
    }

    public static void save(NeuralNet neuralNet, File file) throws FileNotFoundException, IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        JooneTools.save_toStream(neuralNet, fileOutputStream);
    }

    public static void save_toStream(NeuralNet neuralNet, OutputStream outputStream) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeObject(neuralNet);
        objectOutputStream.close();
    }

    public static NeuralNet load(String string) throws FileNotFoundException, IOException, ClassNotFoundException {
        File file = new File(string);
        FileInputStream fileInputStream = new FileInputStream(file);
        NeuralNet neuralNet = JooneTools.load_fromStream(fileInputStream);
        fileInputStream.close();
        return neuralNet;
    }

    public static NeuralNet load_fromStream(InputStream inputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        NeuralNet neuralNet = (NeuralNet)objectInputStream.readObject();
        objectInputStream.close();
        return neuralNet;
    }

    protected static void connect(Layer layer, Synapse synapse, Layer layer2) {
        layer.addOutputSynapse(synapse);
        layer2.addInputSynapse(synapse);
    }

    protected static Pattern stopPattern(int n) {
        Pattern pattern = Pattern.makeStopPattern(n);
        return pattern;
    }

    protected static NeuralNetListener createListener(final NeuralNet neuralNet, final Object object, final int n) {
        NeuralNetListener neuralNetListener = new NeuralNetListener(){
            Object output;
            int interv;
            NeuralNet neuralNet;
            {
                this.output = object;
                this.interv = n;
                this.neuralNet = neuralNet;
            }

            public void netStarted(NeuralNetEvent neuralNetEvent) {
                if (this.output == null) {
                    return;
                }
                if (this.output instanceof PrintStream) {
                    ((PrintStream)this.output).println("Network started");
                } else if (this.output instanceof NeuralNetListener) {
                    neuralNetEvent.setNeuralNet(this.neuralNet);
                    ((NeuralNetListener)this.output).netStarted(neuralNetEvent);
                }
            }

            public void cicleTerminated(NeuralNetEvent neuralNetEvent) {
                if (this.output == null) {
                    return;
                }
                Monitor monitor = (Monitor)neuralNetEvent.getSource();
                int n2 = monitor.getCurrentCicle() - 1;
                if (n == 0 || n2 % n > 0) {
                    return;
                }
                if (this.output instanceof PrintStream) {
                    ((PrintStream)this.output).print("Epoch n." + (monitor.getTotCicles() - n2) + " terminated");
                    if (monitor.isSupervised()) {
                        ((PrintStream)this.output).print(" - rmse: " + monitor.getGlobalError());
                    }
                    ((PrintStream)this.output).println("");
                } else if (this.output instanceof NeuralNetListener) {
                    neuralNetEvent.setNeuralNet(this.neuralNet);
                    ((NeuralNetListener)this.output).cicleTerminated(neuralNetEvent);
                }
            }

            public void errorChanged(NeuralNetEvent neuralNetEvent) {
                if (this.output == null) {
                    return;
                }
                Monitor monitor = (Monitor)neuralNetEvent.getSource();
                int n2 = monitor.getCurrentCicle() - 1;
                if (n == 0 || n2 % n > 0) {
                    return;
                }
                if (this.output instanceof NeuralNetListener) {
                    neuralNetEvent.setNeuralNet(this.neuralNet);
                    ((NeuralNetListener)this.output).errorChanged(neuralNetEvent);
                }
            }

            public void netStopped(NeuralNetEvent neuralNetEvent) {
                if (this.output == null) {
                    return;
                }
                if (this.output instanceof PrintStream) {
                    ((PrintStream)this.output).println("Network stopped");
                } else if (this.output instanceof NeuralNetListener) {
                    neuralNetEvent.setNeuralNet(this.neuralNet);
                    ((NeuralNetListener)this.output).netStopped(neuralNetEvent);
                }
            }

            public void netStoppedError(NeuralNetEvent neuralNetEvent, String string) {
                if (this.output == null) {
                    return;
                }
                if (this.output instanceof PrintStream) {
                    ((PrintStream)this.output).println("Network stopped with error:" + string);
                } else if (this.output instanceof NeuralNetListener) {
                    neuralNetEvent.setNeuralNet(this.neuralNet);
                    ((NeuralNetListener)this.output).netStoppedError(neuralNetEvent, string);
                }
            }
        };
        return neuralNetListener;
    }
}

