/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine.weights;

import org.joone.engine.Matrix;
import org.joone.engine.weights.WeightInitializer;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;

public class RandomWeightInitializer
implements WeightInitializer {
    private static final ILogger log = LoggerFactory.getLogger(RandomWeightInitializer.class);
    private static final long serialVersionUID = 1547731234507850525L;
    private double upperBound = 0.0;
    private double lowerBound = 0.0;

    public RandomWeightInitializer(double d) {
        if (d < 0.0) {
            log.warn("Boundary smaller than zero. Domain set to [" + d + ", " + -d + "].");
            d = Math.abs(d);
        }
        this.upperBound = d;
        this.lowerBound = -d;
    }

    public RandomWeightInitializer(double d, double d2) {
        if (d > d2) {
            log.warn("Lower bound is larger than upper bound. Domain set to [" + d2 + ", " + d + "].");
            this.upperBound = d;
            this.lowerBound = d2;
        } else {
            this.upperBound = d2;
            this.lowerBound = d;
        }
    }

    public void initialize(Matrix matrix) {
        for (int i = 0; i < matrix.getM_rows(); ++i) {
            for (int j = 0; j < matrix.getM_cols(); ++j) {
                if (!matrix.enabled[i][j] || matrix.fixed[i][j]) continue;
                matrix.value[i][j] = this.lowerBound + Math.random() * (this.upperBound - this.lowerBound);
            }
        }
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(double d) {
        this.lowerBound = d;
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(double d) {
        this.upperBound = d;
    }
}

