/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine.listeners;

import org.joone.engine.Layer;
import org.joone.engine.Matrix;
import org.joone.engine.Monitor;
import org.joone.engine.Synapse;
import org.joone.engine.listeners.ConvergenceObserver;
import org.joone.net.NeuralNet;

public class DeltaBasedConvergenceObserver
extends ConvergenceObserver {
    private double size = 0.0;
    private int cycles = 5;
    private int cycleCounter = 0;
    private NeuralNet net;

    public void setSize(double d) {
        this.size = d;
    }

    public double getSize() {
        return this.size;
    }

    public void setCycles(int n) {
        this.cycles = n;
    }

    public int getCycles() {
        return this.cycles;
    }

    public void setNeuralNet(NeuralNet neuralNet) {
        this.net = neuralNet;
    }

    public NeuralNet getNeuralNet() {
        return this.net;
    }

    protected void manageStop(Monitor monitor) {
    }

    protected void manageCycle(Monitor monitor) {
    }

    protected void manageStart(Monitor monitor) {
    }

    protected void manageError(Monitor monitor) {
        if (this.cycles <= 0) {
            return;
        }
        for (int i = 0; i < this.net.getLayers().size(); ++i) {
            int n;
            Layer layer = (Layer)this.net.getLayers().get(i);
            Matrix matrix = layer.getBias();
            for (n = 0; n < matrix.getM_rows(); ++n) {
                if (matrix == null || this.isConvergence(matrix)) continue;
                this.cycleCounter = 0;
                this.disableCurrentConvergence = false;
                return;
            }
            for (n = 0; n < layer.getAllOutputs().size(); ++n) {
                Matrix matrix2;
                if (!(layer.getAllOutputs().get(n) instanceof Synapse) || (matrix2 = ((Synapse)layer.getAllOutputs().get(n)).getWeights()) == null || this.isConvergence(matrix2)) continue;
                this.cycleCounter = 0;
                this.disableCurrentConvergence = false;
                return;
            }
        }
        ++this.cycleCounter;
        if (this.cycleCounter == this.cycles) {
            if (!this.disableCurrentConvergence) {
                this.fireNetConverged(monitor);
            }
            this.cycleCounter = 0;
        }
    }

    protected boolean isConvergence(Matrix matrix) {
        for (int i = 0; i < matrix.getM_rows(); ++i) {
            for (int j = 0; j < matrix.getM_cols(); ++j) {
                if (!(Math.abs(matrix.delta[i][j]) > this.size)) continue;
                return false;
            }
        }
        return true;
    }

    protected void manageStopError(Monitor monitor, String string) {
    }
}

