/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine.learning;

import java.util.TreeSet;
import org.joone.engine.LinearLayer;
import org.joone.engine.Monitor;
import org.joone.engine.OutputPatternListener;
import org.joone.engine.Pattern;
import org.joone.engine.learning.AbstractTeacherSynapse;
import org.joone.engine.learning.ComparingElement;
import org.joone.engine.learning.TeacherSynapse;
import org.joone.io.StreamInputSynapse;
import org.joone.io.StreamOutputSynapse;
import org.joone.net.NetCheck;

public class TeachingSynapse
implements ComparingElement {
    protected AbstractTeacherSynapse theTeacherSynapse;
    private LinearLayer theLinearLayer;
    private boolean enabled = true;
    private boolean outputFull = false;
    private AbstractTeacherSynapse theTeacherToUse = null;
    private StreamInputSynapse desired;
    private Monitor monitor;
    private String name;
    private static final long serialVersionUID = -8893181016305737666L;

    public TeachingSynapse() {
    }

    public TeachingSynapse(TeacherSynapse teacherSynapse) {
        this.theTeacherToUse = teacherSynapse;
    }

    public void fwdPut(Pattern pattern) {
        Monitor monitor = this.getMonitor();
        if (!monitor.isLearning() && !monitor.isValidation()) {
            return;
        }
        if (!monitor.isSingleThreadMode() && !this.getTheLinearLayer().isRunning()) {
            this.getTheLinearLayer().start();
        }
        boolean bl = this.getTheTeacherSynapse().getSeenPatterns() == 0;
        this.getTheTeacherSynapse().fwdPut(pattern);
        if (monitor.isSingleThreadMode()) {
            if (pattern.isMarkedAsStoppingPattern()) {
                this.getTheLinearLayer().fwdRun(null);
                this.getTheLinearLayer().fwdRun(null);
            }
            if (pattern.getCount() == 1 && !bl) {
                this.getTheLinearLayer().fwdRun(null);
            }
        }
    }

    public StreamInputSynapse getDesired() {
        return this.desired;
    }

    public int getInputDimension() {
        return this.getTheTeacherSynapse().getInputDimension();
    }

    public Monitor getMonitor() {
        return this.monitor;
    }

    public LinearLayer getTheLinearLayer() {
        if (this.theLinearLayer == null) {
            this.theLinearLayer = new LinearLayer();
            this.theLinearLayer.setLayerName("(R)MSE Layer");
            if (this.monitor != null) {
                this.theLinearLayer.setMonitor(this.monitor);
            }
            this.theLinearLayer.setRows(1);
            this.theLinearLayer.addInputSynapse(this.getTheTeacherSynapse());
        }
        return this.theLinearLayer;
    }

    public AbstractTeacherSynapse getTheTeacherSynapse() {
        if (this.theTeacherSynapse == null) {
            if (this.theTeacherToUse != null) {
                this.theTeacherSynapse = this.theTeacherToUse;
            } else {
                this.theTeacherSynapse = new TeacherSynapse();
                this.theTeacherSynapse.setName("Teacher Synapse");
            }
            if (this.monitor != null) {
                this.theTeacherSynapse.setMonitor(this.monitor);
            }
        }
        return this.theTeacherSynapse;
    }

    public Pattern revGet() {
        return this.getTheTeacherSynapse().revGet();
    }

    public boolean setDesired(StreamInputSynapse streamInputSynapse) {
        this.desired = streamInputSynapse;
        if (this.getTheTeacherSynapse().setDesired(streamInputSynapse)) {
            if (this.monitor != null && this.desired != null) {
                this.desired.setMonitor(this.monitor);
            }
            return true;
        }
        return false;
    }

    public boolean addResultSynapse(OutputPatternListener outputPatternListener) {
        if (outputPatternListener != null) {
            return this.getTheLinearLayer().addOutputSynapse(outputPatternListener);
        }
        return false;
    }

    public void removeResultSynapse(OutputPatternListener outputPatternListener) {
        if (outputPatternListener != null) {
            this.getTheLinearLayer().removeOutputSynapse(outputPatternListener);
        }
    }

    public void setInputDimension(int n) {
        this.getTheTeacherSynapse().setInputDimension(n);
    }

    public void setMonitor(Monitor monitor) {
        this.monitor = monitor;
        if (this.theTeacherSynapse != null) {
            this.theTeacherSynapse.setMonitor(monitor);
        }
        if (this.theLinearLayer != null) {
            this.theLinearLayer.setMonitor(monitor);
        }
        if (this.desired != null) {
            this.desired.setMonitor(monitor);
        }
    }

    public void stop() {
        this.getTheLinearLayer().stop();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    protected void forward(double[] dArray) {
    }

    protected void setArrays(int n, int n2) {
    }

    protected void setDimensions(int n, int n2) {
    }

    protected void backward(double[] dArray) {
    }

    public void setTheTeacherSynapse(TeacherSynapse teacherSynapse) {
        this.theTeacherSynapse = teacherSynapse;
    }

    public void setTheLinearLayer(LinearLayer linearLayer) {
        this.theLinearLayer = linearLayer;
    }

    public void resetInput() {
        this.getTheTeacherSynapse().resetInput();
    }

    public TreeSet check() {
        TreeSet<NetCheck> treeSet = new TreeSet<NetCheck>();
        if (!this.isOutputFull()) {
            treeSet.add(new NetCheck(0, "the Teacher seems to be not attached", this));
        }
        if (this.theLinearLayer != null) {
            treeSet.addAll(this.setErrorSource(this.theLinearLayer.check()));
        }
        if (this.theTeacherSynapse != null) {
            treeSet.addAll(this.setErrorSource(this.theTeacherSynapse.check()));
        }
        return treeSet;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.getTheTeacherSynapse().setEnabled(bl);
        this.enabled = bl;
    }

    public boolean isOutputFull() {
        return this.outputFull;
    }

    public void setOutputFull(boolean bl) {
        this.outputFull = bl;
    }

    public void init() {
        if (this.theTeacherSynapse != null) {
            this.theTeacherSynapse.init();
        }
    }

    private TreeSet setErrorSource(TreeSet treeSet) {
        if (!treeSet.isEmpty()) {
            for (NetCheck netCheck : treeSet) {
                if (netCheck.getSource() instanceof Monitor || netCheck.getSource() instanceof StreamInputSynapse || netCheck.getSource() instanceof StreamOutputSynapse) continue;
                netCheck.setSource(this);
            }
        }
        return treeSet;
    }
}

