/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine.learning;

import org.joone.engine.learning.TeacherSynapse;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;

public class FahlmanTeacherSynapse
extends TeacherSynapse {
    public static final String CRITERION = "FAHLMAN_CRITERION";
    protected static final ILogger log = LoggerFactory.getLogger(FahlmanTeacherSynapse.class);
    private double upperBit = 1.0;
    private double lowerBit = 0.0;
    private double lowerBitPercentage = 0.4;
    private double upperBitPercentage = 0.4;

    public void setUpperBit(double d) {
        this.upperBit = d;
    }

    public double getUpperBit() {
        return this.upperBit;
    }

    public void setLowerBit(double d) {
        this.lowerBit = d;
    }

    public double getLowerBit() {
        return this.lowerBit;
    }

    public void setUpperBitPercentage(double d) {
        this.upperBitPercentage = d;
    }

    public double getUpperBitPercentage() {
        return this.upperBitPercentage;
    }

    public void setLowerBitPercentage(double d) {
        this.lowerBitPercentage = d;
    }

    public double getLowerBitPercentage() {
        return this.lowerBitPercentage;
    }

    protected double calculateError(double d, double d2, int n) {
        if (this.getMonitor().isValidation()) {
            double d3 = this.upperBit - this.lowerBit;
            if (d == this.lowerBit) {
                if (!(d2 >= this.lowerBit) || !(d2 <= this.lowerBit + (d3 *= this.lowerBitPercentage))) {
                    this.getMonitor().setParam(CRITERION, Boolean.FALSE);
                }
            } else if (d == this.upperBit) {
                if (!(d2 >= this.upperBit - (d3 *= this.upperBitPercentage)) || !(d2 <= this.upperBit)) {
                    this.getMonitor().setParam(CRITERION, Boolean.FALSE);
                }
            } else {
                this.warnLogger("The values for upper and/or lower bit are not correctly set. No match for desired output " + d + ".", log);
                this.getMonitor().setParam(CRITERION, Boolean.FALSE);
            }
        }
        return super.calculateError(d, d2, n);
    }
}

