/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine.learning;

import java.io.IOException;
import java.util.TreeSet;
import org.joone.engine.Fifo;
import org.joone.engine.Monitor;
import org.joone.engine.NetErrorManager;
import org.joone.engine.NetStoppedEventNotifier;
import org.joone.engine.Pattern;
import org.joone.engine.Synapse;
import org.joone.io.StreamInputSynapse;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NetCheck;

public abstract class AbstractTeacherSynapse
extends Synapse {
    private static final long serialVersionUID = -3501303723175798936L;
    protected static final ILogger log = LoggerFactory.getLogger(AbstractTeacherSynapse.class);
    private transient boolean firstTime = true;
    private transient int patterns = 0;
    protected StreamInputSynapse desired;
    protected transient Fifo error;
    protected transient int currEpoch = 0;

    public AbstractTeacherSynapse() {
        this.setFirstTime(true);
    }

    protected void setFirstTime(boolean bl) {
        this.firstTime = bl;
    }

    protected boolean isFirstTime() {
        return this.firstTime;
    }

    protected void backward(double[] dArray) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pushError(double d, int n) {
        Pattern pattern = new Pattern(d);
        pattern.setCount(n);
        AbstractTeacherSynapse abstractTeacherSynapse = this;
        synchronized (abstractTeacherSynapse) {
            this.getError().push(pattern);
            this.notify();
        }
    }

    private Fifo getError() {
        if (this.error == null) {
            this.error = new Fifo();
        }
        return this.error;
    }

    protected void stopTheNet() {
        this.pushError(0.0, -1);
        this.patterns = 0;
        this.setFirstTime(true);
        if (this.getMonitor() != null) {
            new NetStoppedEventNotifier(this.getMonitor()).start();
        }
    }

    protected int getSeenPatterns() {
        return this.patterns;
    }

    protected void setSeenPatterns(int n) {
        this.patterns = n;
    }

    protected void incSeenPatterns() {
        ++this.patterns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pattern fwdGet() {
        AbstractTeacherSynapse abstractTeacherSynapse = this;
        synchronized (abstractTeacherSynapse) {
            while (this.getError().empty()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    return null;
                }
            }
            Pattern pattern = (Pattern)this.error.pop();
            this.notify();
            return pattern;
        }
    }

    public StreamInputSynapse getDesired() {
        return this.desired;
    }

    public boolean setDesired(StreamInputSynapse streamInputSynapse) {
        if (streamInputSynapse == null) {
            if (this.desired != null) {
                this.desired.setInputFull(false);
            }
            this.desired = null;
        } else {
            if (streamInputSynapse.isInputFull()) {
                return false;
            }
            this.desired = streamInputSynapse;
            this.desired.setStepCounter(false);
            this.desired.setOutputDimension(this.getInputDimension());
            this.desired.setInputFull(true);
        }
        return true;
    }

    protected Object readResolve() {
        super.readResolve();
        this.setFirstTime(true);
        if (this.getMonitor() != null) {
            this.getMonitor().setSupervised(true);
        }
        return this;
    }

    protected void setArrays(int n, int n2) {
    }

    protected void setDimensions(int n, int n2) {
    }

    public void setInputDimension(int n) {
        super.setInputDimension(n);
        if (this.getDesired() != null) {
            this.getDesired().setOutputDimension(n);
        }
    }

    public void reset() {
        super.reset();
        this.setSeenPatterns(0);
        this.setFirstTime(true);
        if (this.getDesired() != null) {
            this.getDesired().reset();
        }
    }

    public void resetInput() {
        if (this.getDesired() != null) {
            this.getDesired().resetInput();
        }
    }

    public void setMonitor(Monitor monitor) {
        super.setMonitor(monitor);
        if (this.getMonitor() != null) {
            this.getMonitor().setSupervised(true);
        }
    }

    public void netStoppedError() {
        this.pushError(0.0, -1);
        this.setSeenPatterns(0);
        this.setFirstTime(true);
        this.reset();
    }

    public void init() {
        super.init();
        this.setSeenPatterns(0);
        this.setFirstTime(true);
        this.currEpoch = 0;
        this.getError().clear();
        if (this.getDesired() != null) {
            this.getDesired().init();
        }
    }

    public TreeSet check() {
        TreeSet treeSet = super.check();
        if (this.getDesired() == null) {
            treeSet.add(new NetCheck(0, "Desired Input has not been set.", this));
        } else {
            treeSet.addAll(this.getDesired().check());
        }
        return treeSet;
    }

    public void revPut(Pattern pattern) {
    }

    public Pattern revGet() {
        if (this.isEnabled()) {
            return super.fwdGet();
        }
        return null;
    }

    public void fwdPut(Pattern pattern) {
        int n = pattern.getCount();
        boolean bl = pattern.isMarkedAsStoppingPattern();
        if (!(this.getMonitor().isSingleThreadMode() || this.getMonitor() != null && this.isEnabled())) {
            if (bl) {
                this.stopTheNet();
            }
            return;
        }
        super.fwdPut(pattern);
        if (!bl) {
            if (!this.getMonitor().isLearningCicle(n)) {
                this.items = 0;
            }
        } else {
            this.items = 0;
        }
    }

    protected void forward(double[] dArray) {
        double[] dArray2;
        if (this.m_pattern.getCount() == 1 || this.m_pattern.isMarkedAsStoppingPattern()) {
            try {
                this.desired.gotoFirstLine();
                if (!this.isFirstTime() && this.getSeenPatterns() == this.getMonitor().getNumOfPatterns()) {
                    double d = this.calculateGlobalError();
                    ++this.currEpoch;
                    this.pushError(d, this.currEpoch);
                    this.getMonitor().setGlobalError(d);
                    this.epochFinished();
                    this.setSeenPatterns(0);
                }
            }
            catch (IOException iOException) {
                new NetErrorManager(this.getMonitor(), "TeacherSynapse: IOException while forwarding the influx. Message is : " + iOException.getMessage());
                return;
            }
        }
        if (this.m_pattern.isMarkedAsStoppingPattern()) {
            if (!this.getMonitor().isSingleThreadMode()) {
                this.stopTheNet();
            } else {
                this.pushError(0.0, -1);
            }
            return;
        }
        this.setFirstTime(false);
        this.outs = new double[dArray.length];
        Pattern pattern = this.desired.fwdGet();
        if (this.m_pattern.getCount() != pattern.getCount()) {
            try {
                this.desired.gotoLine(this.m_pattern.getCount());
                pattern = this.desired.fwdGet();
                if (this.m_pattern.getCount() != pattern.getCount()) {
                    new NetErrorManager(this.getMonitor(), "TeacherSynapse: No matching patterns - input#" + this.m_pattern.getCount() + " desired#" + pattern.getCount());
                    return;
                }
            }
            catch (IOException iOException) {
                new NetErrorManager(this.getMonitor(), "TeacherSynapse: IOException while forwarding the influx. Message is : " + iOException.getMessage());
                return;
            }
        }
        if (this.getMonitor().getPreLearning() < this.m_pattern.getCount() && (dArray2 = pattern.getArray()) != null) {
            if (dArray2.length != this.outs.length) {
                this.warnLogger("Size output pattern mismatches size desired pattern. Zero-valued desired pattern sized error pattern will be backpropagated.", log);
                this.outs = new double[dArray2.length];
            } else {
                this.constructErrorPattern(dArray2, dArray);
            }
        }
        this.incSeenPatterns();
    }

    protected void constructErrorPattern(double[] dArray, double[] dArray2) {
        for (int i = 0; i < dArray.length; ++i) {
            this.outs[i] = this.calculateError(dArray[i], dArray2[i], i);
        }
    }

    protected abstract double calculateError(double var1, double var3, int var5);

    protected abstract double calculateGlobalError();

    protected void epochFinished() {
    }
}

