/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import org.joone.engine.SimpleLayer;
import org.joone.exception.JooneRuntimeException;
import org.joone.inspection.implementations.BiasInspection;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NetCheck;

public class WTALayer
extends SimpleLayer {
    private static final ILogger log = LoggerFactory.getLogger(WTALayer.class);
    private static final long serialVersionUID = -941653911909171430L;
    private int LayerWidth = 1;
    private int LayerHeight = 1;
    private int LayerDepth = 1;

    public WTALayer() {
    }

    public WTALayer(String string) {
        super(string);
    }

    public void backward(double[] dArray) throws JooneRuntimeException {
    }

    public void forward(double[] dArray) throws JooneRuntimeException {
        int n = 0;
        int n2 = 0;
        double d = Double.MAX_VALUE;
        int n3 = this.getRows();
        try {
            for (n = 0; n < n3; ++n) {
                double d2 = dArray[n];
                if (!(d2 < d)) continue;
                d = d2;
                n2 = n;
            }
            for (n = 0; n < n3; ++n) {
                this.outs[n] = n == n2 ? 1.0 : 0.0;
            }
        }
        catch (Exception exception) {
            String string = "Exception thrown while processing the element " + n + " of the array. Value is : " + dArray[n] + " Exception thrown is " + exception.getClass().getName() + ". Message is " + exception.getMessage();
            log.error(string);
            throw new JooneRuntimeException(string, exception);
        }
    }

    public int getLayerDepth() {
        return this.LayerDepth;
    }

    public void setLayerDepth(int n) {
        if (n != this.getLayerDepth()) {
            this.LayerDepth = n;
            this.setRows(this.getLayerWidth() * this.getLayerHeight() * this.getLayerDepth());
            this.setDimensions();
            this.setConnDimensions();
        }
    }

    public int getLayerHeight() {
        return this.LayerHeight;
    }

    public void setLayerHeight(int n) {
        if (n != this.getLayerHeight()) {
            this.LayerHeight = n;
            this.setRows(this.getLayerWidth() * this.getLayerHeight() * this.getLayerDepth());
            this.setDimensions();
            this.setConnDimensions();
        }
    }

    public int getLayerWidth() {
        return this.LayerWidth;
    }

    public void setLayerWidth(int n) {
        if (n != this.getLayerWidth()) {
            this.LayerWidth = n;
            this.setRows(this.getLayerWidth() * this.getLayerHeight() * this.getLayerDepth());
            this.setDimensions();
            this.setConnDimensions();
        }
    }

    public TreeSet check() {
        TreeSet treeSet = super.check();
        if (this.getLayerWidth() < 1) {
            treeSet.add(new NetCheck(0, "Layer width should be greater than or equal to 1.", this));
        }
        if (this.getLayerHeight() < 1) {
            treeSet.add(new NetCheck(0, "Layer height should be greater than or equal to 1.", this));
        }
        if (this.getLayerDepth() < 1) {
            treeSet.add(new NetCheck(0, "Layer depth should be greater than or equal to 1.", this));
        }
        return treeSet;
    }

    public Collection Inspections() {
        ArrayList<BiasInspection> arrayList = new ArrayList<BiasInspection>();
        arrayList.add(new BiasInspection(null));
        return arrayList;
    }
}

