/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine;

import org.joone.engine.LearnableLayer;
import org.joone.engine.Learner;
import org.joone.engine.SimpleLayer;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;

public class TanhLayer
extends SimpleLayer
implements LearnableLayer {
    private static final long serialVersionUID = -2073914754873517298L;
    private static final ILogger log = LoggerFactory.getLogger(TanhLayer.class);
    private double flatSpotConstant = 0.0;

    public TanhLayer() {
        this.learnable = true;
    }

    public TanhLayer(String string) {
        this();
        this.setLayerName(string);
    }

    public void backward(double[] dArray) {
        super.backward(dArray);
        int n = this.getRows();
        double d = this.getFlatSpotConstant();
        for (int i = 0; i < n; ++i) {
            this.gradientOuts[i] = dArray[i] * ((1.0 + this.outs[i]) * (1.0 - this.outs[i]) + d);
        }
        this.myLearner.requestBiasUpdate(this.gradientOuts);
    }

    public void forward(double[] dArray) {
        int n = this.getRows();
        for (int i = 0; i < n; ++i) {
            this.outs[i] = -1.0 + 2.0 / (1.0 + Math.exp(-2.0 * (dArray[i] + this.bias.value[i][0])));
        }
    }

    public Learner getLearner() {
        this.learnable = true;
        return super.getLearner();
    }

    public void setFlatSpotConstant(double d) {
        this.flatSpotConstant = d;
    }

    public double getFlatSpotConstant() {
        return this.flatSpotConstant;
    }
}

