/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import org.joone.engine.InputPatternListener;
import org.joone.engine.LearnableSynapse;
import org.joone.engine.Learner;
import org.joone.engine.Matrix;
import org.joone.engine.Monitor;
import org.joone.engine.OutputPatternListener;
import org.joone.engine.Pattern;
import org.joone.inspection.Inspectable;
import org.joone.inspection.implementations.WeightsInspection;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;

public abstract class Synapse
implements InputPatternListener,
OutputPatternListener,
LearnableSynapse,
Serializable,
Inspectable {
    private static final ILogger log = LoggerFactory.getLogger(Synapse.class);
    private static int synapseCount = 0;
    private String fieldName = "Synapse " + ++synapseCount;
    private double learningRate = 0.0;
    private double momentum = 0.0;
    private int inputDimension = 0;
    private int outputDimension = 0;
    private boolean inputFull;
    private boolean outputFull;
    private Monitor monitor;
    private int ignoreBefore = -1;
    private boolean loopBack = false;
    protected Matrix array;
    protected int m_batch = 0;
    protected boolean enabled = true;
    protected transient double[] inps = null;
    protected transient double[] outs = null;
    protected transient double[] bouts;
    protected transient int items = 0;
    protected transient int bitems = 0;
    protected transient Pattern m_pattern;
    protected transient Pattern b_pattern;
    protected transient int count = 0;
    protected transient boolean notFirstTime;
    protected transient boolean notFirstTimeB;
    protected transient Learner myLearner = null;
    protected volatile transient Object fwdLock = new Object();
    protected volatile transient Object revLock = new Object();
    protected boolean learnable = false;
    private static final long serialVersionUID = -5892822057908231022L;

    public void addNoise(double d) {
        if (this.array == null) {
            this.warnLogger("Cannot add noise because weight array is null.", log);
        } else {
            this.array.addNoise(d);
        }
    }

    public void randomize(double d) {
        if (this.array == null) {
            this.warnLogger("Cannot randomize weights because weight array is null.", log);
            return;
        }
        this.array.randomizeConditionally(d);
    }

    protected abstract void backward(double[] var1);

    public boolean canCountSteps() {
        return false;
    }

    protected abstract void forward(double[] var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pattern fwdGet() {
        Object object;
        if (!this.isEnabled()) {
            return null;
        }
        Object object2 = object = this.getFwdLock();
        synchronized (object2) {
            if (this.notFirstTime || !this.loopBack) {
                while (this.items == 0) {
                    try {
                        object.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        this.reset();
                        object.notify();
                        return null;
                    }
                }
                --this.items;
                Pattern pattern = this.fwdPattern_produce();
                object.notify();
                return pattern;
            }
            this.count = 0;
            this.bitems = 0;
            this.items = 0;
            this.notFirstTime = true;
            object.notify();
            return null;
        }
    }

    protected Pattern fwdPattern_produce() {
        this.m_pattern.setArray(this.outs);
        if (this.isLoopBack()) {
            this.m_pattern.setCount(0);
        }
        return this.m_pattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fwdPut(Pattern pattern) {
        Object object;
        if (!this.isEnabled()) {
            return;
        }
        Object object2 = object = this.getFwdLock();
        synchronized (object2) {
            while (this.items > 0) {
                try {
                    object.wait();
                }
                catch (InterruptedException interruptedException) {
                    this.reset();
                    object.notify();
                    return;
                }
            }
            this.fwdPattern_consume(pattern);
            ++this.items;
            object.notify();
        }
    }

    protected void fwdPattern_consume(Pattern pattern) {
        this.m_pattern = pattern;
        this.count = this.m_pattern.getCount();
        this.inps = pattern.getArray();
        this.forward(this.inps);
    }

    public void reset() {
        this.bitems = 0;
        this.items = 0;
        this.notFirstTime = false;
        this.notFirstTimeB = false;
    }

    public int getIgnoreBefore() {
        return this.ignoreBefore;
    }

    public int getInputDimension() {
        return this.inputDimension;
    }

    public double getLearningRate() {
        if (this.monitor != null) {
            return this.monitor.getLearningRate();
        }
        return 0.0;
    }

    public double getMomentum() {
        if (this.monitor != null) {
            return this.monitor.getMomentum();
        }
        return 0.0;
    }

    public Monitor getMonitor() {
        return this.monitor;
    }

    public String getName() {
        return this.fieldName;
    }

    public int getOutputDimension() {
        return this.outputDimension;
    }

    protected Object readResolve() {
        this.setArrays(this.getInputDimension(), this.getOutputDimension());
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pattern revGet() {
        Object object;
        if (!this.isEnabled()) {
            return null;
        }
        Object object2 = object = this.getRevLock();
        synchronized (object2) {
            if (this.notFirstTimeB || !this.loopBack) {
                while (this.bitems == 0) {
                    try {
                        object.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        this.reset();
                        object.notify();
                        return null;
                    }
                }
                --this.bitems;
                Pattern pattern = this.revPattern_consume();
                object.notify();
                return pattern;
            }
            object.notify();
            return null;
        }
    }

    protected Pattern revPattern_consume() {
        this.b_pattern.setArray(this.bouts);
        return this.b_pattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revPut(Pattern pattern) {
        Object object;
        if (!this.isEnabled()) {
            return;
        }
        Object object2 = object = this.getRevLock();
        synchronized (object2) {
            while (this.bitems > 0) {
                try {
                    object.wait();
                }
                catch (InterruptedException interruptedException) {
                    this.reset();
                    object.notify();
                    return;
                }
            }
            this.revPattern_produce(pattern);
            ++this.bitems;
            this.notFirstTimeB = true;
            object.notify();
        }
    }

    protected void revPattern_produce(Pattern pattern) {
        this.b_pattern = pattern;
        this.count = this.b_pattern.getCount();
        this.backward(pattern.getArray());
    }

    protected abstract void setArrays(int var1, int var2);

    protected abstract void setDimensions(int var1, int var2);

    public void setIgnoreBefore(int n) {
        this.ignoreBefore = n;
    }

    public void setInputDimension(int n) {
        if (this.inputDimension != n) {
            this.inputDimension = n;
            this.setDimensions(n, -1);
        }
    }

    public void setLearningRate(double d) {
        this.learningRate = d;
    }

    public void setMomentum(double d) {
        this.momentum = d;
    }

    public void setMonitor(Monitor monitor) {
        this.monitor = monitor;
    }

    public void setName(String string) {
        this.fieldName = string;
    }

    public void setOutputDimension(int n) {
        if (this.outputDimension != n) {
            this.outputDimension = n;
            this.setDimensions(-1, n);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isLoopBack() {
        return this.loopBack;
    }

    public void setLoopBack(boolean bl) {
        this.loopBack = bl;
    }

    public TreeSet check() {
        TreeSet treeSet = new TreeSet();
        return treeSet;
    }

    public Collection Inspections() {
        ArrayList<WeightsInspection> arrayList = new ArrayList<WeightsInspection>(1);
        arrayList.add(new WeightsInspection(this.array));
        return arrayList;
    }

    public String InspectableTitle() {
        return this.getName();
    }

    public boolean isInputFull() {
        return this.inputFull;
    }

    public void setInputFull(boolean bl) {
        this.inputFull = bl;
    }

    public boolean isOutputFull() {
        return this.outputFull;
    }

    public void setOutputFull(boolean bl) {
        this.outputFull = bl;
    }

    public Matrix getWeights() {
        return this.array;
    }

    public void setWeights(Matrix matrix) {
        this.array = matrix;
    }

    public Learner getLearner() {
        if (!this.learnable) {
            return null;
        }
        return this.getMonitor().getLearner();
    }

    public void initLearner() {
        this.myLearner = this.getLearner();
        if (this.myLearner != null) {
            this.myLearner.registerLearnable(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Object getFwdLock() {
        if (this.fwdLock == null) {
            Synapse synapse = this;
            synchronized (synapse) {
                if (this.fwdLock == null) {
                    this.fwdLock = new Object();
                }
            }
        }
        return this.fwdLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Object getRevLock() {
        if (this.revLock == null) {
            Synapse synapse = this;
            synchronized (synapse) {
                if (this.revLock == null) {
                    this.revLock = new Object();
                }
            }
        }
        return this.revLock;
    }

    public void init() {
        this.initLearner();
        if (this.getWeights() != null) {
            this.getWeights().clearDelta();
        }
        this.getFwdLock();
        this.getRevLock();
    }

    protected String getSynapseNameSafely() {
        String string = this.getName();
        if (string == null) {
            string = "";
        }
        return string;
    }

    protected void warnLogger(String string, ILogger iLogger) {
        String string2 = "[" + this.getSynapseNameSafely() + "] " + string;
        iLogger.warn(string2);
    }

    protected void warnLogger(String string, Exception exception, ILogger iLogger) {
        String string2 = "[" + this.getSynapseNameSafely() + "] " + string;
        iLogger.warn(string2, exception);
    }
}

