/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine;

import java.io.Serializable;

public abstract class SpatialMap
implements Serializable {
    private double InitialGaussianSize = 1.0;
    private double CurrentGaussianSize = 1.0;
    private int map_width = 1;
    private int map_height = 1;
    private int map_depth = 1;
    private int win_x = 0;
    private int win_y = 0;
    private int win_z = 0;
    private int TotalEpochs = 1;
    private int orderingPhase;
    double TimeConstant = 1.0;

    public final void init(int n) {
        this.updateCurrentGaussianSize(1);
    }

    public final int getTotalEpochs() {
        return this.TotalEpochs;
    }

    public final void setInitialGaussianSize(double d) {
        this.setCurrentGaussianSize(d);
        this.InitialGaussianSize = d;
    }

    public final double getInitialGaussianSize() {
        return this.InitialGaussianSize;
    }

    public final void setCurrentGaussianSize(double d) {
        this.CurrentGaussianSize = d;
    }

    public final double getCurrentGaussianSize() {
        return this.CurrentGaussianSize;
    }

    public final void updateCurrentGaussianSize(int n) {
        if (n < this.getOrderingPhase()) {
            this.setCurrentGaussianSize(this.getInitialGaussianSize() * Math.exp(-((double)n / this.getTimeConstant())));
        } else {
            this.setCurrentGaussianSize(0.01);
        }
    }

    public abstract void ApplyNeighborhoodFunction(double[] var1, double[] var2, boolean var3);

    protected final void extractWinner(double[] dArray) {
        double d = 0.0;
        double d2 = Double.MAX_VALUE;
        for (int i = 0; i < this.getMapDepth(); ++i) {
            for (int j = 0; j < this.getMapHeight(); ++j) {
                for (int k = 0; k < this.getMapWidth(); ++k) {
                    int n = k + j * this.getMapWidth() + i * (this.getMapWidth() * this.getMapHeight());
                    d = dArray[n];
                    if (!(d < d2)) continue;
                    d2 = d;
                    this.win_x = k;
                    this.win_y = j;
                    this.win_z = i;
                }
            }
        }
    }

    protected final int getWinnerX() {
        return this.win_x;
    }

    protected final int getWinnerY() {
        return this.win_y;
    }

    protected final int getWinnerZ() {
        return this.win_z;
    }

    public final void setMapDimensions(int n, int n2, int n3) {
        this.setMapWidth(n);
        this.setMapHeight(n2);
        this.setMapDepth(n3);
    }

    public final void setMapWidth(int n) {
        this.map_width = n > 0 ? n : 1;
    }

    public final void setMapHeight(int n) {
        this.map_height = n > 0 ? n : 1;
    }

    public final void setMapDepth(int n) {
        this.map_depth = n > 0 ? n : 1;
    }

    public final int getMapWidth() {
        return this.map_width;
    }

    public final int getMapHeight() {
        return this.map_height;
    }

    public final int getMapDepth() {
        return this.map_depth;
    }

    protected final double distanceBetween(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        n7 = n - n4;
        n7 *= n7;
        n8 = n2 - n5;
        n8 *= n8;
        n9 = n3 - n6;
        n9 *= n9;
        return n7 + n8 + n9;
    }

    public int getOrderingPhase() {
        return this.orderingPhase;
    }

    public void setOrderingPhase(int n) {
        this.orderingPhase = n;
    }

    public double getTimeConstant() {
        return this.TimeConstant;
    }

    public void setTimeConstant(double d) {
        this.TimeConstant = d;
    }
}

