/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine;

import java.io.Serializable;

public class Pattern
implements Cloneable,
Serializable {
    private int count;
    private double[] array;
    private double[] outArray;
    private static final long serialVersionUID = -609786590797838450L;

    public Pattern() {
    }

    public Pattern(double[] dArray) {
        this.array = dArray;
    }

    public Pattern(double d) {
        this.array = new double[]{d};
    }

    public static Pattern makeZeroPattern(int n) {
        return new Pattern(new double[n]);
    }

    public static Pattern makeStopPattern(int n) {
        Pattern pattern = Pattern.makeZeroPattern(n);
        pattern.markAsStoppingPattern();
        return pattern;
    }

    public synchronized Object clone() {
        Pattern pattern;
        try {
            pattern = (Pattern)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            pattern = new Pattern();
            pattern.count = this.count;
        }
        pattern.array = (double[])this.array.clone();
        if (this.outArray != null) {
            pattern.setOutArray((double[])this.outArray.clone());
        }
        return pattern;
    }

    public synchronized double[] getArray() {
        return this.array;
    }

    public synchronized int getCount() {
        return this.count;
    }

    public synchronized void setArray(double[] dArray) {
        this.array = (double[])dArray.clone();
    }

    public synchronized void setCount(int n) {
        this.count = n;
    }

    public void markAsStoppingPattern() {
        this.setCount(-1);
    }

    public boolean isMarkedAsStoppingPattern() {
        return this.getCount() == -1;
    }

    public void setValue(int n, double d) {
        this.array[n] = d;
    }

    public double[] getOutArray() {
        return (double[])this.outArray.clone();
    }

    public void setOutArray(double[] dArray) {
        this.outArray = (double[])dArray.clone();
    }

    public double[] getValues() {
        return this.array;
    }

    public void setValues(double[] dArray) {
        this.array = dArray;
    }
}

