/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine;

import java.io.Serializable;
import java.util.TreeSet;
import java.util.Vector;
import org.joone.engine.Monitor;
import org.joone.engine.NeuralElement;
import org.joone.engine.OutputPatternListener;
import org.joone.engine.Pattern;

public class OutputSwitchSynapse
implements OutputPatternListener,
Serializable {
    protected Vector outputs = new Vector();
    private String name;
    private Monitor mon = null;
    private int inputDimension = 0;
    private boolean outputFull;
    private boolean enabled = true;
    private static final long serialVersionUID = 2906294213180089226L;
    private OutputPatternListener activeSynapse = null;
    private OutputPatternListener defaultSynapse = null;

    public void reset() {
        this.setActiveSynapse(this.getDefaultSynapse());
    }

    public boolean removeOutputSynapse(String string) {
        boolean bl = false;
        OutputPatternListener outputPatternListener = this.getOutputSynapse(string);
        if (outputPatternListener != null) {
            this.outputs.removeElement(outputPatternListener);
            outputPatternListener.setOutputFull(false);
            if (this.outputs.size() > 0) {
                if (this.getActiveOutput().equalsIgnoreCase(string)) {
                    this.setActiveSynapse((OutputPatternListener)this.outputs.elementAt(0));
                }
                if (this.getDefaultOutput().equalsIgnoreCase(string)) {
                    this.setDefaultSynapse((OutputPatternListener)this.outputs.elementAt(0));
                }
            } else {
                this.setActiveOutput("");
                this.setDefaultOutput("");
            }
            bl = true;
        }
        return bl;
    }

    protected OutputPatternListener getOutputSynapse(String string) {
        int n;
        OutputPatternListener outputPatternListener = null;
        for (n = 0; n < this.outputs.size() && !(outputPatternListener = (OutputPatternListener)this.outputs.elementAt(n)).getName().equalsIgnoreCase(string); ++n) {
        }
        if (n < this.outputs.size()) {
            return outputPatternListener;
        }
        return null;
    }

    public boolean addOutputSynapse(OutputPatternListener outputPatternListener) {
        boolean bl = false;
        if (!this.outputs.contains(outputPatternListener) && !outputPatternListener.isOutputFull()) {
            this.outputs.addElement(outputPatternListener);
            outputPatternListener.setInputDimension(this.inputDimension);
            outputPatternListener.setMonitor(this.mon);
            outputPatternListener.setOutputFull(true);
            if (this.outputs.size() == 1) {
                this.setDefaultOutput(outputPatternListener.getName());
                this.setActiveOutput(outputPatternListener.getName());
            }
            bl = true;
        }
        return bl;
    }

    public String getActiveOutput() {
        if (this.activeSynapse != null) {
            return this.activeSynapse.getName();
        }
        return "";
    }

    public void setActiveOutput(String string) {
        OutputPatternListener outputPatternListener;
        this.activeSynapse = outputPatternListener = this.getOutputSynapse(string);
    }

    public String getDefaultOutput() {
        if (this.defaultSynapse != null) {
            return this.defaultSynapse.getName();
        }
        return "";
    }

    public void setDefaultOutput(String string) {
        OutputPatternListener outputPatternListener;
        this.defaultSynapse = outputPatternListener = this.getOutputSynapse(string);
    }

    protected OutputPatternListener getActiveSynapse() {
        return this.activeSynapse;
    }

    protected void setActiveSynapse(OutputPatternListener outputPatternListener) {
        this.activeSynapse = outputPatternListener;
    }

    protected OutputPatternListener getDefaultSynapse() {
        return this.defaultSynapse;
    }

    protected void setDefaultSynapse(OutputPatternListener outputPatternListener) {
        this.defaultSynapse = outputPatternListener;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setInputDimension(int n) {
        this.inputDimension = n;
        for (int i = 0; i < this.outputs.size(); ++i) {
            OutputPatternListener outputPatternListener = (OutputPatternListener)this.outputs.elementAt(i);
            outputPatternListener.setInputDimension(n);
        }
    }

    public int getInputDimension() {
        return this.inputDimension;
    }

    public Monitor getMonitor() {
        return this.mon;
    }

    public void setMonitor(Monitor monitor) {
        this.mon = monitor;
        for (int i = 0; i < this.outputs.size(); ++i) {
            OutputPatternListener outputPatternListener = (OutputPatternListener)this.outputs.elementAt(i);
            outputPatternListener.setMonitor(monitor);
        }
    }

    protected void backward(double[] dArray) {
    }

    protected void forward(double[] dArray) {
    }

    public Vector getAllOutputs() {
        return this.outputs;
    }

    public void resetOutput() {
        this.reset();
    }

    public void fwdPut(Pattern pattern) {
        if (this.isEnabled() && this.activeSynapse != null) {
            this.activeSynapse.fwdPut(pattern);
        }
    }

    public Pattern revGet() {
        if (this.isEnabled() && this.activeSynapse != null) {
            return this.activeSynapse.revGet();
        }
        return null;
    }

    public TreeSet check() {
        TreeSet treeSet = new TreeSet();
        return treeSet;
    }

    public boolean isOutputFull() {
        return this.outputFull;
    }

    public void setOutputFull(boolean bl) {
        this.outputFull = bl;
        for (int i = 0; i < this.outputs.size(); ++i) {
            OutputPatternListener outputPatternListener = (OutputPatternListener)this.outputs.elementAt(i);
            outputPatternListener.setOutputFull(bl);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void init() {
        for (int i = 0; i < this.outputs.size(); ++i) {
            if (!(this.outputs.elementAt(i) instanceof NeuralElement)) continue;
            ((NeuralElement)this.outputs.elementAt(i)).init();
        }
    }
}

