/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.TreeSet;
import org.joone.engine.Layer;
import org.joone.engine.OutputPatternListener;

public abstract class MemoryLayer
extends Layer {
    protected double[] memory;
    protected double[] backmemory;
    private int taps = 0;
    private static final long serialVersionUID = 5447777678414684948L;

    public MemoryLayer() {
    }

    public MemoryLayer(String string) {
        super(string);
    }

    public int getDimension() {
        return this.getRows() * (this.getTaps() + 1);
    }

    public int getTaps() {
        return this.taps;
    }

    protected void setDimensions() {
        this.inps = new double[this.getRows()];
        this.outs = new double[this.getRows() * (this.getTaps() + 1)];
        this.gradientInps = new double[this.getRows() * (this.getTaps() + 1)];
        this.gradientOuts = new double[this.getRows()];
        this.memory = new double[this.getRows() * (this.getTaps() + 1)];
        this.backmemory = new double[this.getRows() * (this.getTaps() + 1)];
    }

    protected void setOutputDimension(OutputPatternListener outputPatternListener) {
        int n = this.getRows() * (this.getTaps() + 1);
        if (outputPatternListener.getInputDimension() != n) {
            outputPatternListener.setInputDimension(n);
        }
    }

    public void setTaps(int n) {
        this.taps = n;
        this.setDimensions();
        this.setConnDimensions();
    }

    protected void sumBackInput(double[] dArray) {
        int n = this.getRows() * (this.getTaps() + 1);
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            this.gradientInps[n2] = this.gradientInps[n2] + dArray[i];
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.setDimensions();
    }

    protected void backward(double[] dArray) {
    }

    protected void forward(double[] dArray) {
    }

    public TreeSet check() {
        return super.check();
    }
}

