/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.joone.engine.weights.RandomWeightInitializer;
import org.joone.engine.weights.WeightInitializer;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;

public class Matrix
implements Serializable,
Cloneable {
    private static final ILogger log = LoggerFactory.getLogger(Matrix.class);
    public static final double DEFAULT_INITIAL = 0.2;
    private static final long serialVersionUID = -1392966842649908366L;
    public double[][] value;
    public double[][] delta;
    public boolean[][] enabled;
    public boolean[][] fixed;
    protected int m_rows;
    protected int m_cols;
    protected WeightInitializer weightInitializer;

    public Matrix() {
    }

    public Matrix(int n, int n2) {
        this(n, n2, 0.2);
    }

    public Matrix(int n, int n2, double d) {
        this.value = new double[n][n2];
        this.delta = new double[n][n2];
        this.enabled = new boolean[n][n2];
        this.fixed = new boolean[n][n2];
        this.m_rows = n;
        this.m_cols = n2;
        this.enableAll();
        this.unfixAll();
        if (d == 0.0) {
            this.setWeightInitializer(new RandomWeightInitializer(0.0), false);
            this.clear();
        } else {
            this.setWeightInitializer(new RandomWeightInitializer(d));
        }
    }

    public void initialize() {
        this.getWeightInitializer().initialize(this);
    }

    public void randomizeConditionally(double d) {
        WeightInitializer weightInitializer = this.getWeightInitializer();
        if (weightInitializer instanceof RandomWeightInitializer) {
            this.setWeightInitializer(new RandomWeightInitializer(d), true);
            this.setWeightInitializer(weightInitializer, false);
        } else {
            this.initialize();
        }
    }

    public void setWeightInitializer(WeightInitializer weightInitializer) {
        this.setWeightInitializer(weightInitializer, true);
    }

    public void setWeightInitializer(WeightInitializer weightInitializer, boolean bl) {
        this.weightInitializer = weightInitializer;
        if (bl) {
            this.getWeightInitializer().initialize(this);
        }
    }

    public WeightInitializer getWeightInitializer() {
        if (this.weightInitializer == null) {
            this.weightInitializer = new RandomWeightInitializer(0.2);
        }
        return this.weightInitializer;
    }

    public Object clone() {
        Matrix matrix = null;
        try {
            matrix = (Matrix)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            log.error("Matrix can't clone", cloneNotSupportedException);
        }
        matrix.value = (double[][])matrix.value.clone();
        matrix.delta = (double[][])matrix.delta.clone();
        matrix.enabled = (boolean[][])matrix.enabled.clone();
        matrix.fixed = (boolean[][])matrix.fixed.clone();
        for (int i = 0; i < this.m_rows; ++i) {
            matrix.value[i] = (double[])matrix.value[i].clone();
            matrix.delta[i] = (double[])matrix.delta[i].clone();
            matrix.enabled[i] = (boolean[])matrix.enabled[i].clone();
            matrix.fixed[i] = (boolean[])matrix.fixed[i].clone();
        }
        return matrix;
    }

    public void addNoise(double d) {
        for (int i = 0; i < this.m_rows; ++i) {
            for (int j = 0; j < this.m_cols; ++j) {
                if (!this.enabled[i][j] || this.fixed[i][j]) continue;
                double[] dArray = this.value[i];
                int n = j;
                dArray[n] = dArray[n] + (-d + Math.random() * (2.0 * d));
            }
        }
    }

    public void removeRow(int n) {
        double[][] dArrayArray = new double[this.m_rows - 1][];
        double[][] dArrayArray2 = new double[this.m_rows - 1][];
        boolean[][] blArrayArray = new boolean[this.m_rows - 1][];
        boolean[][] blArrayArray2 = new boolean[this.m_rows - 1][];
        for (int i = 0; i < this.m_rows; ++i) {
            if (i < n) {
                dArrayArray[i] = (double[])this.value[i].clone();
                dArrayArray2[i] = (double[])this.delta[i].clone();
                blArrayArray[i] = (boolean[])this.enabled[i].clone();
                blArrayArray2[i] = (boolean[])this.fixed[i].clone();
                continue;
            }
            if (i <= n) continue;
            dArrayArray[i - 1] = (double[])this.value[i].clone();
            dArrayArray2[i - 1] = (double[])this.delta[i].clone();
            blArrayArray[i - 1] = (boolean[])this.enabled[i].clone();
            blArrayArray2[i - 1] = (boolean[])this.fixed[i].clone();
        }
        this.value = dArrayArray;
        this.delta = dArrayArray2;
        this.enabled = blArrayArray;
        this.fixed = blArrayArray2;
        --this.m_rows;
    }

    public void removeColumn(int n) {
        double[][] dArray = new double[this.m_rows][this.m_cols - 1];
        double[][] dArray2 = new double[this.m_rows][this.m_cols - 1];
        boolean[][] blArray = new boolean[this.m_rows][this.m_cols - 1];
        boolean[][] blArray2 = new boolean[this.m_rows][this.m_cols - 1];
        for (int i = 0; i < this.m_rows; ++i) {
            for (int j = 0; j < this.m_cols; ++j) {
                if (j < n) {
                    dArray[i][j] = this.value[i][j];
                    dArray2[i][j] = this.delta[i][j];
                    blArray[i][j] = this.enabled[i][j];
                    blArray2[i][j] = this.fixed[i][j];
                    continue;
                }
                if (j <= n) continue;
                dArray[i][j - 1] = this.value[i][j];
                dArray2[i][j - 1] = this.delta[i][j];
                blArray[i][j - 1] = this.enabled[i][j];
                blArray2[i][j - 1] = this.fixed[i][j];
            }
        }
        this.value = dArray;
        this.delta = dArray2;
        this.enabled = blArray;
        this.fixed = blArray2;
        --this.m_cols;
    }

    public void clear() {
        for (int i = 0; i < this.m_rows; ++i) {
            for (int j = 0; j < this.m_cols; ++j) {
                if (!this.enabled[i][j] && this.fixed[i][j]) continue;
                this.value[i][j] = 0.0;
                this.delta[i][j] = 0.0;
            }
        }
    }

    public void clearDelta() {
        for (int i = 0; i < this.m_rows; ++i) {
            for (int j = 0; j < this.m_cols; ++j) {
                this.delta[i][j] = 0.0;
            }
        }
    }

    public void enableAll() {
        for (int i = 0; i < this.m_rows; ++i) {
            for (int j = 0; j < this.m_cols; ++j) {
                this.enabled[i][j] = true;
            }
        }
    }

    public void disableAll() {
        for (int i = 0; i < this.m_rows; ++i) {
            for (int j = 0; j < this.m_cols; ++j) {
                this.enabled[i][j] = false;
            }
        }
    }

    public void fixAll() {
        for (int i = 0; i < this.m_rows; ++i) {
            for (int j = 0; j < this.m_cols; ++j) {
                this.fixed[i][j] = true;
            }
        }
    }

    public void unfixAll() {
        for (int i = 0; i < this.m_rows; ++i) {
            for (int j = 0; j < this.m_cols; ++j) {
                this.fixed[i][j] = false;
            }
        }
    }

    public int getM_rows() {
        return this.m_rows;
    }

    public void setM_rows(int n) {
        this.m_rows = n;
    }

    public int getM_cols() {
        return this.m_cols;
    }

    public void setM_cols(int n) {
        this.m_cols = n;
    }

    public double[][] getDelta() {
        return this.delta;
    }

    public void setDelta(double[][] dArray) {
        this.delta = dArray;
    }

    public double[][] getValue() {
        return this.value;
    }

    public void setValue(double[][] dArray) {
        this.value = dArray;
    }

    public boolean[][] getFixed() {
        return this.fixed;
    }

    public void setFixed(boolean[][] blArray) {
        this.fixed = blArray;
    }

    public boolean[][] getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean[][] blArray) {
        this.enabled = blArray;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.enabled == null) {
            this.enabled = new boolean[this.m_rows][this.m_cols];
            this.enableAll();
        }
        if (this.fixed == null) {
            this.fixed = new boolean[this.m_rows][this.m_cols];
            this.unfixAll();
        }
    }
}

