/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine;

import org.joone.engine.LearnableLayer;
import org.joone.engine.Learner;
import org.joone.engine.SimpleLayer;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;

public class LogarithmicLayer
extends SimpleLayer
implements LearnableLayer {
    private static final ILogger log = LoggerFactory.getLogger(LogarithmicLayer.class);
    private static final long serialVersionUID = -4983197905588348060L;

    public LogarithmicLayer() {
        this.learnable = true;
    }

    public LogarithmicLayer(String string) {
        this();
        this.setLayerName(string);
    }

    protected void forward(double[] dArray) {
        int n = this.getRows();
        for (int i = 0; i < n; ++i) {
            double d = dArray[i] + this.getBias().value[i][0];
            this.outs[i] = d >= 0.0 ? Math.log(1.0 + d) : -Math.log(1.0 - d);
        }
    }

    protected void backward(double[] dArray) {
        super.backward(dArray);
        int n = this.getRows();
        for (int i = 0; i < n; ++i) {
            double d = this.outs[i] >= 0.0 ? 1.0 / (1.0 + this.outs[i]) : 1.0 / (1.0 - this.outs[i]);
            this.gradientOuts[i] = dArray[i] * d;
        }
        this.myLearner.requestBiasUpdate(this.gradientOuts);
    }

    public Learner getLearner() {
        this.learnable = true;
        return super.getLearner();
    }
}

