/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import org.joone.engine.GaussianSpatialMap;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.NeuralNetListener;
import org.joone.engine.SimpleLayer;
import org.joone.engine.SpatialMap;
import org.joone.exception.JooneRuntimeException;
import org.joone.inspection.implementations.BiasInspection;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NetCheck;

public class GaussianLayer
extends SimpleLayer
implements NeuralNetListener {
    private static final ILogger log = LoggerFactory.getLogger(GaussianLayer.class);
    private static final long serialVersionUID = -941653911909171430L;
    private int LayerWidth = 1;
    private int LayerHeight = 1;
    private int LayerDepth = 1;
    private SpatialMap space_map;
    private double timeConstant = 200.0;
    private int orderingPhase = 1000;
    private double initialGaussianSize = 10.0;

    public GaussianLayer() {
    }

    public GaussianLayer(String string) {
        super(string);
    }

    public void backward(double[] dArray) throws JooneRuntimeException {
    }

    public void forward(double[] dArray) throws JooneRuntimeException {
        try {
            this.getSpace_map().ApplyNeighborhoodFunction(dArray, this.outs, this.getMonitor().isLearning());
        }
        catch (Exception exception) {
            String string = "Exception thrown while processing the pattern " + dArray.toString() + " Exception thrown is " + exception.getClass().getName() + ". Message is " + exception.getMessage();
            log.error(string);
            throw new JooneRuntimeException(string, exception);
        }
    }

    public int getLayerDepth() {
        return this.LayerDepth;
    }

    public void setLayerDepth(int n) {
        if (n != this.getLayerDepth()) {
            this.LayerDepth = n;
            this.setRows(this.getLayerWidth() * this.getLayerHeight() * this.getLayerDepth());
            this.setDimensions();
            this.setConnDimensions();
            this.getSpace_map().setMapDepth(n);
        }
    }

    public int getLayerHeight() {
        return this.LayerHeight;
    }

    public void setLayerHeight(int n) {
        if (n != this.getLayerHeight()) {
            this.LayerHeight = n;
            this.setRows(this.getLayerWidth() * this.getLayerHeight() * this.getLayerDepth());
            this.setDimensions();
            this.setConnDimensions();
            this.getSpace_map().setMapHeight(n);
        }
    }

    public int getLayerWidth() {
        return this.LayerWidth;
    }

    public void setLayerWidth(int n) {
        if (n != this.getLayerWidth()) {
            this.LayerWidth = n;
            this.setRows(this.getLayerWidth() * this.getLayerHeight() * this.getLayerDepth());
            this.setDimensions();
            this.setConnDimensions();
            this.getSpace_map().setMapWidth(n);
        }
    }

    public int getLargestDimension() {
        int n = 1;
        if (this.getLayerWidth() > n) {
            n = this.getLayerWidth();
        }
        if (this.getLayerHeight() > n) {
            n = this.getLayerHeight();
        }
        if (this.getLayerDepth() > n) {
            n = this.getLayerDepth();
        }
        return n;
    }

    public TreeSet check() {
        TreeSet treeSet = super.check();
        if (this.getLayerWidth() < 1) {
            treeSet.add(new NetCheck(0, "Layer width should be greater than or equal to 1.", this));
        }
        if (this.getLayerHeight() < 1) {
            treeSet.add(new NetCheck(0, "Layer height should be greater than or equal to 1.", this));
        }
        if (this.getLayerDepth() < 1) {
            treeSet.add(new NetCheck(0, "Layer depth should be greater than or equal to 1.", this));
        }
        if (this.getOrderingPhase() > this.getMonitor().getTotCicles()) {
            treeSet.add(new NetCheck(1, "Ordering phase should be lesser than or equal to the number of epochs", this));
        }
        return treeSet;
    }

    public void start() {
        if (this.getMonitor() != null) {
            this.getMonitor().addNeuralNetListener(this, false);
        }
        super.start();
    }

    public void netStarted(NeuralNetEvent neuralNetEvent) {
        this.getSpace_map().init(this.getMonitor().getTotCicles());
        this.space_map.setInitialGaussianSize(this.getLargestDimension());
    }

    public void cicleTerminated(NeuralNetEvent neuralNetEvent) {
        if (this.getMonitor().isLearning()) {
            this.getSpace_map().updateCurrentGaussianSize(this.getMonitor().getTotCicles() - this.getMonitor().getCurrentCicle());
        }
    }

    public int getOrderingPhase() {
        return this.orderingPhase;
    }

    public void setOrderingPhase(int n) {
        this.orderingPhase = n;
        this.getSpace_map().setOrderingPhase(n);
    }

    public double getTimeConstant() {
        return this.timeConstant;
    }

    public void setTimeConstant(double d) {
        this.timeConstant = d;
        this.getSpace_map().setTimeConstant(d);
    }

    protected SpatialMap getSpace_map() {
        if (this.space_map == null) {
            this.space_map = new GaussianSpatialMap();
            this.space_map.setMapDepth(this.getLayerDepth());
            this.space_map.setMapHeight(this.getLayerHeight());
            this.space_map.setMapWidth(this.getLayerWidth());
            this.space_map.setInitialGaussianSize(this.getInitialGaussianSize());
            this.space_map.setOrderingPhase(this.getOrderingPhase());
            this.space_map.setTimeConstant(this.getTimeConstant());
        }
        return this.space_map;
    }

    public double getInitialGaussianSize() {
        return this.initialGaussianSize;
    }

    public void setInitialGaussianSize(double d) {
        this.initialGaussianSize = d;
        this.getSpace_map().setInitialGaussianSize(d);
    }

    public Collection Inspections() {
        ArrayList<BiasInspection> arrayList = new ArrayList<BiasInspection>();
        arrayList.add(new BiasInspection(null));
        return arrayList;
    }

    public void netStoppedError(NeuralNetEvent neuralNetEvent, String string) {
    }

    public void errorChanged(NeuralNetEvent neuralNetEvent) {
    }

    public void netStopped(NeuralNetEvent neuralNetEvent) {
    }
}

