/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine;

import org.joone.engine.LearnableSynapse;
import org.joone.engine.Learner;
import org.joone.engine.Matrix;
import org.joone.engine.Synapse;

public class FullSynapse
extends Synapse
implements LearnableSynapse {
    private static final long serialVersionUID = 5518898101307425554L;

    public FullSynapse() {
        this.learnable = true;
    }

    protected void backward(double[] dArray) {
        int n = this.getInputDimension();
        int n2 = this.getOutputDimension();
        for (int i = 0; i < n; ++i) {
            double d = 0.0;
            for (int j = 0; j < n2; ++j) {
                d += dArray[j] * this.array.value[i][j];
            }
            this.bouts[i] = d;
        }
        this.myLearner.requestWeightUpdate(dArray, this.inps);
    }

    protected void forward(double[] dArray) {
        int n = this.getInputDimension();
        int n2 = this.getOutputDimension();
        for (int i = 0; i < n2; ++i) {
            double d = 0.0;
            for (int j = 0; j < n; ++j) {
                d += dArray[j] * this.array.value[j][i];
            }
            this.outs[i] = d;
        }
    }

    protected void setArrays(int n, int n2) {
        this.inps = new double[n];
        this.outs = new double[n2];
        this.bouts = new double[n];
    }

    protected void setDimensions(int n, int n2) {
        int n3 = this.getInputDimension();
        int n4 = this.getOutputDimension();
        int n5 = n == -1 ? n3 : n;
        int n6 = n2 == -1 ? n4 : n2;
        this.array = new Matrix(n5, n6);
        this.setArrays(n5, n6);
    }

    public Learner getLearner() {
        this.learnable = true;
        return super.getLearner();
    }
}

