/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine;

import java.io.Serializable;
import org.joone.engine.Matrix;

public class FIRFilter
implements Serializable {
    protected int m_taps;
    protected double[] memory;
    protected double[] backmemory;
    protected double[] outs;
    protected double[] bouts;
    protected Matrix array;
    public double lrate;
    public double momentum;
    private static final long serialVersionUID = 2539307324689626619L;

    public FIRFilter(int n) {
        this.outs = new double[n];
        this.bouts = new double[n];
        this.memory = new double[n];
        this.backmemory = new double[n];
        this.array = new Matrix(n, 1);
        this.m_taps = n - 1;
    }

    public void addNoise(double d) {
        this.array.addNoise(d);
    }

    protected double backDelay(double[] dArray) {
        for (int i = 0; i < this.m_taps; ++i) {
            this.backmemory[i] = this.backmemory[i + 1];
            int n = i;
            this.backmemory[n] = this.backmemory[n] + dArray[i];
        }
        this.backmemory[this.m_taps] = dArray[this.m_taps];
        return this.backmemory[0];
    }

    protected double[] backFilter(double d) {
        for (int i = 0; i <= this.m_taps; ++i) {
            this.bouts[i] = d * this.array.value[i][0];
            double d2 = this.lrate * d * this.outs[i] + this.momentum * this.array.delta[i][0];
            double[] dArray = this.array.value[i];
            dArray[0] = dArray[0] + d2;
            this.array.delta[i][0] = d2;
        }
        return this.bouts;
    }

    public double backward(double d) {
        return this.backDelay(this.backFilter(d));
    }

    protected double[] Delay(double d) {
        for (int i = this.m_taps; i > 0; --i) {
            this.memory[i] = this.memory[i - 1];
            this.outs[i] = this.memory[i];
        }
        this.memory[0] = d;
        this.outs[0] = d;
        return this.outs;
    }

    protected double Filter(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i <= this.m_taps; ++i) {
            d += dArray[i] * this.array.value[i][0];
        }
        return d;
    }

    public double forward(double d) {
        return this.Filter(this.Delay(d));
    }
}

