/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine;

import java.util.ArrayList;
import java.util.List;
import org.joone.engine.AbstractLearner;
import org.joone.engine.LearnableSynapse;
import org.joone.engine.Matrix;
import org.joone.engine.extenders.DeltaRuleExtender;
import org.joone.engine.extenders.GradientExtender;
import org.joone.engine.extenders.LearnerExtender;
import org.joone.engine.extenders.UpdateWeightExtender;

public class ExtendableLearner
extends AbstractLearner {
    protected List theDeltaRuleExtenders = new ArrayList();
    protected List theGradientExtenders = new ArrayList();
    protected UpdateWeightExtender theUpdateWeightExtender;

    public final void requestBiasUpdate(double[] dArray) {
        this.preBiasUpdate(dArray);
        int n = this.getLayer().getRows();
        for (int i = 0; i < n; ++i) {
            double d = this.getDelta(dArray, i);
            this.updateBias(i, d);
        }
        this.postBiasUpdate(dArray);
    }

    public final void requestWeightUpdate(double[] dArray, double[] dArray2) {
        this.preWeightUpdate(dArray, dArray2);
        LearnableSynapse learnableSynapse = this.getSynapse();
        Matrix matrix = learnableSynapse.getWeights();
        boolean[][] blArray = matrix.getEnabled();
        boolean[][] blArray2 = matrix.getFixed();
        int n = learnableSynapse.getInputDimension();
        int n2 = learnableSynapse.getOutputDimension();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (blArray2[i][j] || !blArray[i][j]) continue;
                double d = this.getDelta(dArray2, i, dArray, j);
                this.updateWeight(i, j, d);
            }
        }
        this.postWeightUpdate(dArray, dArray2);
    }

    protected void updateBias(int n, double d) {
        this.theUpdateWeightExtender.updateBias(n, d);
    }

    protected void updateWeight(int n, int n2, double d) {
        this.theUpdateWeightExtender.updateWeight(n, n2, d);
    }

    protected double getDelta(double[] dArray, int n) {
        double d = this.getDefaultDelta(dArray, n);
        int n2 = this.theDeltaRuleExtenders.size();
        for (int i = 0; i < n2; ++i) {
            DeltaRuleExtender deltaRuleExtender = (DeltaRuleExtender)this.theDeltaRuleExtenders.get(i);
            if (!deltaRuleExtender.isEnabled()) continue;
            d = deltaRuleExtender.getDelta(dArray, n, d);
        }
        return d;
    }

    public double getDefaultDelta(double[] dArray, int n) {
        return this.getLearningRate(n) * this.getGradientBias(dArray, n);
    }

    protected double getDelta(double[] dArray, int n, double[] dArray2, int n2) {
        double d = this.getDefaultDelta(dArray, n, dArray2, n2);
        for (int i = 0; i < this.theDeltaRuleExtenders.size(); ++i) {
            DeltaRuleExtender deltaRuleExtender = (DeltaRuleExtender)this.theDeltaRuleExtenders.get(i);
            if (!deltaRuleExtender.isEnabled()) continue;
            d = deltaRuleExtender.getDelta(dArray, n, dArray2, n2, d);
        }
        return d;
    }

    public double getDefaultDelta(double[] dArray, int n, double[] dArray2, int n2) {
        return this.getLearningRate(n, n2) * this.getGradientWeight(dArray, n, dArray2, n2);
    }

    protected double getLearningRate(int n) {
        return this.getMonitor().getLearningRate();
    }

    protected double getLearningRate(int n, int n2) {
        return this.getMonitor().getLearningRate();
    }

    public double getGradientBias(double[] dArray, int n) {
        double d = this.getDefaultGradientBias(dArray, n);
        for (int i = 0; i < this.theGradientExtenders.size(); ++i) {
            GradientExtender gradientExtender = (GradientExtender)this.theGradientExtenders.get(i);
            if (!gradientExtender.isEnabled()) continue;
            d = gradientExtender.getGradientBias(dArray, n, d);
        }
        return d;
    }

    public double getDefaultGradientBias(double[] dArray, int n) {
        return dArray[n];
    }

    public double getGradientWeight(double[] dArray, int n, double[] dArray2, int n2) {
        double d = this.getDefaultGradientWeight(dArray, n, dArray2, n2);
        for (int i = 0; i < this.theGradientExtenders.size(); ++i) {
            GradientExtender gradientExtender = (GradientExtender)this.theGradientExtenders.get(i);
            if (!gradientExtender.isEnabled()) continue;
            d = gradientExtender.getGradientWeight(dArray, n, dArray2, n2, d);
        }
        return d;
    }

    public double getDefaultGradientWeight(double[] dArray, int n, double[] dArray2, int n2) {
        return dArray[n] * dArray2[n2];
    }

    protected final void preBiasUpdate(double[] dArray) {
        LearnerExtender learnerExtender;
        int n;
        this.preBiasUpdateImpl(dArray);
        if (this.theUpdateWeightExtender != null && this.theUpdateWeightExtender.isEnabled()) {
            this.theUpdateWeightExtender.preBiasUpdate(dArray);
        }
        for (n = 0; n < this.theDeltaRuleExtenders.size(); ++n) {
            learnerExtender = (DeltaRuleExtender)this.theDeltaRuleExtenders.get(n);
            if (!learnerExtender.isEnabled()) continue;
            learnerExtender.preBiasUpdate(dArray);
        }
        for (n = 0; n < this.theGradientExtenders.size(); ++n) {
            learnerExtender = (GradientExtender)this.theGradientExtenders.get(n);
            if (!learnerExtender.isEnabled()) continue;
            learnerExtender.preBiasUpdate(dArray);
        }
    }

    protected void preBiasUpdateImpl(double[] dArray) {
    }

    protected final void preWeightUpdate(double[] dArray, double[] dArray2) {
        LearnerExtender learnerExtender;
        int n;
        this.preWeightUpdateImpl(dArray, dArray2);
        if (this.theUpdateWeightExtender != null && this.theUpdateWeightExtender.isEnabled()) {
            this.theUpdateWeightExtender.preWeightUpdate(dArray2, dArray);
        }
        for (n = 0; n < this.theDeltaRuleExtenders.size(); ++n) {
            learnerExtender = (DeltaRuleExtender)this.theDeltaRuleExtenders.get(n);
            if (!learnerExtender.isEnabled()) continue;
            learnerExtender.preWeightUpdate(dArray2, dArray);
        }
        for (n = 0; n < this.theGradientExtenders.size(); ++n) {
            learnerExtender = (GradientExtender)this.theGradientExtenders.get(n);
            if (!learnerExtender.isEnabled()) continue;
            learnerExtender.preWeightUpdate(dArray2, dArray);
        }
    }

    protected void preWeightUpdateImpl(double[] dArray, double[] dArray2) {
    }

    protected final void postBiasUpdate(double[] dArray) {
        LearnerExtender learnerExtender;
        int n;
        for (n = 0; n < this.theGradientExtenders.size(); ++n) {
            learnerExtender = (GradientExtender)this.theGradientExtenders.get(n);
            if (!learnerExtender.isEnabled()) continue;
            learnerExtender.postBiasUpdate(dArray);
        }
        for (n = 0; n < this.theDeltaRuleExtenders.size(); ++n) {
            learnerExtender = (DeltaRuleExtender)this.theDeltaRuleExtenders.get(n);
            if (!learnerExtender.isEnabled()) continue;
            learnerExtender.postBiasUpdate(dArray);
        }
        if (this.theUpdateWeightExtender != null && this.theUpdateWeightExtender.isEnabled()) {
            this.theUpdateWeightExtender.postBiasUpdate(dArray);
        }
        this.postBiasUpdateImpl(dArray);
    }

    protected void postBiasUpdateImpl(double[] dArray) {
    }

    protected final void postWeightUpdate(double[] dArray, double[] dArray2) {
        LearnerExtender learnerExtender;
        int n;
        for (n = 0; n < this.theGradientExtenders.size(); ++n) {
            learnerExtender = (GradientExtender)this.theGradientExtenders.get(n);
            if (!learnerExtender.isEnabled()) continue;
            learnerExtender.postWeightUpdate(dArray2, dArray);
        }
        for (n = 0; n < this.theDeltaRuleExtenders.size(); ++n) {
            learnerExtender = (DeltaRuleExtender)this.theDeltaRuleExtenders.get(n);
            if (!learnerExtender.isEnabled()) continue;
            learnerExtender.postWeightUpdate(dArray2, dArray);
        }
        if (this.theUpdateWeightExtender != null && this.theUpdateWeightExtender.isEnabled()) {
            this.theUpdateWeightExtender.postWeightUpdate(dArray2, dArray);
        }
        this.postWeightUpdateImpl(dArray2, dArray2);
    }

    protected void postWeightUpdateImpl(double[] dArray, double[] dArray2) {
    }

    public void addDeltaRuleExtender(DeltaRuleExtender deltaRuleExtender) {
        this.theDeltaRuleExtenders.add(deltaRuleExtender);
        deltaRuleExtender.setLearner(this);
    }

    public void addGradientExtender(GradientExtender gradientExtender) {
        this.theGradientExtenders.add(gradientExtender);
        gradientExtender.setLearner(this);
    }

    public void setUpdateWeightExtender(UpdateWeightExtender updateWeightExtender) {
        this.theUpdateWeightExtender = updateWeightExtender;
        this.theUpdateWeightExtender.setLearner(this);
    }

    public UpdateWeightExtender getUpdateWeightExtender() {
        return this.theUpdateWeightExtender;
    }
}

