/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine;

import java.util.TreeSet;
import org.joone.engine.FIRFilter;
import org.joone.engine.Synapse;
import org.joone.net.NetCheck;

public class DelaySynapse
extends Synapse {
    protected FIRFilter[][] fir;
    private int taps;
    private static final long serialVersionUID = 8268129000639124340L;

    public void addNoise(double d) {
        int n = this.getOutputDimension();
        int n2 = this.getInputDimension();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.fir[j][i].addNoise(d);
            }
        }
    }

    protected void backward(double[] dArray) {
        int n = this.getInputDimension();
        int n2 = this.getOutputDimension();
        for (int i = 0; i < n; ++i) {
            double d = 0.0;
            for (int j = 0; j < n2; ++j) {
                this.fir[i][j].lrate = this.getLearningRate();
                this.fir[i][j].momentum = this.getMomentum();
                d += this.fir[i][j].backward(dArray[j]);
            }
            this.bouts[i] = d;
        }
    }

    protected void forward(double[] dArray) {
        int n = this.getInputDimension();
        int n2 = this.getOutputDimension();
        for (int i = 0; i < n2; ++i) {
            double d = 0.0;
            for (int j = 0; j < n; ++j) {
                d += this.fir[j][i].forward(dArray[j]);
            }
            this.outs[i] = d;
        }
    }

    public int getTaps() {
        return this.taps;
    }

    protected void setArrays(int n, int n2) {
        this.inps = new double[n];
        this.outs = new double[n2];
        this.bouts = new double[n];
    }

    protected void setDimensions(int n, int n2) {
        int n3 = this.getInputDimension();
        int n4 = this.getOutputDimension();
        int n5 = n == -1 ? n3 : n;
        int n6 = n2 == -1 ? n4 : n2;
        this.fir = new FIRFilter[n5][n6];
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n6; ++j) {
                this.fir[i][j] = new FIRFilter(this.getTaps());
            }
        }
        this.setArrays(n5, n6);
    }

    public void setTaps(int n) {
        this.taps = n;
        this.setDimensions(-1, -1);
    }

    public TreeSet check() {
        TreeSet treeSet = super.check();
        if (this.getTaps() == 0) {
            treeSet.add(new NetCheck(0, "The Taps parameter cannot be equal to zero.", this));
        }
        return treeSet;
    }
}

