/*
 * Decompiled with CFR 0.152.
 */
package org.joone.edit.visad;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TreeSet;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.joone.edit.ChartInterface;
import org.joone.edit.ChartingHandle;
import org.joone.edit.SharedBuffer;
import org.joone.engine.Monitor;
import org.joone.engine.NetErrorManager;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.NeuralNetListener;
import org.joone.engine.Pattern;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.util.NotSerialize;
import visad.ConstantMap;
import visad.Data;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.Display;
import visad.FlatField;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Integer1DSet;
import visad.MathType;
import visad.RealType;
import visad.ScalarMap;
import visad.ScalarType;
import visad.Set;
import visad.VisADException;
import visad.java2d.DisplayImplJ2D;
import visad.util.GMCWidget;
import visad.util.RangeWidget;

public class VisADOutputSynapse
implements NotSerialize,
Serializable,
NeuralNetListener,
ChartInterface {
    private static final long serialVersionUID = 7501932794591309201L;
    private static final ILogger log = LoggerFactory.getLogger(VisADOutputSynapse.class);
    private boolean show;
    private Monitor monitor;
    private String name = "";
    private String title = "VisAD Chart";
    private boolean resizable = true;
    private int maxXaxis = 1000;
    private double maxYaxis = 1.0;
    private int serie = 1;
    private boolean outputFull;
    private transient JFrame iFrame;
    private boolean enabled = true;
    private transient ChartingHandle def_handle = new ChartingHandle();
    private transient JLabel status_label = new JLabel("Waiting for network to run!");
    private transient JPanel pane;
    private transient JPanel ControlPane = new JPanel();
    private transient Hashtable ChartBuffers = new Hashtable();
    private transient Hashtable DataRefs = new Hashtable();
    private transient Hashtable DataColors = new Hashtable();
    private transient Hashtable flat_fields = new Hashtable();
    private transient RealType time;
    private transient RealType height;
    private transient FunctionType func_time_height;
    private transient Set time_set;
    private transient FlatField vals_ff;
    private transient DataReferenceImpl data_ref;
    private transient DisplayImplJ2D display;
    private transient GMCWidget control_widg;
    private transient ScalarMap timeMap;
    private transient ScalarMap heightMap;
    private transient RangeWidget timeWidget;
    private transient RangeWidget heightWidget;
    private transient boolean visadinit = false;
    private transient int current_sample_index = 0;

    private void initVisAd(int n, String string) {
        block8: {
            try {
                if (this.getMonitor() != null) {
                    this.getMonitor().addNeuralNetListener(this);
                }
                this.status_label.setText(string);
                this.time = RealType.getRealType((String)"Sample");
                this.height = RealType.getRealType((String)"Value");
                this.func_time_height = new FunctionType((MathType)this.time, (MathType)this.height);
                this.time_set = new Integer1DSet((MathType)this.time, n);
                this.display = new DisplayImplJ2D("display1");
                this.display.setAutoAspect(true);
                GraphicsModeControl graphicsModeControl = this.display.getGraphicsModeControl();
                this.control_widg = new GMCWidget(graphicsModeControl);
                graphicsModeControl.setScaleEnable(true);
                this.timeMap = new ScalarMap((ScalarType)this.time, Display.XAxis);
                this.heightMap = new ScalarMap((ScalarType)this.height, Display.YAxis);
                this.display.addMap(this.timeMap);
                this.display.addMap(this.heightMap);
                this.timeMap.setRange(0.0, (double)this.maxXaxis);
                this.heightMap.setRange(0.0, this.maxYaxis);
                this.timeWidget = new RangeWidget(this.timeMap);
                this.heightWidget = new RangeWidget(this.heightMap);
                if (this.iFrame != null) {
                    this.iFrame.getContentPane().removeAll();
                    this.pane = new JPanel();
                    this.ControlPane = new JPanel();
                    this.pane.setLayout(new BoxLayout(this.pane, 1));
                    this.pane.setAlignmentY(0.0f);
                    this.pane.setAlignmentX(0.0f);
                    this.pane.add(this.display.getComponent());
                    ((JPanel)this.display.getComponent()).setMinimumSize(new Dimension(500, 250));
                    ((JPanel)this.display.getComponent()).setMaximumSize(new Dimension(1000, 500));
                    this.iFrame.getContentPane().setLayout(new BorderLayout());
                    this.iFrame.getContentPane().add((Component)this.pane, "Center");
                    this.iFrame.getContentPane().add((Component)this.timeWidget, "North");
                    this.ControlPane.setLayout(new GridLayout(2, 1));
                    this.ControlPane.add((Component)this.heightWidget);
                    this.ControlPane.add((Component)this.control_widg);
                    this.iFrame.getContentPane().add((Component)this.ControlPane, "South");
                    this.iFrame.setSize(740, 450);
                }
            }
            catch (VisADException visADException) {
                log.error(visADException.toString());
                if (this.getMonitor() != null) {
                    new NetErrorManager(this.getMonitor(), "VisADException while attempting to initialise VisAd. Message is : " + visADException.getMessage());
                }
            }
            catch (RemoteException remoteException) {
                if (this.getMonitor() != null) {
                    new NetErrorManager(this.getMonitor(), "Remote exception while attempting to initialise VisAd. Message is : " + remoteException.getMessage());
                }
            }
            catch (Exception exception) {
                log.error(exception.toString());
                if (this.getMonitor() == null) break block8;
                new NetErrorManager(this.getMonitor(), "Exception while attempting to initialise VisAd. Message is : " + exception.getMessage());
            }
        }
    }

    private void PlotVisAd() {
        Enumeration enumeration = this.ChartBuffers.elements();
        while (enumeration.hasMoreElements()) {
            try {
                SharedBuffer sharedBuffer = (SharedBuffer)enumeration.nextElement();
                ChartingHandle chartingHandle = sharedBuffer.getHandle();
                double[][] dArray = sharedBuffer.get();
                int n = (int)this.timeMap.getRange()[1];
                if (n > dArray.length) {
                    n = dArray.length;
                }
                if (n > 0) {
                    double[][] dArray2 = new double[1][(int)this.timeMap.getRange()[1]];
                    for (int i = 0; i < n; ++i) {
                        dArray2[0][i] = dArray[i][0];
                    }
                    ((FlatField)this.flat_fields.get(chartingHandle)).setSamples(dArray2);
                    ((DataReferenceImpl)this.DataRefs.get(chartingHandle)).setData((Data)((FlatField)this.flat_fields.get(chartingHandle)));
                    this.display.addReference((DataReference)((DataReferenceImpl)this.DataRefs.get(chartingHandle)), (ConstantMap[])this.DataColors.get(chartingHandle));
                    continue;
                }
                log.error("No data to plot!");
                if (this.getMonitor() == null) continue;
                new NetErrorManager(this.getMonitor(), "Warning while attempting to plot VisAd chart. No data to plot!");
            }
            catch (VisADException visADException) {
                log.error(visADException.toString());
                if (this.getMonitor() == null) continue;
                new NetErrorManager(this.getMonitor(), "VisADException while attempting to plot VisAd chart. Message is : " + visADException.getMessage());
            }
            catch (RemoteException remoteException) {
                if (this.getMonitor() == null) continue;
                new NetErrorManager(this.getMonitor(), "Remote Exception while attempting to plot VisAd chart. Message is : " + remoteException.getMessage());
            }
            catch (Exception exception) {
                log.error(exception.toString());
                if (this.getMonitor() == null) continue;
                new NetErrorManager(this.getMonitor(), "Exception while attempting to plot VisAd chart. Message is : " + exception.getMessage());
            }
        }
    }

    public VisADOutputSynapse() {
        this.initComponents();
        this.def_handle.setSerie(this.getSerie());
        this.def_handle.setBlueColor(230);
        this.def_handle.setGreenColor(0);
        this.def_handle.setRedColor(0);
        this.def_handle.setName("Serie " + this.getSerie());
    }

    private void initComponents() {
        this.iFrame = new JFrame();
        this.iFrame.setTitle(this.getTitle());
        this.iFrame.setResizable(this.isResizable());
        this.iFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                VisADOutputSynapse.this.exitForm(windowEvent);
            }
        });
        this.iFrame.pack();
        this.ChartBuffers = new Hashtable();
        this.DataRefs = new Hashtable();
        this.DataColors = new Hashtable();
        this.flat_fields = new Hashtable();
        this.ControlPane = new JPanel();
        this.def_handle = new ChartingHandle();
        this.status_label = new JLabel("Waiting for network to run!");
        this.initVisAd(this.getMaxXaxis(), "Waiting...");
        this.visadinit = true;
    }

    private void exitForm(WindowEvent windowEvent) {
        this.setShow(false);
    }

    public void setMonitor(Monitor monitor) {
        this.monitor = monitor;
        if (this.monitor != null) {
            this.monitor.addNeuralNetListener(this);
        }
    }

    public void fwdPut(Pattern pattern, ChartingHandle chartingHandle) {
        SharedBuffer sharedBuffer = null;
        if (this.isEnabled() && pattern.getCount() > -1) {
            block8: {
                sharedBuffer = this.ChartBuffers.size() > 0 ? (SharedBuffer)this.ChartBuffers.get(chartingHandle) : null;
                if (sharedBuffer == null) {
                    try {
                        sharedBuffer = new SharedBuffer();
                        sharedBuffer.setHandle(chartingHandle);
                        this.ChartBuffers.put(chartingHandle, sharedBuffer);
                        this.time_set = new Integer1DSet((MathType)this.time, (int)this.timeMap.getRange()[1]);
                        this.flat_fields.put(chartingHandle, new FlatField(this.func_time_height, this.time_set));
                        ConstantMap[] constantMapArray = new ConstantMap[]{new ConstantMap((double)((float)chartingHandle.getRedColor() / 255.0f), Display.Red), new ConstantMap((double)((float)chartingHandle.getGreenColor() / 255.0f), Display.Green), new ConstantMap((double)((float)chartingHandle.getBlueColor() / 255.0f), Display.Blue), new ConstantMap(1.0, Display.LineWidth)};
                        this.DataColors.put(chartingHandle, constantMapArray);
                        this.DataRefs.put(chartingHandle, new DataReferenceImpl(chartingHandle.getName()));
                    }
                    catch (VisADException visADException) {
                        log.error(visADException.toString());
                        if (this.getMonitor() != null) {
                            new NetErrorManager(this.getMonitor(), "VisADException while attempting to define VisAd compononent in fwdPut(handle,pattern) method. Message is : " + visADException.getMessage());
                        }
                    }
                    catch (Exception exception) {
                        log.error(exception.toString());
                        if (this.getMonitor() != null) {
                            new NetErrorManager(this.getMonitor(), "Exception while attempting to define VisAd component in fwdPut(handle,pattern) method. Message is : " + exception.getMessage());
                        }
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        log.error(outOfMemoryError.toString());
                        if (this.getMonitor() == null) break block8;
                        new NetErrorManager(this.getMonitor(), "Out of memory error while attempting to define VisAd component in fwdPut(handle,pattern) method. Message is : " + outOfMemoryError.getMessage());
                    }
                }
            }
            sharedBuffer.put(pattern.getArray()[chartingHandle.getSerie() - 1], pattern.getCount());
        }
    }

    public void fwdPut(Pattern pattern) {
        if (this.isEnabled() && pattern.getCount() > -1) {
            SharedBuffer sharedBuffer;
            block8: {
                sharedBuffer = (SharedBuffer)this.ChartBuffers.get(this.def_handle);
                if (sharedBuffer == null) {
                    try {
                        sharedBuffer = new SharedBuffer();
                        sharedBuffer.setHandle(this.def_handle);
                        this.ChartBuffers.put(this.def_handle, sharedBuffer);
                        this.time_set = new Integer1DSet((MathType)this.time, (int)this.timeMap.getRange()[1]);
                        this.flat_fields.put(this.def_handle, new FlatField(this.func_time_height, this.time_set));
                        ConstantMap[] constantMapArray = new ConstantMap[]{new ConstantMap((double)((float)this.def_handle.getRedColor() / 255.0f), Display.Red), new ConstantMap((double)((float)this.def_handle.getGreenColor() / 255.0f), Display.Green), new ConstantMap((double)((float)this.def_handle.getBlueColor() / 255.0f), Display.Blue), new ConstantMap(1.0, Display.LineWidth)};
                        this.DataColors.put(this.def_handle, constantMapArray);
                        this.DataRefs.put(this.def_handle, new DataReferenceImpl(this.def_handle.getName()));
                    }
                    catch (VisADException visADException) {
                        log.error(visADException.toString());
                        if (this.getMonitor() != null) {
                            new NetErrorManager(this.getMonitor(), "VisADException while attempting to define VisAd compononent in fwdPut(pattern) method. Message is : " + visADException.getMessage());
                        }
                    }
                    catch (Exception exception) {
                        log.error(exception.toString());
                        if (this.getMonitor() != null) {
                            new NetErrorManager(this.getMonitor(), "Exception while attempting to define VisAd component in fwdPut(pattern) method. Message is : " + exception.getMessage());
                        }
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        log.error(outOfMemoryError.toString());
                        if (this.getMonitor() == null) break block8;
                        new NetErrorManager(this.getMonitor(), "Out of memory error while attempting to define VisAd component in fwdPut(pattern) method. Message is : " + outOfMemoryError.getMessage());
                    }
                }
            }
            sharedBuffer.put(pattern.getArray()[this.getSerie() - 1], pattern.getCount());
        }
    }

    public Pattern revGet() {
        return null;
    }

    public void setInputDimension(int n) {
    }

    public Monitor getMonitor() {
        return this.monitor;
    }

    public int getInputDimension() {
        return 0;
    }

    public boolean isShow() {
        return this.show;
    }

    public void setShow(boolean bl) {
        this.show = bl;
        if (bl) {
            this.iFrame.setVisible(true);
        } else {
            this.iFrame.setVisible(false);
        }
    }

    public double getMaxYaxis() {
        return this.maxYaxis;
    }

    public void setMaxYaxis(double d) {
        this.maxYaxis = d;
    }

    public int getMaxXaxis() {
        return this.maxXaxis;
    }

    public void setMaxXaxis(int n) {
        this.maxXaxis = n;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initComponents();
        this.def_handle.setSerie(this.getSerie());
        this.def_handle.setBlueColor(230);
        this.def_handle.setGreenColor(0);
        this.def_handle.setRedColor(0);
        this.def_handle.setName("Serie " + this.getSerie());
        this.setShow(false);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.timeMap != null) {
            this.maxXaxis = (int)this.timeMap.getRange()[1];
        }
        if (this.heightMap != null) {
            this.maxYaxis = this.heightMap.getRange()[1];
        }
        objectOutputStream.defaultWriteObject();
    }

    public int getSerie() {
        if (this.serie < 1) {
            this.serie = 1;
        }
        return this.serie;
    }

    public void setSerie(int n) {
        this.serie = n < 1 ? 1 : n;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
        if (this.iFrame != null) {
            this.iFrame.setTitle(string);
        }
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public void setResizable(boolean bl) {
        this.resizable = bl;
        if (this.iFrame != null) {
            this.iFrame.setResizable(bl);
        }
    }

    public TreeSet check() {
        TreeSet treeSet = new TreeSet();
        return treeSet;
    }

    public void cicleTerminated(NeuralNetEvent neuralNetEvent) {
    }

    public void errorChanged(NeuralNetEvent neuralNetEvent) {
    }

    public void netStarted(NeuralNetEvent neuralNetEvent) {
        block6: {
            this.ChartBuffers.clear();
            this.DataRefs.clear();
            this.DataColors.clear();
            this.flat_fields.clear();
            if (!this.visadinit) {
                this.initVisAd(this.getMaxXaxis(), "Collecting data ....");
                this.visadinit = true;
            } else {
                try {
                    this.display.removeAllReferences();
                }
                catch (VisADException visADException) {
                    log.error(visADException.toString());
                    if (this.getMonitor() != null) {
                        new NetErrorManager(this.getMonitor(), "VisADException while attempting to remove Display references in netStarted event. Message is : " + visADException.getMessage());
                    }
                }
                catch (RemoteException remoteException) {
                    log.error(remoteException.toString());
                    if (this.getMonitor() == null) break block6;
                    new NetErrorManager(this.getMonitor(), "RemoteException while attempting to remove Display references in netStarted event. Message is : " + remoteException.getMessage());
                }
            }
        }
        this.status_label.setText("Collecting data ....");
    }

    public void netStopped(NeuralNetEvent neuralNetEvent) {
        try {
            this.status_label.setText("Data collected and displayed.");
            this.PlotVisAd();
        }
        catch (Exception exception) {
            log.error(exception.toString());
        }
    }

    public void netStoppedError(NeuralNetEvent neuralNetEvent, String string) {
    }

    public void removeHandle(ChartingHandle chartingHandle) {
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isOutputFull() {
        return this.outputFull;
    }

    public void setOutputFull(boolean bl) {
        this.outputFull = bl;
    }

    public void init() {
    }
}

