/*
 * Decompiled with CFR 0.152.
 */
package org.joone.edit;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.TreeSet;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import org.joone.edit.JoonEdit;
import org.joone.edit.NeuralNetDrawing;
import org.joone.net.NetCheck;
import org.joone.net.NetChecker;
import org.joone.net.NeuralNet;

public class TodoFrame
extends JFrame {
    private JoonEdit owner = null;
    private JPanel centerPanel = new JPanel();

    public TodoFrame(Frame frame) {
        this.owner = (JoonEdit)((Object)frame);
        this.setTitle("To Do List");
        this.setResizable(false);
        JRootPane jRootPane = this.getRootPane();
        jRootPane.setLayout(new BorderLayout());
        this.centerPanel.setLayout(new GridLayout(0, 1));
        jRootPane.add((Component)this.centerPanel, "Center");
        Button button = new Button("Revalidate");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TodoFrame.this.check();
                TodoFrame.this.pack();
                TodoFrame.this.repaint();
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.add(button);
        jRootPane.add((Component)jPanel, "South");
    }

    public void show() {
        this.check();
        this.pack();
        this.setIconImage(this.owner.getIconImage());
        this.setLocation((this.owner.getWidth() - this.owner.getX() - this.getWidth()) / 2, (this.owner.getHeight() - this.owner.getY() - this.getHeight()) / 2);
        super.show();
    }

    private void check() {
        NeuralNetDrawing neuralNetDrawing = (NeuralNetDrawing)this.owner.drawing();
        NeuralNet neuralNet = neuralNetDrawing.getNeuralNet();
        NetChecker netChecker = new NetChecker(neuralNet);
        TreeSet treeSet = netChecker.check();
        this.centerPanel.removeAll();
        if (treeSet.isEmpty()) {
            this.centerPanel.add(new JLabel("Network checks out okay."));
        } else {
            for (NetCheck netCheck : treeSet) {
                this.centerPanel.add(new JLabel(netCheck.toString()));
            }
        }
    }
}

