/*
 * Decompiled with CFR 0.152.
 */
package org.joone.edit;

import org.joone.edit.ChartingHandle;
import org.joone.engine.Fifo;
import org.joone.engine.Pattern;

public class SharedBuffer {
    private final int ERROR = 0;
    private final int CYCLE = 1;
    private double[][] buffer;
    private Fifo fifoBuffer = new Fifo();
    private ChartingHandle handle;

    public synchronized double[][] get() {
        while (this.fifoBuffer.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.buffer = this.extractBuffer(this.fifoBuffer);
        this.notifyAll();
        return this.buffer;
    }

    public synchronized double[][] getNoWait() {
        if (this.fifoBuffer.isEmpty()) {
            return null;
        }
        this.buffer = this.extractBuffer(this.fifoBuffer);
        return this.buffer;
    }

    private double[][] extractBuffer(Fifo fifo) {
        int n = fifo.size();
        double[][] dArray = new double[n + 1][2];
        for (int i = 0; i < n; ++i) {
            Pattern pattern = (Pattern)fifo.pop();
            dArray[i][1] = pattern.getCount();
            dArray[i][0] = pattern.getArray()[0];
        }
        dArray[n][0] = 0.0;
        dArray[n][1] = -1.0;
        return dArray;
    }

    public synchronized void put(double d, double d2) {
        Pattern pattern = new Pattern(d);
        pattern.setCount(new Double(d2).intValue());
        this.fifoBuffer.push(pattern);
        this.notifyAll();
    }

    public ChartingHandle getHandle() {
        return this.handle;
    }

    public void setHandle(ChartingHandle chartingHandle) {
        this.handle = chartingHandle;
    }
}

