/*
 * Decompiled with CFR 0.152.
 */
package org.joone.edit;

import CH.ifa.draw.figures.ArrowTip;
import CH.ifa.draw.figures.LineConnection;
import CH.ifa.draw.figures.LineDecoration;
import CH.ifa.draw.figures.PolyLineFigure;
import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.DeleteCommand;
import CH.ifa.draw.standard.NullHandle;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.joone.edit.ConcreteGenericFigure;
import org.joone.edit.GenericFigure;
import org.joone.edit.LayerFigure;
import org.joone.edit.OutputLayerFigure;
import org.joone.edit.PropertySheet;
import org.joone.edit.UpdatableFigure;
import org.joone.edit.Wrapper;
import org.joone.edit.inspection.InspectionFrame;
import org.joone.engine.OutputPatternListener;
import org.joone.engine.Synapse;
import org.joone.inspection.Inspectable;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;

public class LayerConnection
extends LineConnection
implements GenericFigure,
UpdatableFigure {
    private static final ILogger log = LoggerFactory.getLogger(LayerConnection.class);
    private static final long serialVersionUID = -1564509302372952850L;
    private Hashtable params;
    protected Synapse mySynapse;

    public LayerConnection() {
        this.setEndDecoration((LineDecoration)new ArrowTip());
        this.setStartDecoration(null);
        this.params = new Hashtable();
    }

    public void handleConnect(Figure figure, Figure figure2) {
        LayerFigure layerFigure = (LayerFigure)figure;
        LayerFigure layerFigure2 = (LayerFigure)figure2;
        if (figure2 instanceof OutputLayerFigure) {
            OutputLayerFigure outputLayerFigure = (OutputLayerFigure)layerFigure2;
            OutputPatternListener outputPatternListener = outputLayerFigure.getOutputLayer();
            outputLayerFigure.addPreConn(layerFigure);
            layerFigure.addPostConn(layerFigure2, outputPatternListener);
            layerFigure.notifyPostConn();
        } else {
            this.mySynapse = (Synapse)this.createSynapse();
            boolean bl = layerFigure2.addPreConn(layerFigure, this.mySynapse);
            layerFigure.addPostConn(layerFigure2, this.mySynapse);
            layerFigure.notifyPostConn();
            if (bl && layerFigure.hasCycle((Figure)layerFigure2)) {
                this.setAttribute("FrameColor", Color.red);
                this.mySynapse.setLoopBack(true);
            }
        }
    }

    public void handleDisconnect(Figure figure, Figure figure2) {
        LayerFigure layerFigure = (LayerFigure)figure;
        LayerFigure layerFigure2 = (LayerFigure)figure2;
        if (layerFigure2 != null) {
            layerFigure2.removePreConn(layerFigure, this.getSynapse());
        }
        if (layerFigure != null) {
            if (layerFigure2 instanceof OutputLayerFigure) {
                layerFigure.removePostConn(layerFigure2, ((OutputLayerFigure)layerFigure2).getOutputLayer());
            } else {
                layerFigure.removePostConn(layerFigure2, this.getSynapse());
            }
        }
    }

    public boolean canConnect(Figure figure, Figure figure2) {
        boolean bl;
        boolean bl2 = bl = figure instanceof ConcreteGenericFigure && figure2 instanceof ConcreteGenericFigure;
        if (bl) {
            ConcreteGenericFigure concreteGenericFigure = (ConcreteGenericFigure)figure2;
            ConcreteGenericFigure concreteGenericFigure2 = (ConcreteGenericFigure)figure;
            bl = bl && concreteGenericFigure.canConnect(concreteGenericFigure2, (ConnectionFigure)this);
        }
        return bl;
    }

    public Vector handles() {
        Vector vector = super.handles();
        vector.setElementAt(new NullHandle((Figure)this, PolyLineFigure.locator((int)0)), 0);
        return vector;
    }

    protected Object createSynapse() {
        try {
            String string = (String)this.getParam("class");
            if (string == null) {
                string = "org.joone.engine.FullSynapse";
            }
            Class<?> clazz = Class.forName(string);
            Object obj = clazz.newInstance();
            return obj;
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.warn("ClassNotFoundException thrown. Message is : " + classNotFoundException.getMessage(), classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            log.warn("InstantiationException thrown. Message is : " + instantiationException.getMessage(), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.warn("IllegalAccessException thrown. Message is : " + illegalAccessException.getMessage(), illegalAccessException);
        }
        return null;
    }

    public Synapse getSynapse() {
        return this.mySynapse;
    }

    public void setSynapse(Synapse synapse) {
        this.mySynapse = synapse;
    }

    public Object getParam(Object object) {
        if (this.params == null) {
            return null;
        }
        return this.params.get(object);
    }

    public void setParam(Object object, Object object2) {
        this.params.put(object, object2);
    }

    public void setParams(Hashtable hashtable) {
        this.params = hashtable;
    }

    public Wrapper getWrapper() {
        Synapse synapse = this.getSynapse();
        if (synapse != null) {
            return new Wrapper(this, this.getSynapse(), this.getSynapse().getName());
        }
        return null;
    }

    public void update() {
    }

    public boolean canConnect(GenericFigure genericFigure, ConnectionFigure connectionFigure) {
        return true;
    }

    public void draw(Graphics graphics) {
        Object object = this.getAttribute("FrameColor");
        if (this.mySynapse != null && this.mySynapse.isLoopBack()) {
            this.setAttribute("FrameColor", Color.red);
        } else {
            this.setAttribute("FrameColor", object);
        }
        super.draw(graphics);
        String string = (String)this.getParam("label");
        Synapse synapse = this.getSynapse();
        if (string != null && synapse != null) {
            int n = this.fPoints.size();
            Point point = (Point)this.fPoints.elementAt(0);
            Point point2 = (Point)this.fPoints.elementAt(n - 1);
            int n2 = point.x;
            int n3 = point2.x;
            if (n2 < point2.x) {
                n2 = point2.x;
                n3 = point.x;
            }
            int n4 = point.y;
            int n5 = point2.y;
            if (n4 < point2.y) {
                n4 = point2.y;
                n5 = point.y;
            }
            Point point3 = new Point();
            point3.x = n2 + (n3 - n2) / 2;
            point3.y = n4 + (n5 - n4) / 2;
            if (synapse.isEnabled()) {
                graphics.setColor(new Color(255, 255, 255));
            } else {
                graphics.setColor(new Color(170, 170, 170));
            }
            graphics.fillRect(point3.x - 6, point3.y - 7, 12, 14);
            graphics.setColor(new Color(0, 0, 200));
            graphics.drawRect(point3.x - 6, point3.y - 7, 12, 14);
            graphics.drawString(string, point3.x - 4, point3.y + 5);
            graphics.setColor(this.getFrameColor());
        }
    }

    public JPopupMenu getPopupMenu(final PropertySheet propertySheet, final DrawingView drawingView) {
        JMenuItem jMenuItem;
        JPopupMenu jPopupMenu = new JPopupMenu();
        final Wrapper wrapper = this.getWrapper();
        if (wrapper != null) {
            jMenuItem = new JMenuItem("Properties");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (propertySheet != null) {
                        propertySheet.setTarget(wrapper);
                        propertySheet.pack();
                        if (propertySheet.getSize().width < 250) {
                            propertySheet.setSize(new Dimension(250, propertySheet.getSize().height));
                        }
                        propertySheet.show();
                    }
                }
            });
            jPopupMenu.add(jMenuItem);
        }
        jMenuItem = new JMenuItem("Delete");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new DeleteCommand("Delete", drawingView).execute();
            }
        });
        jPopupMenu.add(jMenuItem);
        if (wrapper != null && this.getWrapper().getBean() instanceof Inspectable) {
            jMenuItem = new JMenuItem("Inspect");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Inspectable inspectable = (Inspectable)LayerConnection.this.getWrapper().getBean();
                    InspectionFrame inspectionFrame = new InspectionFrame(inspectable);
                    inspectionFrame.show();
                }
            });
            jPopupMenu.add(jMenuItem);
        }
        return jPopupMenu;
    }
}

