/*
 * Decompiled with CFR 0.152.
 */
package org.joone.edit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditorSupport;
import java.io.File;
import org.joone.edit.CaseAwareTextDisplay;
import org.joone.edit.JooneFileChooser;

public class JooneFileChooserEditor
extends PropertyEditorSupport
implements ActionListener {
    private JooneFileChooser fileChooser = new JooneFileChooser();
    private CaseAwareTextDisplay fileChooserPanel;

    public JooneFileChooserEditor() {
        this.fileChooser.addActionListener(this);
        this.fileChooserPanel = new CaseAwareTextDisplay();
        this.fileChooserPanel.setText("wordA wordB");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("ApproveSelection")) {
            this.setValue(this.getValue());
        }
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.translate(rectangle.x, rectangle.y);
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, rectangle.width, rectangle.height);
        graphics.setColor(Color.black);
        this.fileChooserPanel.paint(graphics);
    }

    public void setValue(Object object) {
        File file = new File((String)object);
        this.fileChooser.setSelectedFile(file);
        this.fileChooserPanel.setText(file.getName());
        this.firePropertyChange();
    }

    public Object getValue() {
        return this.fileChooser.getSelectedFile().getAbsolutePath();
    }

    public Component getCustomEditor() {
        return this.fileChooser;
    }

    public boolean supportsCustomEditor() {
        return true;
    }
}

