/*
 * Decompiled with CFR 0.152.
 */
package org.joone.edit;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;

public class JooneFileChooser
extends JFileChooser {
    private static final ILogger log = LoggerFactory.getLogger(JooneFileChooser.class);
    private String m_dir = System.getProperty("user.home") + System.getProperty("file.separator") + "Joone Edit" + "_DIRECTORY_HISTORY.cfg";
    private FileInputStream m_fis;
    private ObjectInputStream m_ois;
    private Vector m_dirList;
    private static final String APPLICATION_NAME = "Joone Edit";
    private HistoryAndPreviewPanel m_historyAndPreviewPanel;
    private JComboBox m_comboBox;
    private TextPreviewer m_previewer;
    private static final long serialVersionUID = 8488231091781173351L;

    public JooneFileChooser(String string) {
        super(string);
        if (new File(this.m_dir).exists()) {
            try {
                this.m_fis = new FileInputStream(this.m_dir);
            }
            catch (FileNotFoundException fileNotFoundException) {
                log.warn("File '" + this.m_dir + "' not found. Message is : " + fileNotFoundException.getMessage());
            }
            try {
                this.m_ois = new ObjectInputStream(this.m_fis);
            }
            catch (StreamCorruptedException streamCorruptedException) {
                new File(this.m_dir).delete();
                this.m_dirList = new Vector();
            }
            catch (IOException iOException) {
                log.warn("File '" + this.m_dir + "' input/output error. Message is : " + iOException.getMessage());
                this.m_dirList = new Vector();
            }
            try {
                if (this.m_ois != null) {
                    this.m_dirList = (Vector)this.m_ois.readObject();
                    if (this.m_dirList == null) {
                        this.m_dirList = new Vector();
                    }
                } else {
                    this.m_dirList = new Vector();
                }
            }
            catch (OptionalDataException optionalDataException) {
                log.warn("File '" + this.m_dir + "' does not contain object.");
                this.m_dirList = new Vector();
            }
            catch (IOException iOException) {
                log.warn("File '" + this.m_dir + "' input/output error. Message is : " + iOException.getMessage());
                this.m_dirList = new Vector();
            }
            catch (ClassNotFoundException classNotFoundException) {
                log.warn("ClassNotFoundException thrown. Message is : " + classNotFoundException.getMessage());
                this.m_dirList = new Vector();
            }
            try {
                if (this.m_ois != null) {
                    this.m_ois.close();
                }
                this.m_fis.close();
            }
            catch (IOException iOException) {
                log.warn("File '" + this.m_dir + "' input/output error. Message is : " + iOException.getMessage());
            }
        } else {
            this.m_dirList = new Vector();
        }
        this.setMultiSelectionEnabled(false);
        this.m_historyAndPreviewPanel = new HistoryAndPreviewPanel();
        this.setAccessory(this.m_historyAndPreviewPanel);
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                File file;
                if (propertyChangeEvent.getPropertyName().equals("directoryChanged")) {
                    JooneFileChooser.this.m_previewer.clear();
                }
                if (propertyChangeEvent.getPropertyName().equals("SelectedFileChangedProperty") && (file = (File)propertyChangeEvent.getNewValue()) != null && file.isFile()) {
                    JooneFileChooser.this.m_previewer.showFileContents(file);
                    JooneFileChooser.this.addDirectory(file);
                }
            }
        });
    }

    public JooneFileChooser() {
        this(".");
    }

    public void saveDirectoryEntries() {
        FileOutputStream fileOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.m_dir);
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.warn("File '" + this.m_dir + "' not found.", fileNotFoundException);
        }
        try {
            objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this.m_dirList);
            objectOutputStream.flush();
            objectOutputStream.close();
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        catch (IOException iOException) {
            log.warn("File '" + this.m_dir + "' input/output error. Message is : " + iOException.getMessage(), iOException);
        }
    }

    private void addDirectory(File file) {
        if (file == null || file.getName().equals("")) {
            return;
        }
        String string = file.getAbsolutePath();
        int n = string.lastIndexOf(System.getProperty("file.separator"));
        String string2 = string.substring(0, n);
        this.m_dirList.removeElement(string2);
        this.m_dirList.add(0, string2);
        this.updateJComboBox();
    }

    private void updateJComboBox() {
        this.m_comboBox.revalidate();
        this.m_comboBox.setSelectedIndex(0);
    }

    public static void main(String[] stringArray) {
        final JFrame jFrame = new JFrame("Joone FileChooser Demo");
        final JooneFileChooser jooneFileChooser = new JooneFileChooser();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                jooneFileChooser.saveDirectoryEntries();
                jFrame.setVisible(false);
                jFrame.dispose();
                System.exit(0);
            }
        });
        JMenuBar jMenuBar = new JMenuBar();
        jFrame.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic('F');
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("Open...");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                File file;
                jooneFileChooser.setCurrentDirectory(new File("."));
                String string = actionEvent.toString();
                int n = jooneFileChooser.showOpenDialog(jFrame);
                if (n == 0 && (file = jooneFileChooser.getSelectedFile()) != null && !file.getName().equals("")) {
                    string = file.getName();
                }
            }
        });
        jMenu.add(jMenuItem);
        jFrame.pack();
        jFrame.setSize(310, 130);
        jFrame.setVisible(true);
    }

    private class TextPreviewer
    extends JComponent {
        private JTextArea m_textArea = new JTextArea();
        private JScrollPane m_scroller = new JScrollPane(this.m_textArea);
        private char[] m_buf = new char[500];
        private static final long serialVersionUID = -1771309681222930860L;

        public TextPreviewer() {
            this.m_textArea.setEditable(false);
            this.setLayout(new BorderLayout());
            this.add((Component)this.m_scroller, "Center");
        }

        public void showFileContents(File file) {
            this.m_textArea.setText(this.readFile(file));
            this.m_textArea.setCaretPosition(0);
        }

        public void clear() {
            this.m_textArea.setText("");
        }

        private String readFile(File file) {
            String string = null;
            FileReader fileReader = null;
            try {
                fileReader = new FileReader(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                log.warn("File '" + file + "' not found.", fileNotFoundException);
                return string;
            }
            try {
                int n = fileReader.read(this.m_buf, 0, this.m_buf.length);
                if (n != -1) {
                    string = new String(this.m_buf, 0, n);
                }
                fileReader.close();
            }
            catch (IOException iOException) {
                log.warn("File '" + JooneFileChooser.this.m_dir + "' input/output error.", iOException);
            }
            return string;
        }
    }

    private final class HistoryAndPreviewPanel
    extends JPanel {
        private static final long serialVersionUID = 8111982139735281484L;

        public HistoryAndPreviewPanel() {
            this.setPreferredSize(new Dimension(250, 250));
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setLayout(new BorderLayout());
            JooneFileChooser.this.m_comboBox = new JComboBox(JooneFileChooser.this.m_dirList);
            JooneFileChooser.this.m_comboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = (String)JooneFileChooser.this.m_comboBox.getSelectedItem();
                    JooneFileChooser.this.setCurrentDirectory(new File(string));
                    JLabel jLabel = new JLabel(string);
                    jLabel.setFont(JooneFileChooser.this.m_comboBox.getFont());
                    if (jLabel.getPreferredSize().width > ((JooneFileChooser)JooneFileChooser.this).m_comboBox.getSize().width) {
                        JooneFileChooser.this.m_comboBox.setToolTipText(string);
                    } else {
                        JooneFileChooser.this.m_comboBox.setToolTipText(null);
                    }
                }
            });
            this.add((Component)JooneFileChooser.this.m_comboBox, "North");
            JooneFileChooser.this.m_previewer = new TextPreviewer();
            this.add((Component)JooneFileChooser.this.m_previewer, "Center");
        }
    }
}

