/*
 * Decompiled with CFR 0.152.
 */
package org.joone.edit;

import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.contrib.DiamondFigure;
import CH.ifa.draw.contrib.PolygonTool;
import CH.ifa.draw.contrib.TriangleFigure;
import CH.ifa.draw.figures.BorderTool;
import CH.ifa.draw.figures.ConnectedTextTool;
import CH.ifa.draw.figures.EllipseFigure;
import CH.ifa.draw.figures.GroupCommand;
import CH.ifa.draw.figures.LineFigure;
import CH.ifa.draw.figures.RectangleFigure;
import CH.ifa.draw.figures.RoundRectangleFigure;
import CH.ifa.draw.figures.ScribbleTool;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.figures.TextTool;
import CH.ifa.draw.figures.UngroupCommand;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.HJDError;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.standard.AlignCommand;
import CH.ifa.draw.standard.BringToFrontCommand;
import CH.ifa.draw.standard.CreationTool;
import CH.ifa.draw.standard.DeleteCommand;
import CH.ifa.draw.standard.PasteCommand;
import CH.ifa.draw.standard.SendToBackCommand;
import CH.ifa.draw.standard.StandardDrawingView;
import CH.ifa.draw.standard.ToggleGridCommand;
import CH.ifa.draw.util.Command;
import CH.ifa.draw.util.CommandMenu;
import CH.ifa.draw.util.Iconkit;
import CH.ifa.draw.util.SerializationStorageFormat;
import CH.ifa.draw.util.StorageFormat;
import CH.ifa.draw.util.StorageFormatManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MenuShortcut;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.Calendar;
import java.util.Vector;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.joone.edit.AboutFrame;
import org.joone.edit.DelegationSelectionTool;
import org.joone.edit.EditorParameters;
import org.joone.edit.IniFile;
import org.joone.edit.JMacroEditor;
import org.joone.edit.JooneCommandMenu;
import org.joone.edit.JooneCopyCommand;
import org.joone.edit.JooneCutCommand;
import org.joone.edit.JooneDuplicateCommand;
import org.joone.edit.JooneFileChooser;
import org.joone.edit.JooneStandardDrawingView;
import org.joone.edit.LayerFigure;
import org.joone.edit.LayerFigureCreationTool;
import org.joone.edit.MonitorPropertySheet;
import org.joone.edit.NetStorageFormat;
import org.joone.edit.NetStorageFormatManager;
import org.joone.edit.NeuralNetDrawing;
import org.joone.edit.PropertySheet;
import org.joone.edit.StandardNetStorageFormat;
import org.joone.edit.SynapseCreationTool;
import org.joone.edit.TodoFrame;
import org.joone.edit.ToolElement;
import org.joone.edit.ToolsSAXParser;
import org.joone.edit.Wrapper;
import org.joone.edit.XMLNetStorageFormat;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NeuralNet;
import org.joone.samples.editor.som.SOMImageTester;
import org.joone.util.MacroPlugin;

public class JoonEdit
extends DrawApplication {
    private static final ILogger log = LoggerFactory.getLogger(JoonEdit.class);
    private static final int MAJOR_RELEASE = 2;
    private static final int MINOR_RELEASE = 0;
    private static final int BUILD = 0;
    private static final String SUFFIX = "RC1";
    public static final String INI_FILE_NAME = "joonedit.config";
    private static final int RECO_ENG_MAJOR_RELEASE = 1;
    private static final int RECO_ENG_MINOR_RELEASE = 2;
    private static final int RECO_ENG_BUILD = 5;
    public static final String DIAGRAM_IMAGES = "/org/joone/images/";
    public static final String MENU_IMAGES = "/org/joone/images/menu/";
    private PropertySheet psp;
    private InputStream XMLParamsFile;
    private JooneFileChooser m_openDialog = null;
    private NetStorageFormatManager fNetStorageFormatManager;
    private NetStorageFormatManager xNetStorageFormatManager;
    private ToolsSAXParser tParser;
    private EditorParameters parameters;
    private MonitorPropertySheet ps;
    private static final long serialVersionUID = -4579162097589626753L;
    private AboutFrame af = null;
    private TodoFrame tf = null;
    private StorageFormat latestStorageFormat;
    private JMacroEditor macroEditor;
    private IniFile iniFile = null;
    private int width = 800;
    private int height = 600;

    public JoonEdit(String string) {
        super("JoonEdit - Joone Neural Net Editor");
        try {
            this.initJoonEdit(new FileInputStream(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.fatal("FileNotFoundException thrown with params " + string + ". Message is " + fileNotFoundException.getMessage(), fileNotFoundException);
            System.exit(0);
        }
    }

    public JoonEdit() {
        super("JoonEdit - Joone Neural Net Editor");
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/org/joone/data/layers.xml");
        this.initJoonEdit(inputStream);
    }

    private void initJoonEdit(InputStream inputStream) {
        this.XMLParamsFile = inputStream;
        this.fNetStorageFormatManager = this.createNetStorageFormatManager();
        this.xNetStorageFormatManager = this.createXMLStorageFormatManager();
        this.setDefaultCloseOperation(0);
        this.readIniFile();
    }

    public static void center(Window window) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = window.getSize();
        window.setLocation(dimension.width / 2 - dimension2.width / 2, dimension.height / 2 - dimension2.height / 2);
    }

    protected JComponent createContents(StandardDrawingView standardDrawingView) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JScrollPane jScrollPane = (JScrollPane)super.createContents(standardDrawingView);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JToolBar[] jToolBarArray = new JToolBar[2];
        for (int i = 0; i < jToolBarArray.length; ++i) {
            jToolBarArray[i] = this.createToolPalette();
        }
        this.createMyTools(jToolBarArray);
        jPanel2.add((Component)jToolBarArray[0], "North");
        jPanel2.add((Component)jToolBarArray[1], "South");
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    protected void createTools(JToolBar jToolBar) {
        super.createTools(jToolBar);
        jToolBar.addSeparator();
        TextTool textTool = new TextTool(this.view(), (Figure)new TextFigure());
        jToolBar.add((Component)this.createToolButton("/CH/ifa/draw/images/TEXT", "Label", (Tool)textTool));
        textTool = new ConnectedTextTool(this.view(), (Figure)new TextFigure());
        jToolBar.add((Component)this.createToolButton("/CH/ifa/draw/images/ATEXT", "Connected Text Tool", (Tool)textTool));
        jToolBar.addSeparator();
        textTool = new CreationTool(this.view(), (Figure)new RectangleFigure());
        jToolBar.add((Component)this.createToolButton("/CH/ifa/draw/images/RECT", "Rectangle Tool", (Tool)textTool));
        textTool = new CreationTool(this.view(), (Figure)new RoundRectangleFigure());
        jToolBar.add((Component)this.createToolButton("/CH/ifa/draw/images/RRECT", "Round Rectangle Tool", (Tool)textTool));
        textTool = new CreationTool(this.view(), (Figure)new EllipseFigure());
        jToolBar.add((Component)this.createToolButton("/CH/ifa/draw/images/ELLIPSE", "Ellipse Tool", (Tool)textTool));
        textTool = new CreationTool(this.view(), (Figure)new TriangleFigure());
        jToolBar.add((Component)this.createToolButton("/CH/ifa/draw/images/TRIANGLE", "Triangle Tool", (Tool)textTool));
        textTool = new CreationTool(this.view(), (Figure)new DiamondFigure());
        jToolBar.add((Component)this.createToolButton("/CH/ifa/draw/images/DIAMOND", "Diamond Tool", (Tool)textTool));
        textTool = new PolygonTool(this.view());
        jToolBar.add((Component)this.createToolButton("/CH/ifa/draw/images/POLYGON", "Polygon Tool", (Tool)textTool));
        textTool = new CreationTool(this.view(), (Figure)new LineFigure());
        jToolBar.add((Component)this.createToolButton("/CH/ifa/draw/images/LINE", "Line Tool", (Tool)textTool));
        textTool = new BorderTool(this.view());
        jToolBar.add((Component)this.createToolButton("/CH/ifa/draw/images/BORDDEC", "Border Tool", (Tool)textTool));
        textTool = new ScribbleTool(this.view());
        jToolBar.add((Component)this.createToolButton("/CH/ifa/draw/images/SCRIBBL", "Scribble Tool", (Tool)textTool));
    }

    protected void createMyTools(JToolBar[] jToolBarArray) {
        this.tParser = new ToolsSAXParser(this.XMLParamsFile);
        Vector vector = this.tParser.getElements();
        JToolBar jToolBar = jToolBarArray[0];
        for (int i = 0; i < vector.size(); ++i) {
            LayerFigureCreationTool layerFigureCreationTool;
            ToolElement toolElement = (ToolElement)vector.elementAt(i);
            if (toolElement.getType().compareToIgnoreCase("break") == 0) {
                jToolBar = jToolBarArray[1];
            }
            if (toolElement.getType().compareToIgnoreCase("separator") == 0) {
                jToolBar.addSeparator();
            }
            if (toolElement.getType().compareToIgnoreCase("layer") == 0) {
                layerFigureCreationTool = new LayerFigureCreationTool(this.view(), "org.joone.edit.LayerFigure");
                layerFigureCreationTool.setParams(toolElement.getParams());
                jToolBar.add((Component)this.createToolButton(DIAGRAM_IMAGES + (String)layerFigureCreationTool.getParam("image"), "New " + (String)layerFigureCreationTool.getParam("type") + " layer", (Tool)layerFigureCreationTool));
            }
            if (toolElement.getType().compareToIgnoreCase("input_layer") == 0) {
                layerFigureCreationTool = new LayerFigureCreationTool(this.view(), "org.joone.edit.InputLayerFigure");
                layerFigureCreationTool.setParams(toolElement.getParams());
                jToolBar.add((Component)this.createToolButton(DIAGRAM_IMAGES + (String)layerFigureCreationTool.getParam("image"), "New " + (String)layerFigureCreationTool.getParam("type") + " layer", (Tool)layerFigureCreationTool));
            }
            if (toolElement.getType().compareToIgnoreCase("output_layer") == 0) {
                layerFigureCreationTool = new LayerFigureCreationTool(this.view(), "org.joone.edit.OutputLayerFigure");
                layerFigureCreationTool.setParams(toolElement.getParams());
                jToolBar.add((Component)this.createToolButton(DIAGRAM_IMAGES + (String)layerFigureCreationTool.getParam("image"), "New " + (String)layerFigureCreationTool.getParam("type") + " layer", (Tool)layerFigureCreationTool));
            }
            if (toolElement.getType().compareToIgnoreCase("teacher_layer") == 0) {
                layerFigureCreationTool = new LayerFigureCreationTool(this.view(), "org.joone.edit.TeacherLayerFigure");
                layerFigureCreationTool.setParams(toolElement.getParams());
                jToolBar.add((Component)this.createToolButton(DIAGRAM_IMAGES + (String)layerFigureCreationTool.getParam("image"), "New " + (String)layerFigureCreationTool.getParam("type") + " layer", (Tool)layerFigureCreationTool));
            }
            if (toolElement.getType().compareToIgnoreCase("input_plugin") == 0) {
                layerFigureCreationTool = new LayerFigureCreationTool(this.view(), "org.joone.edit.InputPluginLayerFigure");
                layerFigureCreationTool.setParams(toolElement.getParams());
                jToolBar.add((Component)this.createToolButton(DIAGRAM_IMAGES + (String)layerFigureCreationTool.getParam("image"), "New " + (String)layerFigureCreationTool.getParam("type"), (Tool)layerFigureCreationTool));
            }
            if (toolElement.getType().compareToIgnoreCase("monitor_plugin") == 0) {
                layerFigureCreationTool = new LayerFigureCreationTool(this.view(), "org.joone.edit.MonitorPluginFigure");
                layerFigureCreationTool.setParams(toolElement.getParams());
                jToolBar.add((Component)this.createToolButton(DIAGRAM_IMAGES + (String)layerFigureCreationTool.getParam("image"), "New " + (String)layerFigureCreationTool.getParam("type"), (Tool)layerFigureCreationTool));
            }
            if (toolElement.getType().compareToIgnoreCase("input_switch") == 0) {
                layerFigureCreationTool = new LayerFigureCreationTool(this.view(), "org.joone.edit.InputSwitchLayerFigure");
                layerFigureCreationTool.setParams(toolElement.getParams());
                jToolBar.add((Component)this.createToolButton(DIAGRAM_IMAGES + (String)layerFigureCreationTool.getParam("image"), "New " + (String)layerFigureCreationTool.getParam("type"), (Tool)layerFigureCreationTool));
            }
            if (toolElement.getType().compareToIgnoreCase("input_connector") == 0) {
                layerFigureCreationTool = new LayerFigureCreationTool(this.view(), "org.joone.edit.InputConnectorLayerFigure");
                layerFigureCreationTool.setParams(toolElement.getParams());
                jToolBar.add((Component)this.createToolButton(DIAGRAM_IMAGES + (String)layerFigureCreationTool.getParam("image"), "New " + (String)layerFigureCreationTool.getParam("type"), (Tool)layerFigureCreationTool));
            }
            if (toolElement.getType().compareToIgnoreCase("output_switch") == 0) {
                layerFigureCreationTool = new LayerFigureCreationTool(this.view(), "org.joone.edit.OutputSwitchLayerFigure");
                layerFigureCreationTool.setParams(toolElement.getParams());
                jToolBar.add((Component)this.createToolButton(DIAGRAM_IMAGES + (String)layerFigureCreationTool.getParam("image"), "New " + (String)layerFigureCreationTool.getParam("type"), (Tool)layerFigureCreationTool));
            }
            if (toolElement.getType().compareToIgnoreCase("script_plugin") == 0) {
                layerFigureCreationTool = new LayerFigureCreationTool(this.view(), "org.joone.edit.ScriptPluginFigure");
                layerFigureCreationTool.setParams(toolElement.getParams());
                jToolBar.add((Component)this.createToolButton(DIAGRAM_IMAGES + (String)layerFigureCreationTool.getParam("image"), "New " + (String)layerFigureCreationTool.getParam("type"), (Tool)layerFigureCreationTool));
            }
            if (toolElement.getType().compareToIgnoreCase("learning_switch") == 0) {
                layerFigureCreationTool = new LayerFigureCreationTool(this.view(), "org.joone.edit.LearningSwitchLayerFigure");
                layerFigureCreationTool.setParams(toolElement.getParams());
                jToolBar.add((Component)this.createToolButton(DIAGRAM_IMAGES + (String)layerFigureCreationTool.getParam("image"), "New " + (String)layerFigureCreationTool.getParam("type"), (Tool)layerFigureCreationTool));
            }
            if (toolElement.getType().compareToIgnoreCase("synapse") == 0) {
                SynapseCreationTool synapseCreationTool = new SynapseCreationTool(this.view(), "org.joone.edit.LayerConnection");
                synapseCreationTool.setParams(toolElement.getParams());
                jToolBar.add((Component)this.createToolButton(DIAGRAM_IMAGES + (String)synapseCreationTool.getParam("image"), "New " + (String)synapseCreationTool.getParam("type"), (Tool)synapseCreationTool));
            }
            if (toolElement.getType().compareToIgnoreCase("output_plugin") == 0) {
                layerFigureCreationTool = new LayerFigureCreationTool(this.view(), "org.joone.edit.OutputPluginLayerFigure");
                layerFigureCreationTool.setParams(toolElement.getParams());
                jToolBar.add((Component)this.createToolButton(DIAGRAM_IMAGES + (String)layerFigureCreationTool.getParam("image"), "New " + (String)layerFigureCreationTool.getParam("type"), (Tool)layerFigureCreationTool));
            }
            if (toolElement.getType().compareToIgnoreCase("chart_handle") != 0) continue;
            layerFigureCreationTool = new LayerFigureCreationTool(this.view(), "org.joone.edit.ChartHandleLayerFigure");
            layerFigureCreationTool.setParams(toolElement.getParams());
            jToolBar.add((Component)this.createToolButton(DIAGRAM_IMAGES + (String)layerFigureCreationTool.getParam("image"), "New " + (String)layerFigureCreationTool.getParam("type"), (Tool)layerFigureCreationTool));
        }
    }

    protected Tool createSelectionTool() {
        DelegationSelectionTool delegationSelectionTool = new DelegationSelectionTool(this.view());
        this.psp = new PropertySheet(500, 100);
        delegationSelectionTool.setPropertyPanel(this.psp);
        return delegationSelectionTool;
    }

    protected void createMenus(JMenuBar jMenuBar) {
        jMenuBar.add(this.createFileMenu());
        jMenuBar.add(this.createEditMenu());
        jMenuBar.add(this.createAlignmentMenu());
        jMenuBar.add(this.createAttributesMenu());
        jMenuBar.add(this.createToolsMenu());
        jMenuBar.add(this.createWindowMenu());
        jMenuBar.add(this.createHelpMenu());
    }

    protected Dimension defaultSize() {
        return new Dimension(this.width, this.height);
    }

    protected JMenu createToolsMenu() {
        this.tf = new TodoFrame((Frame)((Object)this));
        JMenu jMenu = new JMenu("Tools");
        jMenu.setMnemonic(79);
        JMenuItem jMenuItem = new JMenuItem("Control Panel");
        jMenuItem.setMnemonic(67);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NeuralNetDrawing neuralNetDrawing = (NeuralNetDrawing)JoonEdit.this.drawing();
                NeuralNet neuralNet = neuralNetDrawing.getNeuralNet();
                JoonEdit.this.ps = JoonEdit.this.getMonitorPropertySheet(neuralNet);
                JoonEdit.this.ps.setParameters(JoonEdit.this.parameters);
                JoonEdit.this.ps.update();
                JoonEdit.this.ps.setSize(330, 350);
                JoonEdit.this.ps.setVisible(true);
                ((JooneStandardDrawingView)JoonEdit.this.view()).setModified(true);
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("To Do List");
        jMenuItem.setMnemonic(84);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JoonEdit.this.tf.show();
            }
        });
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Add Noise");
        jMenuItem.setMnemonic(65);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NeuralNetDrawing neuralNetDrawing = (NeuralNetDrawing)JoonEdit.this.drawing();
                NeuralNet neuralNet = neuralNetDrawing.getNeuralNet();
                neuralNet.addNoise(0.2);
                ((JooneStandardDrawingView)JoonEdit.this.view()).setModified(true);
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Randomize");
        jMenuItem.setMnemonic(82);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NeuralNetDrawing neuralNetDrawing = (NeuralNetDrawing)JoonEdit.this.drawing();
                NeuralNet neuralNet = neuralNetDrawing.getNeuralNet();
                neuralNet.randomize(0.3);
                ((JooneStandardDrawingView)JoonEdit.this.view()).setModified(true);
            }
        });
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Reset Input Streams");
        jMenuItem.setMnemonic(73);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NeuralNetDrawing neuralNetDrawing = (NeuralNetDrawing)JoonEdit.this.drawing();
                NeuralNet neuralNet = neuralNetDrawing.getNeuralNet();
                neuralNet.resetInput();
                ((JooneStandardDrawingView)JoonEdit.this.view()).setModified(true);
            }
        });
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Macro Editor");
        jMenuItem.setMnemonic(77);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NeuralNetDrawing neuralNetDrawing = (NeuralNetDrawing)JoonEdit.this.drawing();
                NeuralNet neuralNet = neuralNetDrawing.getNeuralNet();
                if (JoonEdit.this.macroEditor == null) {
                    if (neuralNet.getMacroPlugin() == null) {
                        neuralNet.setMacroPlugin(new MacroPlugin());
                    }
                    JoonEdit.this.macroEditor = new JMacroEditor(neuralNet);
                }
                JoonEdit.this.macroEditor.setVisible(true);
                ((JooneStandardDrawingView)JoonEdit.this.view()).setModified(true);
            }
        });
        jMenu.add(jMenuItem);
        return jMenu;
    }

    protected MonitorPropertySheet getMonitorPropertySheet(NeuralNet neuralNet) {
        if (this.ps == null) {
            Wrapper wrapper = new Wrapper(null, neuralNet.getMonitor(), "Control Panel");
            this.ps = new MonitorPropertySheet(wrapper, neuralNet);
        }
        return this.ps;
    }

    protected JMenu createAlignmentMenu() {
        JooneCommandMenu jooneCommandMenu = new JooneCommandMenu("Align");
        jooneCommandMenu.setMnemonic(65);
        jooneCommandMenu.add((Command)new ToggleGridCommand("Toggle Snap to Grid", this.view(), new Point(4, 4)), new MenuShortcut(116));
        jooneCommandMenu.addSeparator();
        jooneCommandMenu.add((Command)new AlignCommand("Left", this.view(), 0), new MenuShortcut(108));
        jooneCommandMenu.add((Command)new AlignCommand("Center", this.view(), 1), new MenuShortcut(99));
        jooneCommandMenu.add((Command)new AlignCommand("Right", this.view(), 2), new MenuShortcut(114));
        jooneCommandMenu.addSeparator();
        jooneCommandMenu.add((Command)new AlignCommand("Top", this.view(), 3), new MenuShortcut(111));
        jooneCommandMenu.add((Command)new AlignCommand("Middle", this.view(), 4), new MenuShortcut(109));
        jooneCommandMenu.add((Command)new AlignCommand("Bottom", this.view(), 5), new MenuShortcut(98));
        return jooneCommandMenu;
    }

    protected JMenu createFileMenu() {
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        JMenuItem jMenuItem = new JMenuItem("New", new MenuShortcut(110).getKey());
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = JoonEdit.this.askForSave("Save changes to Neural Net?");
                if (n == 1 || !((JooneStandardDrawingView)JoonEdit.this.view()).isModified()) {
                    JoonEdit.this.promptNew();
                    return;
                }
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Open...", new MenuShortcut(111).getKey());
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = JoonEdit.this.askForSave("Save changes to Neural Net?");
                if (n == 1 || !((JooneStandardDrawingView)JoonEdit.this.view()).isModified()) {
                    JoonEdit.this.promptOpen();
                }
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Save", new MenuShortcut(115).getKey());
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JoonEdit.this.latestStorageFormat != null && JoonEdit.this.getDrawingTitle() != null && !JoonEdit.this.getDrawingTitle().equals("")) {
                    JoonEdit.this.saveDrawing(JoonEdit.this.latestStorageFormat, JoonEdit.this.getDrawingTitle());
                } else {
                    JoonEdit.this.promptSaveAs();
                }
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Save As...", new MenuShortcut(97).getKey());
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JoonEdit.this.promptSaveAs();
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Export NeuralNet...", new MenuShortcut(101).getKey());
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JoonEdit.this.promptSaveNeuralNet();
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Export as XML...", new MenuShortcut(101).getKey());
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JoonEdit.this.promptSaveAsXML();
            }
        });
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Print...", new MenuShortcut(112).getKey());
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JoonEdit.this.print();
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Page Setup...", new MenuShortcut(117).getKey());
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JoonEdit.this.pageSetup();
            }
        });
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Exit", new MenuShortcut(120).getKey());
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JoonEdit.this.exit();
            }
        });
        jMenu.add(jMenuItem);
        return jMenu;
    }

    protected JMenu createHelpMenu() {
        Object object;
        JMenuItem jMenuItem;
        CommandMenu commandMenu = new CommandMenu("Help");
        commandMenu.setMnemonic(72);
        this.af = new AboutFrame((Frame)((Object)this));
        try {
            jMenuItem = new JMenuItem("Help Contents");
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke("F1"));
            jMenuItem.setMnemonic(72);
            object = new HelpSet(null, HelpSet.findHelpSet(null, (String)"org/joone/edit/help_contents/joone.hs"));
            HelpBroker helpBroker = object.createHelpBroker();
            helpBroker.setSize(new Dimension(800, 600));
            helpBroker.setFont(new Font("Helvetica", 0, 10));
            jMenuItem.addActionListener((ActionListener)new CSH.DisplayHelpFromSource(helpBroker));
            helpBroker.enableHelpKey((Component)this.getRootPane(), "top", null);
            commandMenu.add(jMenuItem);
        }
        catch (Exception exception) {
            log.warn("Exception thrown while creating the MenuHelp. Message is : " + exception.getMessage(), exception);
        }
        jMenuItem = this.createSamplesMenu();
        commandMenu.add(jMenuItem);
        commandMenu.addSeparator();
        object = new JMenuItem("About Joone");
        ((AbstractButton)object).setMnemonic(65);
        ((AbstractButton)object).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Rectangle rectangle = JoonEdit.this.getBounds();
                JoonEdit.this.af.place(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
                JoonEdit.this.af.setVisible(true);
            }
        });
        commandMenu.add((JMenuItem)object);
        return commandMenu;
    }

    private JMenu createSamplesMenu() {
        JMenu jMenu = new JMenu("Examples");
        JMenuItem jMenuItem = new JMenuItem("SOM Image Tester");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new SOMImageTester().setVisible(true);
            }
        });
        jMenu.add(jMenuItem);
        return jMenu;
    }

    public void promptSaveNeuralNet() {
        JFileChooser jFileChooser;
        this.toolDone();
        if (this.getDrawingTitle() == null || this.getDrawingTitle().equals("")) {
            jFileChooser = this.createSaveFileChooser();
        } else {
            jFileChooser = new JFileChooser(this.getDrawingTitle());
            jFileChooser.setDialogTitle("Save File...");
        }
        this.getNetStorageFormatManager().registerFileFilters(jFileChooser);
        if (jFileChooser.showSaveDialog((Component)((Object)this)) == 0) {
            NetStorageFormat netStorageFormat = this.getNetStorageFormatManager().findStorageFormat(jFileChooser.getFileFilter());
            if (netStorageFormat != null) {
                this.saveNeuralNet(netStorageFormat, jFileChooser.getSelectedFile().getAbsolutePath());
                this.latestStorageFormat = null;
            } else {
                this.showStatus("Not a valid file format: " + jFileChooser.getFileFilter().getDescription());
            }
        }
    }

    public void promptSaveAsXML() {
        JFileChooser jFileChooser;
        this.toolDone();
        if (this.getDrawingTitle() == null || this.getDrawingTitle().equals("")) {
            jFileChooser = this.createSaveFileChooser();
        } else {
            jFileChooser = new JFileChooser(this.getDrawingTitle());
            jFileChooser.setDialogTitle("Save File...");
        }
        this.getXMLStorageFormatManager().registerFileFilters(jFileChooser);
        if (jFileChooser.showSaveDialog((Component)((Object)this)) == 0) {
            NetStorageFormat netStorageFormat = this.getXMLStorageFormatManager().findStorageFormat(jFileChooser.getFileFilter());
            if (netStorageFormat != null) {
                this.saveNeuralNet(netStorageFormat, jFileChooser.getSelectedFile().getAbsolutePath());
                this.latestStorageFormat = null;
            } else {
                this.showStatus("Not a valid file format: " + jFileChooser.getFileFilter().getDescription());
            }
        }
    }

    protected void saveNeuralNet(NetStorageFormat netStorageFormat, String string) {
        try {
            NeuralNetDrawing neuralNetDrawing = (NeuralNetDrawing)this.drawing();
            NeuralNet neuralNet = neuralNetDrawing.getNeuralNet();
            neuralNet.getMonitor().setExporting(true);
            netStorageFormat.store(string, neuralNet);
            neuralNet.getMonitor().setExporting(false);
        }
        catch (IOException iOException) {
            this.showStatus(iOException.toString());
        }
    }

    protected JFileChooser createOpenFileChooser(String string) {
        if (this.m_openDialog == null) {
            this.m_openDialog = new JooneFileChooser(string);
        }
        return this.m_openDialog;
    }

    protected JFileChooser createOpenFileChooser() {
        if (this.m_openDialog == null) {
            this.m_openDialog = new JooneFileChooser();
        }
        return this.m_openDialog;
    }

    public StorageFormatManager createStorageFormatManager() {
        StorageFormatManager storageFormatManager = new StorageFormatManager();
        storageFormatManager.setDefaultStorageFormat((StorageFormat)new SerializationStorageFormat());
        storageFormatManager.addStorageFormat(storageFormatManager.getDefaultStorageFormat());
        return storageFormatManager;
    }

    public NetStorageFormatManager createNetStorageFormatManager() {
        NetStorageFormatManager netStorageFormatManager = new NetStorageFormatManager();
        netStorageFormatManager.setDefaultStorageFormat(new StandardNetStorageFormat());
        netStorageFormatManager.addStorageFormat(netStorageFormatManager.getDefaultStorageFormat());
        return netStorageFormatManager;
    }

    public NetStorageFormatManager createXMLStorageFormatManager() {
        NetStorageFormatManager netStorageFormatManager = new NetStorageFormatManager();
        netStorageFormatManager.setDefaultStorageFormat(new XMLNetStorageFormat());
        netStorageFormatManager.addStorageFormat(netStorageFormatManager.getDefaultStorageFormat());
        return netStorageFormatManager;
    }

    private void setNetStorageFormatManager(NetStorageFormatManager netStorageFormatManager) {
        this.fNetStorageFormatManager = netStorageFormatManager;
    }

    public NetStorageFormatManager getNetStorageFormatManager() {
        return this.fNetStorageFormatManager;
    }

    private void setXMLStorageFormatManager(NetStorageFormatManager netStorageFormatManager) {
        this.xNetStorageFormatManager = netStorageFormatManager;
    }

    public NetStorageFormatManager getXMLStorageFormatManager() {
        return this.xNetStorageFormatManager;
    }

    protected Drawing createDrawing() {
        return new NeuralNetDrawing();
    }

    protected StandardDrawingView createDrawingView() {
        Dimension dimension = this.getDrawingViewSize();
        JooneStandardDrawingView jooneStandardDrawingView = new JooneStandardDrawingView((DrawingEditor)this, dimension.width, dimension.height);
        jooneStandardDrawingView.setBackground(Color.lightGray);
        return jooneStandardDrawingView;
    }

    protected void loadDrawing(StorageFormat storageFormat, String string) {
        try {
            Drawing drawing = storageFormat.restore(string);
            if (drawing != null) {
                this.setDrawing(drawing);
                this.setDrawingTitle(string);
            } else {
                this.showStatus("Unknown file type: could not open file '" + string + "'");
            }
        }
        catch (IOException iOException) {
            this.showStatus("Error: " + iOException);
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            JoonEdit joonEdit = new JoonEdit();
            joonEdit.open();
        } else {
            JoonEdit joonEdit = new JoonEdit(stringArray[0]);
            joonEdit.open();
        }
    }

    public void promptNew() {
        super.promptNew();
        if (this.psp != null) {
            this.psp.setVisible(false);
            this.psp = null;
        }
        if (this.ps != null) {
            this.ps.setVisible(false);
            this.ps = null;
        }
        NeuralNetDrawing neuralNetDrawing = (NeuralNetDrawing)this.drawing();
        neuralNetDrawing.setNeuralNet(new NeuralNet());
        LayerFigure.setNumLayers(0);
        if (this.macroEditor != null) {
            this.macroEditor.setVisible(false);
            this.macroEditor = null;
        }
        ((JooneStandardDrawingView)this.view()).setModified(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() {
        URL uRL = JoonEdit.class.getResource("/org/joone/images/splash.gif");
        ImageIcon imageIcon = new ImageIcon(uRL);
        JWindow jWindow = new JWindow();
        JLabel jLabel = new JLabel("Initializing....", 0);
        jLabel.setForeground(Color.black);
        try {
            JLabel jLabel2 = new JLabel(imageIcon){

                public void paint(Graphics graphics) {
                    super.paint(graphics);
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    graphics2D.setFont(new Font("Arial", 1, 10));
                    graphics2D.drawString("Neural Network Editor", 15, 145);
                    graphics2D.drawString("v " + JoonEdit.getVersion(), 45, 158);
                    graphics2D.drawString("(c) " + Calendar.getInstance().get(1) + " Paolo Marrone", 10, 171);
                }
            };
            jWindow.getContentPane().add((Component)jLabel2, "Center");
            jLabel2.setLayout(new BorderLayout());
            jLabel2.add((Component)jLabel, "South");
            jLabel2.setBorder(BorderFactory.createRaisedBevelBorder());
            jLabel.setPreferredSize(new Dimension(jLabel2.getWidth(), 24));
            jWindow.pack();
            JoonEdit.center(jWindow);
            jWindow.setVisible(true);
            jLabel.setText("Starting...");
            super.open();
            this.readParameters();
            Iconkit iconkit = Iconkit.instance();
            if (iconkit == null) {
                throw new HJDError("Iconkit instance isn't set");
            }
            Image image = iconkit.loadImageResource("/org/joone/images/JooneIcon.gif");
            this.setIconImage(image);
            ((JooneStandardDrawingView)this.view()).setModified(false);
        }
        catch (Exception exception) {
            jLabel.setText(exception.getMessage());
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
        finally {
            jWindow.dispose();
        }
    }

    private void readParameters() {
        this.parameters = new EditorParameters();
        Vector vector = this.tParser.getElements();
        for (int i = 0; i < vector.size(); ++i) {
            ToolElement toolElement = (ToolElement)vector.elementAt(i);
            if (toolElement.getType().compareToIgnoreCase("refreshing_rate") == 0) {
                this.parameters.setRefreshingRate(Integer.parseInt((String)toolElement.getParam("value")));
            }
            if (toolElement.getType().compareToIgnoreCase("http_proxy") != 0) continue;
            String string = (String)toolElement.getParam("host");
            String string2 = (String)toolElement.getParam("port");
            String string3 = (String)toolElement.getParam("userid");
            String string4 = (String)toolElement.getParam("passw");
            log.info("Using proxy: http://" + string + ":" + string2);
            System.setProperty("proxySet", "true");
            System.setProperty("http.proxyHost", string);
            System.setProperty("http.proxyPort", string2);
            Authenticator.setDefault(new httpAuthenticateProxy(string3, string4));
        }
    }

    public static String getVersion() {
        return "2.0.0RC1";
    }

    public static int getNumericVersion() {
        return 2000000;
    }

    public static String getRecommendedEngineVersion() {
        return "1.2.5";
    }

    public static int getNumericRecommendedEngineVersion() {
        return 1002005;
    }

    protected JMenu createAttributesMenu() {
        JMenu jMenu = new JMenu("Attributes");
        jMenu.setMnemonic(84);
        JMenu jMenu2 = this.createColorMenu("Fill Color", "FillColor");
        jMenu2.setMnemonic(70);
        jMenu.add(jMenu2);
        jMenu2 = this.createColorMenu("Pen Color", "FrameColor");
        jMenu2.setMnemonic(80);
        jMenu.add(jMenu2);
        jMenu2 = this.createArrowMenu();
        jMenu2.setMnemonic(65);
        jMenu.add(jMenu2);
        jMenu.addSeparator();
        jMenu2 = this.createFontMenu();
        jMenu2.setMnemonic(79);
        jMenu.add(jMenu2);
        jMenu2 = this.createFontSizeMenu();
        jMenu2.setMnemonic(83);
        jMenu.add(jMenu2);
        jMenu2 = this.createFontStyleMenu();
        jMenu2.setMnemonic(78);
        jMenu.add(jMenu2);
        jMenu2 = this.createColorMenu("Text Color", "TextColor");
        jMenu2.setMnemonic(84);
        jMenu.add(jMenu2);
        return jMenu;
    }

    public JMenu createWindowMenu() {
        JMenu jMenu = new JMenu("Window");
        jMenu.setMnemonic(87);
        jMenu.add(this.createLookAndFeel());
        return jMenu;
    }

    public JMenu createLookAndFeel() {
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        JMenu jMenu = new JMenu("Look and Feel");
        jMenu.setMnemonic(76);
        JMenuItem jMenuItem = null;
        for (int i = 0; i < lookAndFeelInfoArray.length; ++i) {
            jMenuItem = new JMenuItem(lookAndFeelInfoArray[i].getName());
            final String string = lookAndFeelInfoArray[i].getClassName();
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JoonEdit.this.newLookAndFeel(string);
                }
            });
            jMenu.add(jMenuItem);
        }
        return jMenu;
    }

    private void newLookAndFeel(String string) {
        try {
            UIManager.setLookAndFeel(string);
            SwingUtilities.updateComponentTreeUI((Component)((Object)this));
        }
        catch (Exception exception) {
            log.warn("Exception thrown while adding a lookAndFeel. Message is : " + exception.getMessage(), exception);
        }
    }

    protected JMenu createEditMenu() {
        JooneCommandMenu jooneCommandMenu = new JooneCommandMenu("Edit");
        jooneCommandMenu.setMnemonic(69);
        jooneCommandMenu.add((Command)new JooneCutCommand("Cut", this.view()), new MenuShortcut(116), KeyStroke.getKeyStroke(88, 2));
        jooneCommandMenu.add((Command)new JooneCopyCommand("Copy", this.view()), new MenuShortcut(99), KeyStroke.getKeyStroke(67, 2));
        jooneCommandMenu.add((Command)new PasteCommand("Paste", this.view()), new MenuShortcut(112), KeyStroke.getKeyStroke(86, 2));
        jooneCommandMenu.addSeparator();
        jooneCommandMenu.add((Command)new JooneDuplicateCommand("Duplicate", this.view()), new MenuShortcut(100));
        jooneCommandMenu.add((Command)new DeleteCommand("Delete", this.view()), new MenuShortcut(101), KeyStroke.getKeyStroke("DELETE"));
        jooneCommandMenu.addSeparator();
        jooneCommandMenu.add((Command)new GroupCommand("Group", this.view()), new MenuShortcut(103));
        jooneCommandMenu.add((Command)new UngroupCommand("Ungroup", this.view()), new MenuShortcut(117));
        jooneCommandMenu.addSeparator();
        jooneCommandMenu.add((Command)new SendToBackCommand("Send to Back", this.view()), new MenuShortcut(115));
        jooneCommandMenu.add((Command)new BringToFrontCommand("Bring to Front", this.view()), new MenuShortcut(98));
        return jooneCommandMenu;
    }

    public void promptSaveAs() {
        JFileChooser jFileChooser;
        this.toolDone();
        if (this.getDrawingTitle() == null || this.getDrawingTitle().equals("")) {
            jFileChooser = this.createSaveFileChooser();
        } else {
            jFileChooser = new JFileChooser(this.getDrawingTitle());
            jFileChooser.setDialogTitle("Save File...");
        }
        this.getStorageFormatManager().registerFileFilters(jFileChooser);
        if (jFileChooser.showSaveDialog((Component)((Object)this)) == 0) {
            StorageFormat storageFormat = this.getStorageFormatManager().findStorageFormat(jFileChooser.getFileFilter());
            if (storageFormat != null) {
                this.saveDrawing(storageFormat, jFileChooser.getSelectedFile().getAbsolutePath());
                this.latestStorageFormat = storageFormat;
            } else {
                this.showStatus("Not a valid file format: " + jFileChooser.getFileFilter().getDescription());
            }
        }
    }

    public void promptOpen() {
        this.toolDone();
        if (this.getDrawingTitle() == null || this.getDrawingTitle().equals("")) {
            this.createOpenFileChooser();
        } else {
            this.createOpenFileChooser(this.getDrawingTitle());
            this.m_openDialog.setDialogTitle("Open File...");
        }
        this.getStorageFormatManager().registerFileFilters((JFileChooser)this.m_openDialog);
        if (this.m_openDialog.showOpenDialog((Component)((Object)this)) == 0) {
            StorageFormat storageFormat = this.getStorageFormatManager().findStorageFormat(this.m_openDialog.getFileFilter());
            if (storageFormat != null) {
                this.promptNew();
                this.loadDrawing(storageFormat, this.m_openDialog.getSelectedFile().getAbsolutePath());
                this.latestStorageFormat = storageFormat;
            } else {
                this.showStatus("Not a valid file format: " + this.m_openDialog.getFileFilter().getDescription());
            }
        }
    }

    protected void initDrawing() {
        super.initDrawing();
        this.latestStorageFormat = null;
    }

    public void exit() {
        int n = this.askForSave("Save changes to Neural Net?");
        if (n == 1 || !((JooneStandardDrawingView)this.view()).isModified()) {
            this.writeIniFile();
            this.destroy();
            this.setVisible(false);
            this.dispose();
            log.info("Exit invoked successfully. Frame disposed. Bye");
            System.exit(0);
        }
    }

    protected void destroy() {
        if (this.m_openDialog != null) {
            this.m_openDialog.saveDirectoryEntries();
        }
    }

    protected void saveDrawing(StorageFormat storageFormat, String string) {
        try {
            this.setDrawingTitle(storageFormat.store(string, this.drawing()));
            ((JooneStandardDrawingView)this.view()).setModified(false);
        }
        catch (IOException iOException) {
            this.showStatus(iOException.toString());
        }
    }

    protected int askForSave(String string) {
        int n = 2;
        if (((JooneStandardDrawingView)this.view()).isModified() && (n = JOptionPane.showConfirmDialog((Component)((Object)this), string, "JoonEdit", 1)) == 0) {
            if (this.latestStorageFormat != null && this.getDrawingTitle() != null && !this.getDrawingTitle().equals("")) {
                this.saveDrawing(this.latestStorageFormat, this.getDrawingTitle());
            } else {
                this.promptSaveAs();
            }
        }
        return n;
    }

    private void readIniFile() {
        try {
            String string;
            File file = new File(System.getProperty("user.home") + File.separator + ".joone");
            if (!file.exists()) {
                file.mkdir();
            }
            this.iniFile = new IniFile(file + File.separator + INI_FILE_NAME);
            int n = Integer.parseInt(this.iniFile.getParameter("gui", "state", "0"));
            int n2 = Integer.parseInt(this.iniFile.getParameter("gui", "x", "0"));
            int n3 = Integer.parseInt(this.iniFile.getParameter("gui", "y", "0"));
            this.width = Integer.parseInt(this.iniFile.getParameter("gui", "width", "800"));
            this.height = Integer.parseInt(this.iniFile.getParameter("gui", "height", "600"));
            this.setLocation(n2, n3);
            if (n != -99) {
                this.setState(n);
            }
            if ((string = this.iniFile.getParameter("gui", "laf", null)) != null) {
                UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
                for (int i = 0; i < lookAndFeelInfoArray.length; ++i) {
                    if (!string.toLowerCase().equals(lookAndFeelInfoArray[i].getClassName().toLowerCase())) continue;
                    UIManager.setLookAndFeel(lookAndFeelInfoArray[i].getClassName());
                    SwingUtilities.updateComponentTreeUI((Component)((Object)this));
                }
            }
        }
        catch (Exception exception) {
            log.warn("Exception thrown reading writing config file. Message is : " + exception.getMessage(), exception);
        }
    }

    private void writeIniFile() {
        try {
            if (this.getState() == 0) {
                this.iniFile.setParameter("gui", "x", String.valueOf(this.getX()));
                this.iniFile.setParameter("gui", "y", String.valueOf(this.getY()));
                this.iniFile.setParameter("gui", "width", String.valueOf(this.getWidth()));
                this.iniFile.setParameter("gui", "height", String.valueOf(this.getHeight()));
            }
            this.iniFile.setParameter("gui", "state", String.valueOf(this.getState()));
            this.iniFile.setParameter("gui", "laf", UIManager.getLookAndFeel().getClass().getName());
        }
        catch (Exception exception) {
            log.warn("Exception thrown while writing config file. Message is : " + exception.getMessage(), exception);
        }
    }

    private void pageSetup() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.pageDialog(printerJob.defaultPage());
    }

    private class httpAuthenticateProxy
    extends Authenticator {
        private String userid;
        private String passw;

        public httpAuthenticateProxy(String string, String string2) {
            this.userid = string;
            this.passw = string2;
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.userid, this.passw.toCharArray());
        }
    }
}

