/*
 * Decompiled with CFR 0.152.
 */
package org.joone.edit;

import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.CompositeFigure;
import CH.ifa.draw.standard.DeleteCommand;
import CH.ifa.draw.standard.NullHandle;
import CH.ifa.draw.standard.RelativeLocator;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.joone.edit.GenericFigure;
import org.joone.edit.PropertySheet;
import org.joone.edit.UpdatableFigure;
import org.joone.edit.Wrapper;
import org.joone.edit.inspection.InspectionFrame;
import org.joone.inspection.Inspectable;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;

public abstract class ConcreteGenericFigure
extends CompositeFigure
implements GenericFigure,
UpdatableFigure {
    public static final ILogger log = LoggerFactory.getLogger(ConcreteGenericFigure.class);
    protected static final int BORDER = 3;
    protected Rectangle fDisplayBox;
    protected Hashtable params;
    protected static int numLayers = 0;
    private static final long serialVersionUID = -6051314440171003005L;

    protected void basicMoveBy(int n, int n2) {
        this.fDisplayBox.translate(n, n2);
        super.basicMoveBy(n, n2);
    }

    public Rectangle displayBox() {
        return new Rectangle(this.fDisplayBox.x, this.fDisplayBox.y, this.fDisplayBox.width, this.fDisplayBox.height);
    }

    public void basicDisplayBox(Point point, Point point2) {
        this.fDisplayBox = new Rectangle(point);
        this.fDisplayBox.add(point2);
        this.layout();
    }

    private void drawBorder(Graphics graphics) {
        super.draw(graphics);
        Rectangle rectangle = this.displayBox();
        Figure figure = this.figureAt(0);
        Rectangle rectangle2 = figure.displayBox();
        graphics.setColor(Color.gray);
        graphics.drawLine(rectangle.x, rectangle.y + rectangle2.height + 2, rectangle.x + rectangle.width, rectangle.y + rectangle2.height + 2);
        graphics.setColor(Color.white);
        graphics.drawLine(rectangle.x, rectangle.y + rectangle2.height + 3, rectangle.x + rectangle.width, rectangle.y + rectangle2.height + 3);
        graphics.setColor(Color.white);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y);
        graphics.setColor(Color.gray);
        graphics.drawLine(rectangle.x + rectangle.width, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        graphics.drawLine(rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
    }

    public void draw(Graphics graphics) {
        this.drawBorder(graphics);
        super.draw(graphics);
    }

    public Vector handles() {
        Vector<NullHandle> vector = new Vector<NullHandle>();
        vector.addElement(new NullHandle((Figure)this, RelativeLocator.northWest()));
        vector.addElement(new NullHandle((Figure)this, RelativeLocator.northEast()));
        vector.addElement(new NullHandle((Figure)this, RelativeLocator.southWest()));
        vector.addElement(new NullHandle((Figure)this, RelativeLocator.southEast()));
        return this.addHandles(vector);
    }

    protected abstract Vector addHandles(Vector var1);

    public void initialize() {
        this.fDisplayBox = new Rectangle(0, 0, 0, 0);
        Font font = new Font("Helvetica", 1, 12);
        TextFigure textFigure = new TextFigure();
        textFigure.setFont(font);
        textFigure.setText((String)this.getParam("type"));
        textFigure.setAttribute("TextColor", (Object)Color.white);
        textFigure.setReadOnly(true);
        this.add((Figure)textFigure);
        this.initContent();
    }

    protected abstract void initContent();

    private void layout() {
        Point point = new Point(this.fDisplayBox.x, this.fDisplayBox.y);
        point.translate(3, 3);
        Dimension dimension = new Dimension(0, 0);
        FigureEnumeration figureEnumeration = this.figures();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            Dimension dimension2 = figure.size();
            Point point2 = new Point(point.x + dimension2.width, point.y + dimension2.height);
            figure.basicDisplayBox(point, point2);
            dimension.width = Math.max(dimension.width, dimension2.width);
            dimension.height += dimension2.height;
            point.y += dimension2.height;
        }
        this.fDisplayBox.width = dimension.width + 6;
        this.fDisplayBox.height = dimension.height + 6;
    }

    private boolean needsLayout() {
        Dimension dimension = new Dimension(0, 0);
        FigureEnumeration figureEnumeration = this.figures();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            dimension.width = Math.max(dimension.width, figure.size().width);
        }
        int n = dimension.width + 6;
        return n != this.fDisplayBox.width;
    }

    public void update(FigureChangeEvent figureChangeEvent) {
        if (this.needsLayout()) {
            this.layout();
            this.changed();
        }
    }

    public void update() {
        FigureEnumeration figureEnumeration = this.figures();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            if (!(figure instanceof UpdatableFigure)) continue;
            UpdatableFigure updatableFigure = (UpdatableFigure)figure;
            updatableFigure.update();
        }
        this.layout();
        this.changed();
    }

    public void figureChanged(FigureChangeEvent figureChangeEvent) {
        this.update(figureChangeEvent);
    }

    public void figureRemoved(FigureChangeEvent figureChangeEvent) {
        this.update(figureChangeEvent);
    }

    public void notifyPostConn() {
    }

    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
        storableOutput.writeInt(this.fDisplayBox.x);
        storableOutput.writeInt(this.fDisplayBox.y);
        storableOutput.writeInt(this.fDisplayBox.width);
        storableOutput.writeInt(this.fDisplayBox.height);
    }

    public void read(StorableInput storableInput) throws IOException {
        super.read(storableInput);
        this.fDisplayBox = new Rectangle(storableInput.readInt(), storableInput.readInt(), storableInput.readInt(), storableInput.readInt());
        this.layout();
    }

    public Insets connectionInsets() {
        Rectangle rectangle = this.fDisplayBox;
        int n = rectangle.width / 2;
        int n2 = rectangle.height / 2;
        return new Insets(n2, n, n2, n);
    }

    protected Object createLayer() {
        try {
            Class<?> clazz = Class.forName((String)this.getParam("class"));
            Object obj = clazz.newInstance();
            return obj;
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string = "ClassNotFoundException  was thrown. Message is : " + classNotFoundException.getMessage();
            log.warn(string, classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            String string = "InstantiationException was thrown. Message is : " + instantiationException.getMessage();
            log.warn(string, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            String string = "IllegalAccessException was thrown. Message is : " + illegalAccessException.getMessage();
            log.warn(string, illegalAccessException);
        }
        return null;
    }

    public Object getParam(Object object) {
        return this.params.get(object);
    }

    public void setParam(Object object, Object object2) {
        this.params.put(object, object2);
    }

    public void setParams(Hashtable hashtable) {
        this.params = hashtable;
    }

    public abstract Wrapper getWrapper();

    public boolean canConnect(GenericFigure genericFigure, ConnectionFigure connectionFigure) {
        return false;
    }

    public abstract Object getLayer();

    public JPopupMenu getPopupMenu(final PropertySheet propertySheet, final DrawingView drawingView) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Properties");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (propertySheet != null) {
                    Wrapper wrapper = ConcreteGenericFigure.this.getWrapper();
                    propertySheet.setTarget(wrapper);
                    propertySheet.pack();
                    if (propertySheet.getSize().width < 250) {
                        propertySheet.setSize(new Dimension(250, propertySheet.getSize().height));
                    }
                    propertySheet.show();
                }
            }
        });
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Delete");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new DeleteCommand("Delete", drawingView).execute();
            }
        });
        jPopupMenu.add(jMenuItem);
        if (this.getWrapper().getBean() instanceof Inspectable) {
            jMenuItem = new JMenuItem("Inspect");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Inspectable inspectable = (Inspectable)ConcreteGenericFigure.this.getWrapper().getBean();
                    InspectionFrame inspectionFrame = new InspectionFrame(inspectable);
                    inspectionFrame.show();
                }
            });
            jPopupMenu.add(jMenuItem);
        }
        return jPopupMenu;
    }
}

