/*
 * Decompiled with CFR 0.152.
 */
package org.joone.edit;

import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.joone.edit.AbstractChartSynapse;
import org.joone.edit.ChartingHandle;
import org.joone.edit.DrawingRegion;
import org.joone.edit.SharedBuffer;
import org.joone.engine.NetErrorManager;
import org.joone.engine.Pattern;

public class ChartOutputSynapse
extends AbstractChartSynapse {
    private static final long serialVersionUID = 7501332794591309201L;
    private transient DrawingRegion myDrawingRegion;
    private transient SharedBuffer grafBuffer;

    private void initDrawingRegion(int n) {
        this.iFrame.getContentPane().removeAll();
        this.myDrawingRegion = new DrawingRegion(new Dimension(550, 350), this.getMaxYaxis(), n);
        this.iFrame.getContentPane().add((Component)this.myDrawingRegion, "Center");
        this.iFrame.setSize(560, 360);
        this.iFrame.pack();
    }

    public void setMaxYaxis(double d) {
        super.setMaxYaxis(d);
        if (this.myDrawingRegion != null) {
            this.myDrawingRegion.setMaxYvalue(d);
        }
    }

    public void setMaxXaxis(int n) {
        super.setMaxXaxis(n);
        if (this.myDrawingRegion != null) {
            this.myDrawingRegion.setMaxXvalue(n);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.getTitle() == null) {
            this.setTitle("Chart");
            this.setName("Chart");
            this.setMaxXaxis(10000);
            this.setMaxYaxis(1.0);
            this.setResizable(true);
            this.setSerie(1);
            super.initComponents();
        }
        this.myDrawingRegion = null;
    }

    public void fwdPut(Pattern pattern, ChartingHandle chartingHandle) {
        if (this.isEnabled()) {
            SharedBuffer sharedBuffer = this.getDrawingRegion().getBuffer(chartingHandle);
            this.fwdPut(pattern, chartingHandle.getSerie(), sharedBuffer);
        }
    }

    public void fwdPut(Pattern pattern) {
        if (this.isEnabled()) {
            if (this.getSerie() > pattern.getArray().length) {
                new NetErrorManager(this.getMonitor(), "ChartOutputSynapse: '" + this.getName() + "' - Serie greater than the pattern's length");
                return;
            }
            this.grafBuffer = this.getDrawingRegion().getBuffer();
            this.fwdPut(pattern, this.getSerie(), this.grafBuffer);
        }
    }

    private void fwdPut(Pattern pattern, int n, SharedBuffer sharedBuffer) {
        if (pattern.getCount() > -1) {
            double[] dArray = pattern.getArray();
            double d = pattern.getCount();
            sharedBuffer.put(dArray[n - 1], d);
        }
    }

    private DrawingRegion getDrawingRegion() {
        if (this.myDrawingRegion == null) {
            this.initDrawingRegion(this.maxXaxis);
        }
        return this.myDrawingRegion;
    }

    public void removeHandle(ChartingHandle chartingHandle) {
        if (this.myDrawingRegion != null) {
            this.myDrawingRegion.removeHandle(chartingHandle);
        }
    }
}

