/*
 * Decompiled with CFR 0.152.
 */
package de.vxart.zipupdate;

import de.vxart.zipupdate.MultiProgressListener;
import de.vxart.zipupdate.ProgressListener;
import de.vxart.zipupdate.ProgressListenerManager;
import de.vxart.zipupdate.Resource;
import de.vxart.zipupdate.UpdateLocation;
import de.vxart.zipupdate.ui.MultiProgressDialog;
import de.vxart.zipupdate.ui.ProgressDialog;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateEngine {
    protected static Logger logger = Logger.getLogger("de.vxart.zipupdate");
    private ProgressListenerManager multiListeners;
    private ProgressListenerManager listeners = new ProgressListenerManager();
    private static long startTime;

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            System.err.println("Usage: java de.vxart.zipupdate.UpdateEngine <ZIP file> <update URL>");
            System.err.println("   or: java de.vxart.zipupdate.UpdateEngine <directory> <update base URL>");
            System.exit(1);
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Failed to enable native LAF: " + exception.getMessage());
        }
        File file = new File(stringArray[0]);
        URL uRL = null;
        try {
            uRL = new URL(stringArray[1]);
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Invalid URL: " + stringArray[1]);
            System.exit(2);
        }
        UpdateEngine updateEngine = new UpdateEngine();
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return (string = string.toLowerCase()).endsWith(".zip") || string.endsWith(".jar");
                }
            });
            if (fileArray.length < 1) {
                logger.log(Level.WARNING, "No ZIP/JAR files found at " + file.getAbsolutePath());
                System.exit(3);
            }
            MultiProgressDialog multiProgressDialog = new MultiProgressDialog();
            multiProgressDialog.init("Monkeys!");
            updateEngine.addProgressListener(multiProgressDialog);
            ZipFile[] zipFileArray = new ZipFile[fileArray.length];
            UpdateLocation[] updateLocationArray = new UpdateLocation[fileArray.length];
            String[] stringArray2 = new String[fileArray.length];
            for (int i = 0; i < fileArray.length; ++i) {
                try {
                    zipFileArray[i] = new ZipFile(fileArray[i]);
                    updateLocationArray[i] = new UpdateLocation(new URL(uRL, fileArray[i].getName()));
                    stringArray2[i] = fileArray[i].getName();
                    continue;
                }
                catch (Exception exception) {
                    logger.log(Level.SEVERE, "Failed to initialize arguments for: " + fileArray[i].getAbsolutePath());
                    System.exit(4);
                }
            }
            updateEngine.update(zipFileArray, updateLocationArray, stringArray2);
        } else {
            Closeable closeable;
            if (!file.exists()) {
                logger.log(Level.WARNING, "Update target doesn't exist, creating dummy: " + file.getAbsolutePath());
                closeable = new ZipOutputStream(new FileOutputStream(file));
                ((ZipOutputStream)closeable).putNextEntry(new ZipEntry("banana"));
                ((DeflaterOutputStream)closeable).write(202);
                ((DeflaterOutputStream)closeable).write(254);
                ((ZipOutputStream)closeable).closeEntry();
                ((ZipOutputStream)closeable).close();
            }
            closeable = new ZipFile(file);
            updateEngine.addProgressListener(new ProgressDialog());
            updateEngine.update((ZipFile)closeable, new UpdateLocation(uRL));
        }
    }

    public UpdateEngine() {
        this.multiListeners = new ProgressListenerManager();
    }

    public int update(ZipFile[] zipFileArray, UpdateLocation[] updateLocationArray, String[] stringArray) throws IOException {
        if (zipFileArray.length != updateLocationArray.length || updateLocationArray.length != stringArray.length || updateLocationArray.length != zipFileArray.length) {
            throw new IllegalArgumentException("Argument arrays are unequal in length: archives=" + zipFileArray.length + ", locations=" + updateLocationArray.length + ", messages=" + stringArray.length);
        }
        this.multiListeners.init("Updating " + zipFileArray.length + " archives...", 0, zipFileArray.length);
        int n = 0;
        for (int i = 0; i < zipFileArray.length; ++i) {
            this.multiListeners.label(stringArray[i]);
            if (this.update(zipFileArray[i], updateLocationArray[i])) {
                ++n;
            }
            this.multiListeners.update(i + 1);
        }
        this.multiListeners.finish();
        return n;
    }

    public boolean update(ZipFile zipFile, UpdateLocation updateLocation) throws IOException {
        logger.log(Level.INFO, "Updating " + zipFile.getName() + " from " + updateLocation.getUrl());
        Iterator<ProgressListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            updateLocation.addProgressListener(iterator.next());
        }
        this.listeners.init("Initializing...");
        logger.log(Level.FINE, "Initializing patch set...");
        UpdateEngine.startTimer();
        Set<Resource> set = this.init(zipFile);
        logger.log(Level.FINE, "Initialized patch set (" + UpdateEngine.stopTimer() + " ms)");
        logger.log(Level.FINE, "Fetching server-side CRC list...");
        UpdateEngine.startTimer();
        Set<Resource> set2 = updateLocation.getResources();
        logger.log(Level.FINE, "Fetched server-side CRC list (" + UpdateEngine.stopTimer() + " ms)");
        logger.log(Level.FINE, "Diffing " + (set2.size() + set.size()) + " items...");
        UpdateEngine.startTimer();
        Map<Resource, String> map = this.diff(set, set2);
        logger.log(Level.FINE, "Diffing finished (" + UpdateEngine.stopTimer() + " ms)");
        logger.log(Level.FINE, "Total items on server: " + set2.size());
        logger.log(Level.FINE, "Total items on client: " + zipFile.size());
        UpdateEngine.printDiff(map);
        logger.log(Level.FINE, "Patching " + zipFile.getName() + "...");
        UpdateEngine.startTimer();
        boolean bl = this.patch(zipFile, map, updateLocation);
        if (!bl) {
            logger.log(Level.INFO, "No update necessary for " + zipFile.getName() + " (" + UpdateEngine.stopTimer() + " ms)");
        } else {
            logger.log(Level.INFO, "Updated " + zipFile.getName() + " (" + UpdateEngine.stopTimer() + " ms)");
        }
        this.listeners.finish();
        return bl;
    }

    private static void printDiff(Map<Resource, String> map) {
        if (logger.isLoggable(Level.FINE)) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            logger.log(Level.FINE, "Final patch set size: " + map.size());
            logger.log(Level.FINE, "This is what I would do:");
            if (map.size() < 1) {
                logger.log(Level.FINE, "\tKeep all. No patching necessary.");
                return;
            }
            for (Resource resource : map.keySet()) {
                String string = map.get(resource);
                if (string == "===") {
                    ++n2;
                    continue;
                }
                if (string == "+++") {
                    ++n4;
                } else if (string == "!!!") {
                    ++n3;
                } else if (string == "---") {
                    ++n;
                } else assert (false) : "Undefined flag: " + string;
                logger.log(Level.FINER, "\t" + string + " " + resource.getName());
            }
            logger.log(Level.FINE, "add: " + n4 + " " + "update: " + n3 + " " + "remove: " + n + " " + "keep: " + n2);
        }
    }

    private Set<Resource> init(ZipFile zipFile) {
        assert (zipFile != null);
        LinkedHashSet<Resource> linkedHashSet = new LinkedHashSet<Resource>();
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            Resource resource = new Resource(zipEntry.getName());
            resource.setCrc(zipEntry.getCrc());
            try {
                resource.setData(zipFile.getInputStream(zipEntry));
            }
            catch (Exception exception) {
                throw new RuntimeException("Unable to open stream to " + zipEntry.getName());
            }
            linkedHashSet.add(resource);
        }
        return linkedHashSet;
    }

    private Map<Resource, String> diff(Set<Resource> set, Set<Resource> set2) {
        HashMap<Resource, String> hashMap = new HashMap<Resource, String>(set.size());
        for (Resource resource : set) {
            hashMap.put(resource, "---");
        }
        for (Resource resource : set2) {
            long l;
            String string = resource.getName();
            Resource resource2 = null;
            for (Resource resource3 : set) {
                if (!resource3.getName().equals(string)) continue;
                resource2 = resource3;
                break;
            }
            if (resource2 == null) {
                hashMap.put(resource, "+++");
                continue;
            }
            long l2 = resource.getCrc();
            if (l2 == (l = resource2.getCrc())) {
                hashMap.remove(resource2);
                continue;
            }
            hashMap.put(resource2, "!!!");
        }
        return hashMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean patch(ZipFile zipFile, Map<Resource, String> map, UpdateLocation updateLocation) throws IOException {
        Object object;
        Object object2;
        if (map.size() < 1) {
            return false;
        }
        boolean bl = false;
        Object object3 = map.keySet().iterator();
        while (object3.hasNext()) {
            object2 = object3.next();
            object = ((Resource)object2).getName();
            if (!((String)object).equals("META-INF/MANIFEST.MF")) continue;
            String string = map.get(object2);
            bl = string.equals("+++") || string.equals("+++");
            break;
        }
        if (!((File)(object3 = new File(zipFile.getName() + ".tmp"))).delete() && ((File)object3).exists()) {
            throw new IOException("Failed to delete existing tmp file: " + object3);
        }
        object2 = new ZipOutputStream(new FileOutputStream((File)object3));
        updateLocation.fetchData(map);
        object = updateLocation.getData(map);
        int n = zipFile.size() + map.size();
        this.listeners.init("Patching...", 0, n);
        logger.log(Level.FINE, "Starting to patch...");
        if (bl) {
            logger.log(Level.FINER, "Patching first from REMOTE source.");
            this.patchRemotely((ZipOutputStream)object2, map, (Iterator<Resource>)object);
            this.patchLocally((ZipOutputStream)object2, map, zipFile);
        } else {
            logger.log(Level.FINER, "Patching first from LOCAL source.");
            this.patchLocally((ZipOutputStream)object2, map, zipFile);
            this.patchRemotely((ZipOutputStream)object2, map, (Iterator<Resource>)object);
        }
        logger.log(Level.FINE, "Finalizing patched file...");
        this.listeners.init("Finalizing...");
        ((ZipOutputStream)object2).close();
        zipFile.close();
        logger.log(Level.FINE, "Finalized patched file.");
        File file = new File(zipFile.getName());
        File file2 = new File(zipFile.getName() + ".bck");
        logger.log(Level.FINE, "Replacing original by patched file...");
        if (!file.renameTo(file2)) throw new IOException("Failed to backup original file: " + file);
        if (!((File)object3).renameTo(file)) throw new IOException("Failed to move patched file into place: " + object3);
        if (file2.delete()) return true;
        logger.log(Level.WARNING, "Failed to delete backup: " + file2);
        return true;
    }

    private void patchLocally(ZipOutputStream zipOutputStream, Map<Resource, String> map, ZipFile zipFile) throws IOException {
        logger.log(Level.FINER, "Patching with local resources...");
        byte[] byArray = new byte[4096];
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            int n;
            ZipEntry zipEntry = enumeration.nextElement();
            String string = zipEntry.getName();
            this.listeners.update(this.listeners.getProgress() + 1);
            String string2 = "===";
            for (Resource resource : map.keySet()) {
                if (!string.equals(resource.getName())) continue;
                string2 = map.get(resource);
                break;
            }
            if ("---".equals(string2)) {
                logger.log(Level.FINEST, "\t--- " + string);
                continue;
            }
            if (!"===".equals(string2)) continue;
            logger.log(Level.FINEST, "\t=== " + string);
            zipOutputStream.putNextEntry(new ZipEntry(string));
            BufferedInputStream bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                zipOutputStream.write(byArray, 0, n);
            }
            zipOutputStream.closeEntry();
            bufferedInputStream.close();
        }
    }

    private void patchRemotely(ZipOutputStream zipOutputStream, Map<Resource, String> map, Iterator<Resource> iterator) throws IOException {
        if (iterator == null) {
            logger.log(Level.FINE, "No patching with remote resources required.");
            return;
        }
        logger.log(Level.FINER, "Patching with remote resources...");
        byte[] byArray = new byte[4096];
        while (iterator.hasNext()) {
            int n;
            Resource resource = iterator.next();
            String string = resource.getName();
            logger.log(Level.FINEST, "\t+++/!!! " + string);
            this.listeners.update(this.listeners.getProgress() + 1);
            ZipEntry zipEntry = new ZipEntry(string);
            zipOutputStream.putNextEntry(zipEntry);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(resource.getData());
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                zipOutputStream.write(byArray, 0, n);
            }
            zipOutputStream.closeEntry();
            bufferedInputStream.close();
        }
    }

    private static void startTimer() {
        startTime = System.currentTimeMillis();
    }

    private static long stopTimer() {
        assert (startTime != 0L) : "Called stopTimer() before startTimer()";
        long l = System.currentTimeMillis() - startTime;
        startTime = 0L;
        return l;
    }

    public void addProgressListener(ProgressListener progressListener) {
        if (progressListener instanceof MultiProgressListener) {
            this.multiListeners.add(((MultiProgressListener)progressListener).getOverallProgressListener());
        }
        this.listeners.add(progressListener);
    }

    public void removeProgressListener(ProgressListener progressListener) {
        if (progressListener instanceof MultiProgressListener) {
            this.multiListeners.remove(((MultiProgressListener)progressListener).getOverallProgressListener());
        }
        this.listeners.remove(progressListener);
    }

    static {
        try {
            logger.setLevel(Level.INFO);
            logger.setUseParentHandlers(false);
            logger.addHandler(new ConsoleHandler());
            logger.addHandler(new FileHandler("%t/jzipupdate.log"));
            for (Handler handler : logger.getHandlers()) {
                handler.setLevel(logger.getLevel());
            }
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Failed to register log file", exception);
        }
    }
}

