/*
 * Decompiled with CFR 0.152.
 */
package de.vxart.zipupdate;

import de.vxart.zip.CentralDirectoryRecord;
import de.vxart.zip.EndOfCentralDirectory;
import de.vxart.zipupdate.Resource;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Indexer {
    private static Logger logger = Logger.getLogger(Indexer.class.getName());

    public static void main(String[] stringArray) throws Exception {
        File file;
        if (stringArray.length < 1) {
            System.err.println("Usage: java de.vxart.zipupdate.Indexer <ZIP file | directory>");
            System.exit(1);
        }
        if ((file = new File(stringArray[0])).isFile()) {
            Indexer.index(file);
        } else if (file.isDirectory()) {
            File[] fileArray = file.listFiles(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return (string = string.toLowerCase()).endsWith(".zip") || string.endsWith(".jar");
                }
            });
            if (fileArray.length < 1) {
                logger.log(Level.WARNING, "No ZIP/JAR files found in " + file.getCanonicalPath());
                System.exit(2);
            }
            logger.log(Level.INFO, "Generating index for all files in " + file);
            for (File file2 : fileArray) {
                Indexer.index(file2);
            }
        }
    }

    private Indexer() {
    }

    public static void index(File file) throws IOException {
        logger.log(Level.INFO, "Generating index for " + file.getAbsolutePath());
        Map<Resource, Long> map = Indexer.parseZipFile(file);
        CRC32 cRC32 = new CRC32();
        Deflater deflater = new Deflater(9, false);
        File file2 = new File(file.getParentFile(), file.getName() + ".idx");
        DataOutputStream dataOutputStream = new DataOutputStream(new CheckedOutputStream(new BufferedOutputStream(new DeflaterOutputStream((OutputStream)new FileOutputStream(file2), deflater)), cRC32));
        for (Resource resource : map.keySet()) {
            String string = resource.getName();
            long l = resource.getCrc();
            long l2 = map.get(resource);
            dataOutputStream.writeUTF(string);
            dataOutputStream.writeLong(l);
            dataOutputStream.writeLong(l2);
        }
        dataOutputStream.writeUTF("");
        dataOutputStream.flush();
        long l = cRC32.getValue();
        dataOutputStream.writeLong(l);
        logger.log(Level.FINE, "Checksum for index data: 0x" + Long.toHexString(l).toUpperCase());
        dataOutputStream.close();
    }

    public static Map<Resource, Long> parseZipFile(File file) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        byte[] byArray = new byte[]{80, 75, 5, 6};
        byte[] byArray2 = new byte[44];
        int n = -1;
        int n2 = 1;
        while (n == -1) {
            randomAccessFile.seek(randomAccessFile.length() - 22L - (long)(n2 * 22));
            randomAccessFile.readFully(byArray2);
            n = Indexer.find(byArray2, byArray);
            ++n2;
        }
        byte[] byArray3 = new byte[22];
        System.arraycopy(byArray2, n, byArray3, 0, byArray3.length);
        EndOfCentralDirectory endOfCentralDirectory = new EndOfCentralDirectory(byArray3);
        randomAccessFile.seek(endOfCentralDirectory.centralDirectoryOffset);
        LinkedHashMap<Resource, Long> linkedHashMap = new LinkedHashMap<Resource, Long>();
        Resource resource = null;
        byte[] byArray4 = new byte[46];
        for (int i = 0; i < endOfCentralDirectory.centralDirectoryRecordsAllDisks; ++i) {
            randomAccessFile.readFully(byArray4);
            CentralDirectoryRecord centralDirectoryRecord = new CentralDirectoryRecord(byArray4);
            byte[] byArray5 = new byte[centralDirectoryRecord.nameLength];
            randomAccessFile.readFully(byArray5);
            String string = new String(byArray5, "us-ascii");
            randomAccessFile.skipBytes(centralDirectoryRecord.extraLength);
            randomAccessFile.skipBytes(centralDirectoryRecord.fileCommentLength);
            if (resource != null) {
                linkedHashMap.put(resource, (long)centralDirectoryRecord.offsetToLocalFileHeader - 1L);
            }
            resource = new Resource(string);
            resource.setCrc(centralDirectoryRecord.crc);
        }
        if (resource != null) {
            linkedHashMap.put(resource, (long)endOfCentralDirectory.centralDirectoryOffset - 1L);
        }
        return linkedHashMap;
    }

    private static int find(byte[] byArray, byte[] byArray2) {
        block0: for (int i = 0; i < byArray.length - byArray2.length; ++i) {
            int n;
            for (n = 0; n < byArray2.length; ++n) {
                if (byArray[i + n] != byArray2[n]) continue block0;
            }
            return i + n - byArray2.length;
        }
        return -1;
    }
}

