/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.vorbis;

import de.jarnbjo.util.io.BitInputStream;
import de.jarnbjo.vorbis.CodeBook;
import de.jarnbjo.vorbis.Mode;
import de.jarnbjo.vorbis.Residue;
import de.jarnbjo.vorbis.SetupHeader;
import de.jarnbjo.vorbis.VorbisFormatException;
import de.jarnbjo.vorbis.VorbisStream;
import java.io.IOException;

class Residue2
extends Residue {
    private double[][] decodedVectors;

    private Residue2() {
    }

    protected Residue2(BitInputStream bitInputStream, SetupHeader setupHeader) throws VorbisFormatException, IOException {
        super(bitInputStream, setupHeader);
    }

    protected int getType() {
        return 2;
    }

    protected void decodeResidue(VorbisStream vorbisStream, BitInputStream bitInputStream, Mode mode, int n, boolean[] blArray, float[][] fArray) throws VorbisFormatException, IOException {
        Residue.Look look = this.getLook(vorbisStream, mode);
        CodeBook codeBook = vorbisStream.getSetupHeader().getCodeBooks()[this.getClassBook()];
        int n2 = codeBook.getDimensions();
        int n3 = this.getEnd() - this.getBegin();
        int n4 = n3 / this.getPartitionSize();
        int n5 = this.getPartitionSize();
        int n6 = look.getPhraseBook().getDimensions();
        int n7 = (n4 + n6 - 1) / n6;
        int n8 = 0;
        for (int i = 0; i < blArray.length; ++i) {
            if (blArray[i]) continue;
            ++n8;
        }
        float[][] fArrayArray = new float[n8][];
        n8 = 0;
        for (int i = 0; i < blArray.length; ++i) {
            if (blArray[i]) continue;
            fArrayArray[n8++] = fArray[i];
        }
        int[][] nArrayArray = new int[n7][];
        for (int i = 0; i < look.getStages(); ++i) {
            int n9 = 0;
            int n10 = 0;
            while (n9 < n4) {
                int n11;
                if (i == 0) {
                    n11 = bitInputStream.getInt(look.getPhraseBook().getHuffmanRoot());
                    if (n11 == -1) {
                        throw new VorbisFormatException("");
                    }
                    nArrayArray[n10] = look.getDecodeMap()[n11];
                    if (nArrayArray[n10] == null) {
                        throw new VorbisFormatException("");
                    }
                }
                for (n11 = 0; n11 < n6 && n9 < n4; ++n11, ++n9) {
                    CodeBook codeBook2;
                    int n12 = this.begin + n9 * n5;
                    if ((this.cascade[nArrayArray[n10][n11]] & 1 << i) == 0 || (codeBook2 = vorbisStream.getSetupHeader().getCodeBooks()[look.getPartBooks()[nArrayArray[n10][n11]][i]]) == null) continue;
                    codeBook2.readVvAdd(fArrayArray, bitInputStream, n12, n5);
                }
                ++n10;
            }
        }
    }

    public Object clone() {
        Residue2 residue2 = new Residue2();
        this.fill(residue2);
        return residue2;
    }

    protected double[][] getDecodedVectors() {
        return this.decodedVectors;
    }
}

