/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.vorbis;

import de.jarnbjo.util.io.BitInputStream;
import de.jarnbjo.vorbis.Floor;
import de.jarnbjo.vorbis.SetupHeader;
import de.jarnbjo.vorbis.Util;
import de.jarnbjo.vorbis.VorbisFormatException;
import de.jarnbjo.vorbis.VorbisStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

class Floor1
extends Floor
implements Cloneable {
    private int[] partitionClassList;
    private int maximumClass;
    private int multiplier;
    private int rangeBits;
    private int[] classDimensions;
    private int[] classSubclasses;
    private int[] classMasterbooks;
    private int[][] subclassBooks;
    private int[] xList;
    private int[] yList;
    private int[] lowNeighbours;
    private int[] highNeighbours;
    private static final int[] RANGES = new int[]{256, 128, 86, 64};

    private Floor1() {
    }

    protected Floor1(BitInputStream bitInputStream, SetupHeader setupHeader) throws VorbisFormatException, IOException {
        int n;
        int n2;
        int n3;
        this.maximumClass = -1;
        int n4 = bitInputStream.getInt(5);
        this.partitionClassList = new int[n4];
        for (n3 = 0; n3 < this.partitionClassList.length; ++n3) {
            this.partitionClassList[n3] = bitInputStream.getInt(4);
            if (this.partitionClassList[n3] <= this.maximumClass) continue;
            this.maximumClass = this.partitionClassList[n3];
        }
        this.classDimensions = new int[this.maximumClass + 1];
        this.classSubclasses = new int[this.maximumClass + 1];
        this.classMasterbooks = new int[this.maximumClass + 1];
        this.subclassBooks = new int[this.maximumClass + 1][];
        n3 = 2;
        for (n2 = 0; n2 <= this.maximumClass; ++n2) {
            this.classDimensions[n2] = bitInputStream.getInt(3) + 1;
            n3 += this.classDimensions[n2];
            this.classSubclasses[n2] = bitInputStream.getInt(2);
            if (this.classDimensions[n2] > setupHeader.getCodeBooks().length || this.classSubclasses[n2] > setupHeader.getCodeBooks().length) {
                throw new VorbisFormatException("There is a class dimension or class subclasses entry higher than the number of codebooks in the setup header.");
            }
            if (this.classSubclasses[n2] != 0) {
                this.classMasterbooks[n2] = bitInputStream.getInt(8);
            }
            this.subclassBooks[n2] = new int[1 << this.classSubclasses[n2]];
            for (int i = 0; i < this.subclassBooks[n2].length; ++i) {
                this.subclassBooks[n2][i] = bitInputStream.getInt(8) - 1;
            }
        }
        this.multiplier = bitInputStream.getInt(2) + 1;
        this.rangeBits = bitInputStream.getInt(4);
        n2 = 0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(new Integer(0));
        arrayList.add(new Integer(1 << this.rangeBits));
        for (int i = 0; i < n4; ++i) {
            for (n = 0; n < this.classDimensions[this.partitionClassList[i]]; ++n) {
                arrayList.add(new Integer(bitInputStream.getInt(this.rangeBits)));
            }
        }
        this.xList = new int[arrayList.size()];
        this.lowNeighbours = new int[this.xList.length];
        this.highNeighbours = new int[this.xList.length];
        Iterator iterator = arrayList.iterator();
        for (n = 0; n < this.xList.length; ++n) {
            this.xList[n] = (Integer)iterator.next();
        }
        for (n = 0; n < this.xList.length; ++n) {
            this.lowNeighbours[n] = Util.lowNeighbour(this.xList, n);
            this.highNeighbours[n] = Util.highNeighbour(this.xList, n);
        }
    }

    protected int getType() {
        return 1;
    }

    protected Floor decodeFloor(VorbisStream vorbisStream, BitInputStream bitInputStream) throws VorbisFormatException, IOException {
        if (!bitInputStream.getBit()) {
            return null;
        }
        Floor1 floor1 = (Floor1)this.clone();
        floor1.yList = new int[this.xList.length];
        int n = RANGES[this.multiplier - 1];
        floor1.yList[0] = bitInputStream.getInt(Util.ilog(n - 1));
        floor1.yList[1] = bitInputStream.getInt(Util.ilog(n - 1));
        int n2 = 2;
        for (int i = 0; i < this.partitionClassList.length; ++i) {
            int n3 = this.partitionClassList[i];
            int n4 = this.classDimensions[n3];
            int n5 = this.classSubclasses[n3];
            int n6 = (1 << n5) - 1;
            int n7 = 0;
            if (n5 > 0) {
                n7 = bitInputStream.getInt(vorbisStream.getSetupHeader().getCodeBooks()[this.classMasterbooks[n3]].getHuffmanRoot());
            }
            for (int j = 0; j < n4; ++j) {
                int n8 = this.subclassBooks[n3][n7 & n6];
                n7 >>>= n5;
                floor1.yList[j + n2] = n8 >= 0 ? bitInputStream.getInt(vorbisStream.getSetupHeader().getCodeBooks()[n8].getHuffmanRoot()) : 0;
            }
            n2 += n4;
        }
        return floor1;
    }

    protected void computeFloor(float[] fArray) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = fArray.length;
        int n7 = this.xList.length;
        boolean[] blArray = new boolean[n7];
        int n8 = RANGES[this.multiplier - 1];
        for (int i = 2; i < n7; ++i) {
            n5 = this.lowNeighbours[i];
            n4 = this.highNeighbours[i];
            n3 = Util.renderPoint(this.xList[n5], this.xList[n4], this.yList[n5], this.yList[n4], this.xList[i]);
            n2 = this.yList[i];
            int n9 = n8 - n3;
            int n10 = n3;
            int n11 = n = n9 < n10 ? n9 * 2 : n10 * 2;
            if (n2 != 0) {
                blArray[n5] = true;
                blArray[n4] = true;
                blArray[i] = true;
                if (n2 >= n) {
                    this.yList[i] = n9 > n10 ? n2 - n10 + n3 : -n2 + n9 + n3 - 1;
                    continue;
                }
                this.yList[i] = (n2 & 1) == 1 ? n3 - (n2 + 1 >> 1) : n3 + (n2 >> 1);
                continue;
            }
            blArray[i] = false;
            this.yList[i] = n3;
        }
        int[] nArray = new int[n7];
        System.arraycopy(this.xList, 0, nArray, 0, n7);
        Floor1.sort(nArray, this.yList, blArray);
        n5 = 0;
        n4 = 0;
        n3 = 0;
        n2 = this.yList[0] * this.multiplier;
        float[] fArray2 = new float[fArray.length];
        float[] fArray3 = new float[fArray.length];
        Arrays.fill(fArray2, 1.0f);
        System.arraycopy(fArray, 0, fArray3, 0, fArray.length);
        for (n = 1; n < n7; ++n) {
            if (!blArray[n]) continue;
            n4 = this.yList[n] * this.multiplier;
            n5 = nArray[n];
            Util.renderLine(n3, n2, n5, n4, fArray);
            Util.renderLine(n3, n2, n5, n4, fArray2);
            n3 = n5;
            n2 = n4;
        }
        float f = DB_STATIC_TABLE[n4];
        while (n5 < n6 / 2) {
            fArray[n5++] = f;
        }
    }

    public Object clone() {
        Floor1 floor1 = new Floor1();
        floor1.classDimensions = this.classDimensions;
        floor1.classMasterbooks = this.classMasterbooks;
        floor1.classSubclasses = this.classSubclasses;
        floor1.maximumClass = this.maximumClass;
        floor1.multiplier = this.multiplier;
        floor1.partitionClassList = this.partitionClassList;
        floor1.rangeBits = this.rangeBits;
        floor1.subclassBooks = this.subclassBooks;
        floor1.xList = this.xList;
        floor1.yList = this.yList;
        floor1.lowNeighbours = this.lowNeighbours;
        floor1.highNeighbours = this.highNeighbours;
        return floor1;
    }

    private static final void sort(int[] nArray, int[] nArray2, boolean[] blArray) {
        int n = 0;
        int n2 = nArray.length;
        int n3 = n2 + n;
        for (int i = n; i < n3; ++i) {
            for (int j = i; j > n && nArray[j - 1] > nArray[j]; --j) {
                int n4 = nArray[j];
                nArray[j] = nArray[j - 1];
                nArray[j - 1] = n4;
                n4 = nArray2[j];
                nArray2[j] = nArray2[j - 1];
                nArray2[j - 1] = n4;
                boolean bl = blArray[j];
                blArray[j] = blArray[j - 1];
                blArray[j - 1] = bl;
            }
        }
    }

    private static final void swap(int[] nArray, int n, int n2) {
        int n3 = nArray[n];
        nArray[n] = nArray[n2];
        nArray[n2] = n3;
    }

    private static final void swap(boolean[] blArray, int n, int n2) {
        boolean bl = blArray[n];
        blArray[n] = blArray[n2];
        blArray[n2] = bl;
    }
}

