/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.ogg;

import de.jarnbjo.ogg.LogicalOggStream;
import de.jarnbjo.ogg.LogicalOggStreamImpl;
import de.jarnbjo.ogg.OggFormatException;
import de.jarnbjo.ogg.OggPage;
import de.jarnbjo.ogg.PhysicalOggStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;

public class BasicStream
implements PhysicalOggStream {
    private boolean closed = false;
    private InputStream sourceStream;
    private Object drainLock = new Object();
    private LinkedList pageCache = new LinkedList();
    private long numberOfSamples = -1L;
    private int position = 0;
    private HashMap logicalStreams = new HashMap();
    private OggPage firstPage;
    int pageNumber = 2;

    public BasicStream(InputStream inputStream) throws OggFormatException, IOException {
        this.firstPage = OggPage.create(inputStream);
        this.position += this.firstPage.getTotalLength();
        LogicalOggStreamImpl logicalOggStreamImpl = new LogicalOggStreamImpl(this, this.firstPage.getStreamSerialNumber());
        this.logicalStreams.put(new Integer(this.firstPage.getStreamSerialNumber()), logicalOggStreamImpl);
        logicalOggStreamImpl.checkFormat(this.firstPage);
    }

    public Collection getLogicalStreams() {
        return this.logicalStreams.values();
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public void close() throws IOException {
        this.closed = true;
        this.sourceStream.close();
    }

    public int getContentLength() {
        return -1;
    }

    public int getPosition() {
        return this.position;
    }

    public OggPage getOggPage(int n) throws IOException {
        if (this.firstPage != null) {
            OggPage oggPage = this.firstPage;
            this.firstPage = null;
            return oggPage;
        }
        OggPage oggPage = OggPage.create(this.sourceStream);
        this.position += oggPage.getTotalLength();
        return oggPage;
    }

    private LogicalOggStream getLogicalStream(int n) {
        return (LogicalOggStream)this.logicalStreams.get(new Integer(n));
    }

    public void setTime(long l) throws IOException {
        throw new UnsupportedOperationException("Method not supported by this class");
    }

    public boolean isSeekable() {
        return false;
    }
}

