/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.utils.math;

import com.jme.math.Vector3f;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.logging.Logger;

public class Vector3d
implements Externalizable,
Savable {
    private static final Logger logger = Logger.getLogger(Vector3d.class.getName());
    private static final long serialVersionUID = 1L;
    public static final Vector3d ZERO = new Vector3d(0.0, 0.0, 0.0);
    public static final Vector3d UNIT_X = new Vector3d(1.0, 0.0, 0.0);
    public static final Vector3d UNIT_Y = new Vector3d(0.0, 1.0, 0.0);
    public static final Vector3d UNIT_Z = new Vector3d(0.0, 0.0, 1.0);
    public static final Vector3d UNIT_XYZ = new Vector3d(1.0, 1.0, 1.0);
    public double x;
    public double y;
    public double z;

    public Vector3d() {
        this.z = 0.0;
        this.y = 0.0;
        this.x = 0.0;
    }

    public Vector3d(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public Vector3d(Vector3d vector3d) {
        this.set(vector3d);
    }

    public Vector3d(Vector3f vector3f) {
        this.set(vector3f);
    }

    public Vector3d set(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        return this;
    }

    public Vector3d set(Vector3d vector3d) {
        this.x = vector3d.x;
        this.y = vector3d.y;
        this.z = vector3d.z;
        return this;
    }

    public Vector3d set(Vector3f vector3f) {
        this.x = vector3f.x;
        this.y = vector3f.y;
        this.z = vector3f.z;
        return this;
    }

    public Vector3f toVector3f(Vector3f vector3f) {
        if (vector3f == null) {
            vector3f = new Vector3f((float)this.x, (float)this.y, (float)this.z);
            return vector3f;
        }
        return vector3f.set((float)this.x, (float)this.y, (float)this.z);
    }

    public Vector3d add(Vector3d vector3d) {
        if (null == vector3d) {
            logger.warning("Provided vector is null, null returned.");
            return null;
        }
        return new Vector3d(this.x + vector3d.x, this.y + vector3d.y, this.z + vector3d.z);
    }

    public Vector3d add(Vector3d vector3d, Vector3d vector3d2) {
        vector3d2.x = this.x + vector3d.x;
        vector3d2.y = this.y + vector3d.y;
        vector3d2.z = this.z + vector3d.z;
        return vector3d2;
    }

    public Vector3d addLocal(Vector3d vector3d) {
        if (null == vector3d) {
            logger.warning("Provided vector is null, null returned.");
            return null;
        }
        this.x += vector3d.x;
        this.y += vector3d.y;
        this.z += vector3d.z;
        return this;
    }

    public Vector3d add(double d, double d2, double d3) {
        return new Vector3d(this.x + d, this.y + d2, this.z + d3);
    }

    public Vector3d addLocal(double d, double d2, double d3) {
        this.x += d;
        this.y += d2;
        this.z += d3;
        return this;
    }

    public void scaleAdd(double d, Vector3d vector3d) {
        this.x = this.x * d + vector3d.x;
        this.y = this.y * d + vector3d.y;
        this.z = this.z * d + vector3d.z;
    }

    public void scaleAdd(double d, Vector3d vector3d, Vector3d vector3d2) {
        this.x = vector3d.x * d + vector3d2.x;
        this.y = vector3d.y * d + vector3d2.y;
        this.z = vector3d.z * d + vector3d2.z;
    }

    public double dot(Vector3d vector3d) {
        if (null == vector3d) {
            logger.warning("Provided vector is null, 0 returned.");
            return 0.0;
        }
        return this.x * vector3d.x + this.y * vector3d.y + this.z * vector3d.z;
    }

    public double dot(Vector3f vector3f) {
        if (null == vector3f) {
            logger.warning("Provided vector is null, 0 returned.");
            return 0.0;
        }
        return this.x * (double)vector3f.x + this.y * (double)vector3f.y + this.z * (double)vector3f.z;
    }

    public Vector3d cross(Vector3d vector3d) {
        return this.cross(vector3d, null);
    }

    public Vector3d cross(Vector3d vector3d, Vector3d vector3d2) {
        return this.cross(vector3d.x, vector3d.y, vector3d.z, vector3d2);
    }

    public Vector3d cross(double d, double d2, double d3, Vector3d vector3d) {
        if (vector3d == null) {
            vector3d = new Vector3d();
        }
        double d4 = this.y * d3 - this.z * d2;
        double d5 = this.z * d - this.x * d3;
        double d6 = this.x * d2 - this.y * d;
        vector3d.set(d4, d5, d6);
        return vector3d;
    }

    public Vector3d crossLocal(Vector3d vector3d) {
        return this.crossLocal(vector3d.x, vector3d.y, vector3d.z);
    }

    public Vector3d crossLocal(double d, double d2, double d3) {
        double d4 = this.y * d3 - this.z * d2;
        double d5 = this.z * d - this.x * d3;
        this.z = this.x * d2 - this.y * d;
        this.x = d4;
        this.y = d5;
        return this;
    }

    public double length() {
        return Math.sqrt(this.lengthSquared());
    }

    public double lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public double distanceSquared(Vector3d vector3d) {
        double d = this.x - vector3d.x;
        double d2 = this.y - vector3d.y;
        double d3 = this.z - vector3d.z;
        return d * d + d2 * d2 + d3 * d3;
    }

    public double distance(Vector3d vector3d) {
        return Math.sqrt(this.distanceSquared(vector3d));
    }

    public Vector3d mult(double d) {
        return new Vector3d(this.x * d, this.y * d, this.z * d);
    }

    public Vector3d mult(double d, Vector3d vector3d) {
        if (null == vector3d) {
            vector3d = new Vector3d();
        }
        vector3d.x = this.x * d;
        vector3d.y = this.y * d;
        vector3d.z = this.z * d;
        return vector3d;
    }

    public Vector3d multLocal(double d) {
        this.x *= d;
        this.y *= d;
        this.z *= d;
        return this;
    }

    public Vector3d multLocal(Vector3d vector3d) {
        if (null == vector3d) {
            logger.warning("Provided vector is null, null returned.");
            return null;
        }
        this.x *= vector3d.x;
        this.y *= vector3d.y;
        this.z *= vector3d.z;
        return this;
    }

    public Vector3d mult(Vector3d vector3d) {
        if (null == vector3d) {
            logger.warning("Provided vector is null, null returned.");
            return null;
        }
        return this.mult(vector3d, null);
    }

    public Vector3d mult(Vector3d vector3d, Vector3d vector3d2) {
        if (null == vector3d) {
            logger.warning("Provided vector is null, null returned.");
            return null;
        }
        if (vector3d2 == null) {
            vector3d2 = new Vector3d();
        }
        return vector3d2.set(this.x * vector3d.x, this.y * vector3d.y, this.z * vector3d.z);
    }

    public Vector3d divide(double d) {
        d = 1.0 / d;
        return new Vector3d(this.x * d, this.y * d, this.z * d);
    }

    public Vector3d divideLocal(double d) {
        d = 1.0 / d;
        this.x *= d;
        this.y *= d;
        this.z *= d;
        return this;
    }

    public Vector3d divide(Vector3d vector3d) {
        return new Vector3d(this.x / vector3d.x, this.y / vector3d.y, this.z / vector3d.z);
    }

    public Vector3d divideLocal(Vector3d vector3d) {
        this.x /= vector3d.x;
        this.y /= vector3d.y;
        this.z /= vector3d.z;
        return this;
    }

    public Vector3d negate() {
        return new Vector3d(-this.x, -this.y, -this.z);
    }

    public Vector3d negateLocal() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public Vector3d subtract(Vector3d vector3d) {
        return new Vector3d(this.x - vector3d.x, this.y - vector3d.y, this.z - vector3d.z);
    }

    public Vector3d subtractLocal(Vector3d vector3d) {
        if (null == vector3d) {
            logger.warning("Provided vector is null, null returned.");
            return null;
        }
        this.x -= vector3d.x;
        this.y -= vector3d.y;
        this.z -= vector3d.z;
        return this;
    }

    public Vector3d subtract(Vector3d vector3d, Vector3d vector3d2) {
        if (vector3d2 == null) {
            vector3d2 = new Vector3d();
        }
        vector3d2.x = this.x - vector3d.x;
        vector3d2.y = this.y - vector3d.y;
        vector3d2.z = this.z - vector3d.z;
        return vector3d2;
    }

    public Vector3d subtract(double d, double d2, double d3) {
        return new Vector3d(this.x - d, this.y - d2, this.z - d3);
    }

    public Vector3d subtractLocal(double d, double d2, double d3) {
        this.x -= d;
        this.y -= d2;
        this.z -= d3;
        return this;
    }

    public Vector3d normalize() {
        double d = this.length();
        if (d != 0.0) {
            return this.divide(d);
        }
        return this.divide(1.0);
    }

    public Vector3d normalizeLocal() {
        double d = this.length();
        if (d != 0.0) {
            return this.divideLocal(d);
        }
        return this;
    }

    public void zero() {
        this.z = 0.0;
        this.y = 0.0;
        this.x = 0.0;
    }

    public double angleBetween(Vector3d vector3d) {
        double d = this.dot(vector3d);
        double d2 = Math.acos(d);
        return d2;
    }

    public void interpolate(Vector3d vector3d, double d) {
        this.x = (1.0 - d) * this.x + d * vector3d.x;
        this.y = (1.0 - d) * this.y + d * vector3d.y;
        this.z = (1.0 - d) * this.z + d * vector3d.z;
    }

    public void interpolate(Vector3d vector3d, Vector3d vector3d2, double d) {
        this.x = (1.0 - d) * vector3d.x + d * vector3d2.x;
        this.y = (1.0 - d) * vector3d.y + d * vector3d2.y;
        this.z = (1.0 - d) * vector3d.z + d * vector3d2.z;
    }

    public static boolean isValidVector(Vector3d vector3d) {
        if (vector3d == null) {
            return false;
        }
        if (Double.isNaN(vector3d.x) || Double.isNaN(vector3d.y) || Double.isNaN(vector3d.z)) {
            return false;
        }
        return !Double.isInfinite(vector3d.x) && !Double.isInfinite(vector3d.y) && !Double.isInfinite(vector3d.z);
    }

    public static void generateOrthonormalBasis(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3) {
        vector3d3.normalizeLocal();
        Vector3d.generateComplementBasis(vector3d, vector3d2, vector3d3);
    }

    public static void generateComplementBasis(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3) {
        if (Math.abs(vector3d3.x) >= Math.abs(vector3d3.y)) {
            double d = 1.0 / Math.sqrt(vector3d3.x * vector3d3.x + vector3d3.z * vector3d3.z);
            vector3d.x = -vector3d3.z * d;
            vector3d.y = 0.0;
            vector3d.z = vector3d3.x * d;
            vector3d2.x = vector3d3.y * vector3d.z;
            vector3d2.y = vector3d3.z * vector3d.x - vector3d3.x * vector3d.z;
            vector3d2.z = -vector3d3.y * vector3d.x;
        } else {
            double d = 1.0 / Math.sqrt(vector3d3.y * vector3d3.y + vector3d3.z * vector3d3.z);
            vector3d.x = 0.0;
            vector3d.y = vector3d3.z * d;
            vector3d.z = -vector3d3.y * d;
            vector3d2.x = vector3d3.y * vector3d.z - vector3d3.z * vector3d.y;
            vector3d2.y = -vector3d3.x * vector3d.z;
            vector3d2.z = vector3d3.x * vector3d.y;
        }
    }

    public Object clone() {
        return new Vector3d(this.x, this.y, this.z);
    }

    public double[] toArray(double[] dArray) {
        dArray[0] = this.x;
        dArray[1] = this.y;
        dArray[2] = this.z;
        return dArray;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Vector3d)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        Vector3d vector3d = (Vector3d)object;
        if (Double.compare(this.x, vector3d.x) != 0) {
            return false;
        }
        if (Double.compare(this.y, vector3d.y) != 0) {
            return false;
        }
        return Double.compare(this.z, vector3d.z) == 0;
    }

    public int hashCode() {
        int n = 37;
        n = (int)((long)n + ((long)(37 * n) + Double.doubleToLongBits(this.x)));
        n = (int)((long)n + ((long)(37 * n) + Double.doubleToLongBits(this.y)));
        n = (int)((long)n + ((long)(37 * n) + Double.doubleToLongBits(this.z)));
        return n;
    }

    public String toString() {
        return "com.jme.math.Vector3d [X=" + this.x + ", Y=" + this.y + ", Z=" + this.z + "]";
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.x = objectInput.readDouble();
        this.y = objectInput.readDouble();
        this.z = objectInput.readDouble();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeDouble(this.x);
        objectOutput.writeDouble(this.y);
        objectOutput.writeDouble(this.z);
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.x, "x", 0.0);
        outputCapsule.write(this.y, "y", 0.0);
        outputCapsule.write(this.z, "z", 0.0);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.x = inputCapsule.readDouble("x", 0.0);
        this.y = inputCapsule.readDouble("y", 0.0);
        this.z = inputCapsule.readDouble("z", 0.0);
    }

    public Class getClassTag() {
        return this.getClass();
    }

    public double getX() {
        return this.x;
    }

    public void setX(double d) {
        this.x = d;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double d) {
        this.y = d;
    }

    public double getZ() {
        return this.z;
    }

    public void setZ(double d) {
        this.z = d;
    }

    public double get(int n) {
        switch (n) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new IllegalArgumentException("index must be either 0, 1 or 2");
    }

    public void set(int n, double d) {
        switch (n) {
            case 0: {
                this.x = d;
                return;
            }
            case 1: {
                this.y = d;
                return;
            }
            case 2: {
                this.z = d;
                return;
            }
        }
        throw new IllegalArgumentException("index must be either 0, 1 or 2");
    }
}

