/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.utils.math;

import com.jme.system.JmeException;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import com.turborilla.utils.math.Matrix3d;
import com.turborilla.utils.math.Matrix4d;
import com.turborilla.utils.math.Vector3d;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.logging.Logger;

public class Quaternion
implements Externalizable,
Savable {
    private static final Logger logger = Logger.getLogger(Quaternion.class.getName());
    private static final long serialVersionUID = 1L;
    private static final double HALF_PI = 1.5707963267948966;
    public double x;
    public double y;
    public double z;
    public double w;
    private static final Vector3d tmpYaxis = new Vector3d();
    private static final Vector3d tmpZaxis = new Vector3d();
    private static final Vector3d tmpXaxis = new Vector3d();

    public Quaternion() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        this.w = 1.0;
    }

    public Quaternion(double d, double d2, double d3, double d4) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.w = d4;
    }

    public void set(double d, double d2, double d3, double d4) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.w = d4;
    }

    public Quaternion set(Quaternion quaternion) {
        this.x = quaternion.x;
        this.y = quaternion.y;
        this.z = quaternion.z;
        this.w = quaternion.w;
        return this;
    }

    public Quaternion set(com.jme.math.Quaternion quaternion) {
        this.x = quaternion.x;
        this.y = quaternion.y;
        this.z = quaternion.z;
        this.w = quaternion.w;
        return this;
    }

    public com.jme.math.Quaternion toFloatQuaternion(com.jme.math.Quaternion quaternion) {
        if (quaternion == null) {
            quaternion = new com.jme.math.Quaternion();
        }
        quaternion.x = (float)this.x;
        quaternion.y = (float)this.y;
        quaternion.z = (float)this.z;
        quaternion.w = (float)this.w;
        return quaternion;
    }

    public Quaternion(double[] dArray) {
        this.fromAngles(dArray);
    }

    public Quaternion(Quaternion quaternion, Quaternion quaternion2, double d) {
        this.slerp(quaternion, quaternion2, d);
    }

    public Quaternion(Quaternion quaternion) {
        this.x = quaternion.x;
        this.y = quaternion.y;
        this.z = quaternion.z;
        this.w = quaternion.w;
    }

    public void loadIdentity() {
        this.z = 0.0;
        this.y = 0.0;
        this.x = 0.0;
        this.w = 1.0;
    }

    public boolean isIdentity() {
        return this.x == 0.0 && this.y == 0.0 && this.z == 0.0 && this.w == 1.0;
    }

    public void fromAngles(double[] dArray) {
        if (dArray.length != 3) {
            throw new IllegalArgumentException("Angles array must have three elements");
        }
        this.fromAngles(dArray[0], dArray[1], dArray[2]);
    }

    public void fromAngles(double d, double d2, double d3) {
        double d4 = d3 * 0.5;
        double d5 = Math.sin(d4);
        double d6 = Math.cos(d4);
        d4 = d2 * 0.5;
        double d7 = Math.sin(d4);
        double d8 = Math.cos(d4);
        d4 = d * 0.5;
        double d9 = Math.sin(d4);
        double d10 = Math.cos(d4);
        double d11 = d10 * d8;
        double d12 = d9 * d7;
        this.x = d9 * d8 * d6 - d10 * d7 * d5;
        this.y = d10 * d7 * d6 + d9 * d8 * d5;
        this.z = d11 * d5 - d12 * d6;
        this.w = d11 * d6 + d12 * d5;
    }

    public double[] toAngles(double[] dArray) {
        if (dArray == null) {
            dArray = new double[3];
        } else if (dArray.length != 3) {
            throw new IllegalArgumentException("Angles array must have three elements");
        }
        double d = this.w * this.w;
        double d2 = this.x * this.x;
        double d3 = this.y * this.y;
        double d4 = this.z * this.z;
        double d5 = d2 + d3 + d4 + d;
        double d6 = this.x * this.y + this.z * this.w;
        if (d6 > 0.499 * d5) {
            dArray[1] = 2.0 * Math.atan2(this.x, this.w);
            dArray[2] = 1.5707963267948966;
            dArray[0] = 0.0;
        } else if (d6 < -0.499 * d5) {
            dArray[1] = -2.0 * Math.atan2(this.x, this.w);
            dArray[2] = -1.5707963267948966;
            dArray[0] = 0.0;
        } else {
            dArray[1] = Math.atan2(2.0 * this.y * this.w - 2.0 * this.x * this.z, d2 - d3 - d4 + d);
            dArray[2] = Math.asin(2.0 * d6 / d5);
            dArray[0] = Math.atan2(2.0 * this.x * this.w - 2.0 * this.y * this.z, -d2 + d3 - d4 + d);
        }
        return dArray;
    }

    public void fromRotationMatrix(Matrix3d matrix3d) {
        this.fromRotationMatrix(matrix3d.m00, matrix3d.m01, matrix3d.m02, matrix3d.m10, matrix3d.m11, matrix3d.m12, matrix3d.m20, matrix3d.m21, matrix3d.m22);
    }

    public void fromRotationMatrix(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        double d10 = d + d5 + d9;
        if (d10 >= 0.0) {
            double d11 = Math.sqrt(d10 + 1.0);
            this.w = 0.5 * d11;
            d11 = 0.5 / d11;
            this.x = (d8 - d6) * d11;
            this.y = (d3 - d7) * d11;
            this.z = (d4 - d2) * d11;
        } else if (d > d5 && d > d9) {
            double d12 = Math.sqrt(1.0 + d - d5 - d9);
            this.x = d12 * 0.5;
            d12 = 0.5 / d12;
            this.y = (d4 + d2) * d12;
            this.z = (d3 + d7) * d12;
            this.w = (d8 - d6) * d12;
        } else if (d5 > d9) {
            double d13 = Math.sqrt(1.0 + d5 - d - d9);
            this.y = d13 * 0.5;
            d13 = 0.5 / d13;
            this.x = (d4 + d2) * d13;
            this.z = (d8 + d6) * d13;
            this.w = (d3 - d7) * d13;
        } else {
            double d14 = Math.sqrt(1.0 + d9 - d - d5);
            this.z = d14 * 0.5;
            d14 = 0.5 / d14;
            this.x = (d3 + d7) * d14;
            this.y = (d8 + d6) * d14;
            this.w = (d4 - d2) * d14;
        }
    }

    public Matrix3d toRotationMatrix() {
        Matrix3d matrix3d = new Matrix3d();
        return this.toRotationMatrix(matrix3d);
    }

    public Matrix3d toRotationMatrix(Matrix3d matrix3d) {
        double d = this.norm();
        double d2 = d == 1.0 ? 2.0 : (d > 0.0 ? 2.0 / d : 0.0);
        double d3 = this.x * d2;
        double d4 = this.y * d2;
        double d5 = this.z * d2;
        double d6 = this.x * d3;
        double d7 = this.x * d4;
        double d8 = this.x * d5;
        double d9 = this.w * d3;
        double d10 = this.y * d4;
        double d11 = this.y * d5;
        double d12 = this.w * d4;
        double d13 = this.z * d5;
        double d14 = this.w * d5;
        matrix3d.m00 = 1.0 - (d10 + d13);
        matrix3d.m01 = d7 - d14;
        matrix3d.m02 = d8 + d12;
        matrix3d.m10 = d7 + d14;
        matrix3d.m11 = 1.0 - (d6 + d13);
        matrix3d.m12 = d11 - d9;
        matrix3d.m20 = d8 - d12;
        matrix3d.m21 = d11 + d9;
        matrix3d.m22 = 1.0 - (d6 + d10);
        return matrix3d;
    }

    public Matrix4d toRotationMatrix(Matrix4d matrix4d) {
        double d = this.norm();
        double d2 = d == 1.0 ? 2.0 : (d > 0.0 ? 2.0 / d : 0.0);
        double d3 = this.x * d2;
        double d4 = this.y * d2;
        double d5 = this.z * d2;
        double d6 = this.x * d3;
        double d7 = this.x * d4;
        double d8 = this.x * d5;
        double d9 = this.w * d3;
        double d10 = this.y * d4;
        double d11 = this.y * d5;
        double d12 = this.w * d4;
        double d13 = this.z * d5;
        double d14 = this.w * d5;
        matrix4d.m00 = 1.0 - (d10 + d13);
        matrix4d.m01 = d7 - d14;
        matrix4d.m02 = d8 + d12;
        matrix4d.m10 = d7 + d14;
        matrix4d.m11 = 1.0 - (d6 + d13);
        matrix4d.m12 = d11 - d9;
        matrix4d.m20 = d8 - d12;
        matrix4d.m21 = d11 + d9;
        matrix4d.m22 = 1.0 - (d6 + d10);
        return matrix4d;
    }

    public Vector3d getRotationColumn(int n) {
        return this.getRotationColumn(n, null);
    }

    public Vector3d getRotationColumn(int n, Vector3d vector3d) {
        double d;
        if (vector3d == null) {
            vector3d = new Vector3d();
        }
        if ((d = this.norm()) != 1.0) {
            d = 1.0 / Math.sqrt(d);
        }
        double d2 = this.x * this.x * d;
        double d3 = this.x * this.y * d;
        double d4 = this.x * this.z * d;
        double d5 = this.x * this.w * d;
        double d6 = this.y * this.y * d;
        double d7 = this.y * this.z * d;
        double d8 = this.y * this.w * d;
        double d9 = this.z * this.z * d;
        double d10 = this.z * this.w * d;
        switch (n) {
            case 0: {
                vector3d.x = 1.0 - 2.0 * (d6 + d9);
                vector3d.y = 2.0 * (d3 + d10);
                vector3d.z = 2.0 * (d4 - d8);
                break;
            }
            case 1: {
                vector3d.x = 2.0 * (d3 - d10);
                vector3d.y = 1.0 - 2.0 * (d2 + d9);
                vector3d.z = 2.0 * (d7 + d5);
                break;
            }
            case 2: {
                vector3d.x = 2.0 * (d4 + d8);
                vector3d.y = 2.0 * (d7 - d5);
                vector3d.z = 1.0 - 2.0 * (d2 + d6);
                break;
            }
            default: {
                logger.warning("Invalid column index.");
                throw new JmeException("Invalid column index. " + n);
            }
        }
        return vector3d;
    }

    public Quaternion fromAngleAxis(double d, Vector3d vector3d) {
        Vector3d vector3d2 = vector3d.normalize();
        this.fromAngleNormalAxis(d, vector3d2);
        return this;
    }

    public Quaternion fromAngleNormalAxis(double d, Vector3d vector3d) {
        double d2 = 0.5 * d;
        double d3 = Math.sin(d2);
        this.w = Math.cos(d2);
        this.x = d3 * vector3d.x;
        this.y = d3 * vector3d.y;
        this.z = d3 * vector3d.z;
        return this;
    }

    public double toAngleAxis(Vector3d vector3d) {
        double d;
        double d2 = this.x * this.x + this.y * this.y + this.z * this.z;
        if (d2 == 0.0) {
            d = 0.0;
            vector3d.x = 1.0;
            vector3d.y = 0.0;
            vector3d.z = 0.0;
        } else {
            d = 2.0 * Math.acos(this.w);
            double d3 = 1.0 / Math.sqrt(d2);
            vector3d.x = this.x * d3;
            vector3d.y = this.y * d3;
            vector3d.z = this.z * d3;
        }
        return d;
    }

    public Quaternion slerp(Quaternion quaternion, Quaternion quaternion2, double d) {
        if (quaternion.x == quaternion2.x && quaternion.y == quaternion2.y && quaternion.z == quaternion2.z && quaternion.w == quaternion2.w) {
            this.set(quaternion);
            return this;
        }
        double d2 = quaternion.x * quaternion2.x + quaternion.y * quaternion2.y + quaternion.z * quaternion2.z + quaternion.w * quaternion2.w;
        if (d2 < 0.0) {
            quaternion2.x = -quaternion2.x;
            quaternion2.y = -quaternion2.y;
            quaternion2.z = -quaternion2.z;
            quaternion2.w = -quaternion2.w;
            d2 = -d2;
        }
        double d3 = 1.0 - d;
        double d4 = d;
        if (1.0 - d2 > (double)0.1f) {
            double d5 = Math.acos(d2);
            double d6 = 1.0 / Math.sin(d5);
            d3 = Math.sin((1.0 - d) * d5) * d6;
            d4 = Math.sin(d * d5) * d6;
        }
        this.x = d3 * quaternion.x + d4 * quaternion2.x;
        this.y = d3 * quaternion.y + d4 * quaternion2.y;
        this.z = d3 * quaternion.z + d4 * quaternion2.z;
        this.w = d3 * quaternion.w + d4 * quaternion2.w;
        return this;
    }

    public void slerp(Quaternion quaternion, double d) {
        if (this.x == quaternion.x && this.y == quaternion.y && this.z == quaternion.z && this.w == quaternion.w) {
            return;
        }
        double d2 = this.x * quaternion.x + this.y * quaternion.y + this.z * quaternion.z + this.w * quaternion.w;
        if (d2 < 0.0) {
            quaternion.x = -quaternion.x;
            quaternion.y = -quaternion.y;
            quaternion.z = -quaternion.z;
            quaternion.w = -quaternion.w;
            d2 = -d2;
        }
        double d3 = 1.0 - d;
        double d4 = d;
        if (1.0 - d2 > (double)0.1f) {
            double d5 = Math.acos(d2);
            double d6 = 1.0 / Math.sin(d5);
            d3 = Math.sin((1.0 - d) * d5) * d6;
            d4 = Math.sin(d * d5) * d6;
        }
        this.x = d3 * this.x + d4 * quaternion.x;
        this.y = d3 * this.y + d4 * quaternion.y;
        this.z = d3 * this.z + d4 * quaternion.z;
        this.w = d3 * this.w + d4 * quaternion.w;
    }

    public Quaternion add(Quaternion quaternion) {
        return new Quaternion(this.x + quaternion.x, this.y + quaternion.y, this.z + quaternion.z, this.w + quaternion.w);
    }

    public Quaternion addLocal(Quaternion quaternion) {
        this.x += quaternion.x;
        this.y += quaternion.y;
        this.z += quaternion.z;
        this.w += quaternion.w;
        return this;
    }

    public Quaternion subtract(Quaternion quaternion) {
        return new Quaternion(this.x - quaternion.x, this.y - quaternion.y, this.z - quaternion.z, this.w - quaternion.w);
    }

    public Quaternion subtractLocal(Quaternion quaternion) {
        this.x -= quaternion.x;
        this.y -= quaternion.y;
        this.z -= quaternion.z;
        this.w -= quaternion.w;
        return this;
    }

    public Quaternion mult(Quaternion quaternion) {
        return this.mult(quaternion, null);
    }

    public Quaternion mult(Quaternion quaternion, Quaternion quaternion2) {
        if (quaternion2 == null) {
            quaternion2 = new Quaternion();
        }
        double d = quaternion.w;
        double d2 = quaternion.x;
        double d3 = quaternion.y;
        double d4 = quaternion.z;
        quaternion2.x = this.x * d + this.y * d4 - this.z * d3 + this.w * d2;
        quaternion2.y = -this.x * d4 + this.y * d + this.z * d2 + this.w * d3;
        quaternion2.z = this.x * d3 - this.y * d2 + this.z * d + this.w * d4;
        quaternion2.w = -this.x * d2 - this.y * d3 - this.z * d4 + this.w * d;
        return quaternion2;
    }

    public void apply(Matrix3d matrix3d) {
        double d = this.x;
        double d2 = this.y;
        double d3 = this.z;
        double d4 = this.w;
        this.fromRotationMatrix(matrix3d);
        double d5 = this.x;
        double d6 = this.y;
        double d7 = this.z;
        double d8 = this.w;
        this.x = d * d8 + d2 * d7 - d3 * d6 + d4 * d5;
        this.y = -d * d7 + d2 * d8 + d3 * d5 + d4 * d6;
        this.z = d * d6 - d2 * d5 + d3 * d8 + d4 * d7;
        this.w = -d * d5 - d2 * d6 - d3 * d7 + d4 * d8;
    }

    public void fromAxes(Vector3d[] vector3dArray) {
        if (vector3dArray.length != 3) {
            throw new IllegalArgumentException("Axis array must have three elements");
        }
        this.fromAxes(vector3dArray[0], vector3dArray[1], vector3dArray[2]);
    }

    public void fromAxes(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3) {
        this.fromRotationMatrix(vector3d.x, vector3d2.x, vector3d3.x, vector3d.y, vector3d2.y, vector3d3.y, vector3d.z, vector3d2.z, vector3d3.z);
    }

    public void toAxes(Vector3d[] vector3dArray) {
        Matrix3d matrix3d = this.toRotationMatrix();
        vector3dArray[0] = matrix3d.getColumn(0, vector3dArray[0]);
        vector3dArray[1] = matrix3d.getColumn(1, vector3dArray[1]);
        vector3dArray[2] = matrix3d.getColumn(2, vector3dArray[2]);
    }

    public Vector3d mult(Vector3d vector3d) {
        return this.mult(vector3d, null);
    }

    public Vector3d multLocal(Vector3d vector3d) {
        double d = this.w * this.w * vector3d.x + 2.0 * this.y * this.w * vector3d.z - 2.0 * this.z * this.w * vector3d.y + this.x * this.x * vector3d.x + 2.0 * this.y * this.x * vector3d.y + 2.0 * this.z * this.x * vector3d.z - this.z * this.z * vector3d.x - this.y * this.y * vector3d.x;
        double d2 = 2.0 * this.x * this.y * vector3d.x + this.y * this.y * vector3d.y + 2.0 * this.z * this.y * vector3d.z + 2.0 * this.w * this.z * vector3d.x - this.z * this.z * vector3d.y + this.w * this.w * vector3d.y - 2.0 * this.x * this.w * vector3d.z - this.x * this.x * vector3d.y;
        vector3d.z = 2.0 * this.x * this.z * vector3d.x + 2.0 * this.y * this.z * vector3d.y + this.z * this.z * vector3d.z - 2.0 * this.w * this.y * vector3d.x - this.y * this.y * vector3d.z + 2.0 * this.w * this.x * vector3d.y - this.x * this.x * vector3d.z + this.w * this.w * vector3d.z;
        vector3d.x = d;
        vector3d.y = d2;
        return vector3d;
    }

    public Quaternion multLocal(Quaternion quaternion) {
        double d = this.x * quaternion.w + this.y * quaternion.z - this.z * quaternion.y + this.w * quaternion.x;
        double d2 = -this.x * quaternion.z + this.y * quaternion.w + this.z * quaternion.x + this.w * quaternion.y;
        double d3 = this.x * quaternion.y - this.y * quaternion.x + this.z * quaternion.w + this.w * quaternion.z;
        this.w = -this.x * quaternion.x - this.y * quaternion.y - this.z * quaternion.z + this.w * quaternion.w;
        this.x = d;
        this.y = d2;
        this.z = d3;
        return this;
    }

    public Quaternion multLocal(double d, double d2, double d3, double d4) {
        double d5 = this.x * d4 + this.y * d3 - this.z * d2 + this.w * d;
        double d6 = -this.x * d3 + this.y * d4 + this.z * d + this.w * d2;
        double d7 = this.x * d2 - this.y * d + this.z * d4 + this.w * d3;
        this.w = -this.x * d - this.y * d2 - this.z * d3 + this.w * d4;
        this.x = d5;
        this.y = d6;
        this.z = d7;
        return this;
    }

    public Vector3d mult(Vector3d vector3d, Vector3d vector3d2) {
        if (vector3d2 == null) {
            vector3d2 = new Vector3d();
        }
        if (vector3d.x == 0.0 && vector3d.y == 0.0 && vector3d.z == 0.0) {
            vector3d2.set(0.0, 0.0, 0.0);
        } else {
            double d = vector3d.x;
            double d2 = vector3d.y;
            double d3 = vector3d.z;
            vector3d2.x = this.w * this.w * d + 2.0 * this.y * this.w * d3 - 2.0 * this.z * this.w * d2 + this.x * this.x * d + 2.0 * this.y * this.x * d2 + 2.0 * this.z * this.x * d3 - this.z * this.z * d - this.y * this.y * d;
            vector3d2.y = 2.0 * this.x * this.y * d + this.y * this.y * d2 + 2.0 * this.z * this.y * d3 + 2.0 * this.w * this.z * d - this.z * this.z * d2 + this.w * this.w * d2 - 2.0 * this.x * this.w * d3 - this.x * this.x * d2;
            vector3d2.z = 2.0 * this.x * this.z * d + 2.0 * this.y * this.z * d2 + this.z * this.z * d3 - 2.0 * this.w * this.y * d - this.y * this.y * d3 + 2.0 * this.w * this.x * d2 - this.x * this.x * d3 + this.w * this.w * d3;
        }
        return vector3d2;
    }

    public Quaternion mult(double d) {
        return new Quaternion(d * this.w, d * this.x, d * this.y, d * this.z);
    }

    public Quaternion multLocal(double d) {
        this.w *= d;
        this.x *= d;
        this.y *= d;
        this.z *= d;
        return this;
    }

    public double dot(Quaternion quaternion) {
        return this.w * quaternion.w + this.x * quaternion.x + this.y * quaternion.y + this.z * quaternion.z;
    }

    public double norm() {
        return this.w * this.w + this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public void normalize() {
        double d = 1.0 / Math.sqrt(this.norm());
        this.x *= d;
        this.y *= d;
        this.z *= d;
        this.w *= d;
    }

    public Quaternion inverse() {
        double d = this.norm();
        if (d > 0.0) {
            double d2 = 1.0 / d;
            return new Quaternion(-this.x * d2, -this.y * d2, -this.z * d2, this.w * d2);
        }
        return null;
    }

    public Quaternion inverseLocal() {
        double d = this.norm();
        if (d > 0.0) {
            double d2 = 1.0 / d;
            this.x *= -d2;
            this.y *= -d2;
            this.z *= -d2;
            this.w *= d2;
        }
        return this;
    }

    public void negate() {
        this.x *= -1.0;
        this.y *= -1.0;
        this.z *= -1.0;
        this.w *= -1.0;
    }

    public String toString() {
        return "com.jme.math.Quaternion: [x=" + this.x + " y=" + this.y + " z=" + this.z + " w=" + this.w + "]";
    }

    public boolean equals(Object object) {
        if (!(object instanceof Quaternion)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        Quaternion quaternion = (Quaternion)object;
        if (Double.compare(this.x, quaternion.x) != 0) {
            return false;
        }
        if (Double.compare(this.y, quaternion.y) != 0) {
            return false;
        }
        if (Double.compare(this.z, quaternion.z) != 0) {
            return false;
        }
        return Double.compare(this.w, quaternion.w) == 0;
    }

    public int hashCode() {
        long l = 37L;
        l = 37L * l + Double.doubleToLongBits(this.x);
        l = 37L * l + Double.doubleToLongBits(this.y);
        l = 37L * l + Double.doubleToLongBits(this.z);
        l = 37L * l + Double.doubleToLongBits(this.w);
        return (int)l;
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        this.x = objectInput.readDouble();
        this.y = objectInput.readDouble();
        this.z = objectInput.readDouble();
        this.w = objectInput.readDouble();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeDouble(this.x);
        objectOutput.writeDouble(this.y);
        objectOutput.writeDouble(this.z);
        objectOutput.writeDouble(this.w);
    }

    public void lookAt(Vector3d vector3d, Vector3d vector3d2) {
        tmpZaxis.set(vector3d).normalizeLocal();
        tmpXaxis.set(vector3d2).crossLocal(vector3d).normalizeLocal();
        tmpYaxis.set(vector3d).crossLocal(tmpXaxis).normalizeLocal();
        this.fromAxes(tmpXaxis, tmpYaxis, tmpZaxis);
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.x, "x", 0.0);
        outputCapsule.write(this.y, "y", 0.0);
        outputCapsule.write(this.z, "z", 0.0);
        outputCapsule.write(this.w, "w", 1.0);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.x = inputCapsule.readDouble("x", 0.0);
        this.y = inputCapsule.readDouble("y", 0.0);
        this.z = inputCapsule.readDouble("z", 0.0);
        this.w = inputCapsule.readDouble("w", 1.0);
    }

    public Class getClassTag() {
        return this.getClass();
    }

    public Quaternion opposite() {
        return this.opposite(null);
    }

    public Quaternion opposite(Quaternion quaternion) {
        if (quaternion == null) {
            quaternion = new Quaternion();
        }
        Vector3d vector3d = new Vector3d();
        double d = this.toAngleAxis(vector3d);
        quaternion.fromAngleAxis(Math.PI + d, vector3d);
        return quaternion;
    }

    public Quaternion oppositeLocal() {
        return this.opposite(this);
    }
}

