/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.utils.math;

import com.jme.math.Matrix3f;
import com.jme.system.JmeException;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import com.jme.util.geom.BufferUtils;
import com.turborilla.utils.math.Quaternion;
import com.turborilla.utils.math.Vector3d;
import java.io.IOException;
import java.io.Serializable;
import java.nio.DoubleBuffer;
import java.util.logging.Logger;

public class Matrix3d
implements Serializable,
Savable {
    private static final Logger logger = Logger.getLogger(Matrix3d.class.getName());
    private static final long serialVersionUID = 1L;
    private static final double DBL_EPSILON = 2.220446049250313E-16;
    private static final double ZERO_TOLERANCE = 1.0E-18;
    public double m00;
    public double m01;
    public double m02;
    public double m10;
    public double m11;
    public double m12;
    public double m20;
    public double m21;
    public double m22;

    public Matrix3d() {
        this.loadIdentity();
    }

    public Matrix3d(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        this.m00 = d;
        this.m01 = d2;
        this.m02 = d3;
        this.m10 = d4;
        this.m11 = d5;
        this.m12 = d6;
        this.m20 = d7;
        this.m21 = d8;
        this.m22 = d9;
    }

    public Matrix3d(Matrix3d matrix3d) {
        this.copy(matrix3d);
    }

    public Matrix3d(Matrix3f matrix3f) {
        this.copy(matrix3f);
    }

    public void copy(Matrix3d matrix3d) {
        if (null == matrix3d) {
            this.loadIdentity();
        } else {
            this.m00 = matrix3d.m00;
            this.m01 = matrix3d.m01;
            this.m02 = matrix3d.m02;
            this.m10 = matrix3d.m10;
            this.m11 = matrix3d.m11;
            this.m12 = matrix3d.m12;
            this.m20 = matrix3d.m20;
            this.m21 = matrix3d.m21;
            this.m22 = matrix3d.m22;
        }
    }

    public void copy(Matrix3f matrix3f) {
        if (null == matrix3f) {
            this.loadIdentity();
        } else {
            this.m00 = matrix3f.m00;
            this.m01 = matrix3f.m01;
            this.m02 = matrix3f.m02;
            this.m10 = matrix3f.m10;
            this.m11 = matrix3f.m11;
            this.m12 = matrix3f.m12;
            this.m20 = matrix3f.m20;
            this.m21 = matrix3f.m21;
            this.m22 = matrix3f.m22;
        }
    }

    public Matrix3f toMatrix3f(Matrix3f matrix3f) {
        if (matrix3f == null) {
            matrix3f = new Matrix3f();
        }
        matrix3f.m00 = (float)this.m00;
        matrix3f.m01 = (float)this.m01;
        matrix3f.m02 = (float)this.m02;
        matrix3f.m10 = (float)this.m10;
        matrix3f.m11 = (float)this.m11;
        matrix3f.m12 = (float)this.m12;
        matrix3f.m20 = (float)this.m20;
        matrix3f.m21 = (float)this.m21;
        matrix3f.m22 = (float)this.m22;
        return matrix3f;
    }

    public double get(int n, int n2) {
        switch (n) {
            case 0: {
                switch (n2) {
                    case 0: {
                        return this.m00;
                    }
                    case 1: {
                        return this.m01;
                    }
                    case 2: {
                        return this.m02;
                    }
                }
            }
            case 1: {
                switch (n2) {
                    case 0: {
                        return this.m10;
                    }
                    case 1: {
                        return this.m11;
                    }
                    case 2: {
                        return this.m12;
                    }
                }
            }
            case 2: {
                switch (n2) {
                    case 0: {
                        return this.m20;
                    }
                    case 1: {
                        return this.m21;
                    }
                    case 2: {
                        return this.m22;
                    }
                }
            }
        }
        logger.warning("Invalid matrix index.");
        throw new JmeException("Invalid indices into matrix.");
    }

    public Vector3d getColumn(int n) {
        return this.getColumn(n, null);
    }

    public Vector3d getColumn(int n, Vector3d vector3d) {
        if (vector3d == null) {
            vector3d = new Vector3d();
        }
        switch (n) {
            case 0: {
                vector3d.x = this.m00;
                vector3d.y = this.m10;
                vector3d.z = this.m20;
                break;
            }
            case 1: {
                vector3d.x = this.m01;
                vector3d.y = this.m11;
                vector3d.z = this.m21;
                break;
            }
            case 2: {
                vector3d.x = this.m02;
                vector3d.y = this.m12;
                vector3d.z = this.m22;
                break;
            }
            default: {
                logger.warning("Invalid column index.");
                throw new JmeException("Invalid column index. " + n);
            }
        }
        return vector3d;
    }

    public Vector3d getRow(int n) {
        return this.getRow(n, null);
    }

    public Vector3d getRow(int n, Vector3d vector3d) {
        if (vector3d == null) {
            vector3d = new Vector3d();
        }
        switch (n) {
            case 0: {
                vector3d.x = this.m00;
                vector3d.y = this.m01;
                vector3d.z = this.m02;
                break;
            }
            case 1: {
                vector3d.x = this.m10;
                vector3d.y = this.m11;
                vector3d.z = this.m12;
                break;
            }
            case 2: {
                vector3d.x = this.m20;
                vector3d.y = this.m21;
                vector3d.z = this.m22;
                break;
            }
            default: {
                logger.warning("Invalid row index.");
                throw new JmeException("Invalid row index. " + n);
            }
        }
        return vector3d;
    }

    public DoubleBuffer toDoubleBuffer() {
        DoubleBuffer doubleBuffer = BufferUtils.createDoubleBuffer(9);
        doubleBuffer.put(this.m00).put(this.m01).put(this.m02);
        doubleBuffer.put(this.m10).put(this.m11).put(this.m12);
        doubleBuffer.put(this.m20).put(this.m21).put(this.m22);
        doubleBuffer.rewind();
        return doubleBuffer;
    }

    public DoubleBuffer fillDoubleBuffer(DoubleBuffer doubleBuffer) {
        doubleBuffer.clear();
        doubleBuffer.put(this.m00).put(this.m01).put(this.m02);
        doubleBuffer.put(this.m10).put(this.m11).put(this.m12);
        doubleBuffer.put(this.m20).put(this.m21).put(this.m22);
        doubleBuffer.rewind();
        return doubleBuffer;
    }

    public void setColumn(int n, Vector3d vector3d) {
        if (vector3d == null) {
            logger.warning("Column is null. Ignoring.");
            return;
        }
        switch (n) {
            case 0: {
                this.m00 = vector3d.x;
                this.m10 = vector3d.y;
                this.m20 = vector3d.z;
                break;
            }
            case 1: {
                this.m01 = vector3d.x;
                this.m11 = vector3d.y;
                this.m21 = vector3d.z;
                break;
            }
            case 2: {
                this.m02 = vector3d.x;
                this.m12 = vector3d.y;
                this.m22 = vector3d.z;
                break;
            }
            default: {
                logger.warning("Invalid column index.");
                throw new JmeException("Invalid column index. " + n);
            }
        }
    }

    public void setRow(int n, Vector3d vector3d) {
        if (vector3d == null) {
            logger.warning("Row is null. Ignoring.");
            return;
        }
        switch (n) {
            case 0: {
                this.m00 = vector3d.x;
                this.m01 = vector3d.y;
                this.m02 = vector3d.z;
                break;
            }
            case 1: {
                this.m10 = vector3d.x;
                this.m11 = vector3d.y;
                this.m12 = vector3d.z;
                break;
            }
            case 2: {
                this.m20 = vector3d.x;
                this.m21 = vector3d.y;
                this.m22 = vector3d.z;
                break;
            }
            default: {
                logger.warning("Invalid row index.");
                throw new JmeException("Invalid row index. " + n);
            }
        }
    }

    public void set(int n, int n2, double d) {
        switch (n) {
            case 0: {
                switch (n2) {
                    case 0: {
                        this.m00 = d;
                        return;
                    }
                    case 1: {
                        this.m01 = d;
                        return;
                    }
                    case 2: {
                        this.m02 = d;
                        return;
                    }
                }
            }
            case 1: {
                switch (n2) {
                    case 0: {
                        this.m10 = d;
                        return;
                    }
                    case 1: {
                        this.m11 = d;
                        return;
                    }
                    case 2: {
                        this.m12 = d;
                        return;
                    }
                }
            }
            case 2: {
                switch (n2) {
                    case 0: {
                        this.m20 = d;
                        return;
                    }
                    case 1: {
                        this.m21 = d;
                        return;
                    }
                    case 2: {
                        this.m22 = d;
                        return;
                    }
                }
            }
        }
        logger.warning("Invalid matrix index.");
        throw new JmeException("Invalid indices into matrix.");
    }

    public void set(double[][] dArray) {
        if (dArray.length != 3 || dArray[0].length != 3) {
            throw new JmeException("Array must be of size 9.");
        }
        this.m00 = dArray[0][0];
        this.m01 = dArray[0][1];
        this.m02 = dArray[0][2];
        this.m10 = dArray[1][0];
        this.m11 = dArray[1][1];
        this.m12 = dArray[1][2];
        this.m20 = dArray[2][0];
        this.m21 = dArray[2][1];
        this.m22 = dArray[2][2];
    }

    public void fromAxes(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3) {
        this.m00 = vector3d.x;
        this.m10 = vector3d.y;
        this.m20 = vector3d.z;
        this.m01 = vector3d2.x;
        this.m11 = vector3d2.y;
        this.m21 = vector3d2.z;
        this.m02 = vector3d3.x;
        this.m12 = vector3d3.y;
        this.m22 = vector3d3.z;
    }

    public void set(double[] dArray) {
        this.set(dArray, true);
    }

    public void set(double[] dArray, boolean bl) {
        if (dArray.length != 9) {
            throw new JmeException("Array must be of size 9.");
        }
        if (bl) {
            this.m00 = dArray[0];
            this.m01 = dArray[1];
            this.m02 = dArray[2];
            this.m10 = dArray[3];
            this.m11 = dArray[4];
            this.m12 = dArray[5];
            this.m20 = dArray[6];
            this.m21 = dArray[7];
            this.m22 = dArray[8];
        } else {
            this.m00 = dArray[0];
            this.m01 = dArray[3];
            this.m02 = dArray[6];
            this.m10 = dArray[1];
            this.m11 = dArray[4];
            this.m12 = dArray[7];
            this.m20 = dArray[2];
            this.m21 = dArray[5];
            this.m22 = dArray[8];
        }
    }

    public void set(Quaternion quaternion) {
        quaternion.toRotationMatrix(this);
    }

    public void loadIdentity() {
        this.m21 = 0.0;
        this.m20 = 0.0;
        this.m12 = 0.0;
        this.m10 = 0.0;
        this.m02 = 0.0;
        this.m01 = 0.0;
        this.m22 = 1.0;
        this.m11 = 1.0;
        this.m00 = 1.0;
    }

    public boolean isIdentity() {
        return this.m00 == 1.0 && this.m01 == 0.0 && this.m02 == 0.0 && this.m10 == 0.0 && this.m11 == 1.0 && this.m12 == 0.0 && this.m20 == 0.0 && this.m21 == 0.0 && this.m22 == 1.0;
    }

    public void fromAngleAxis(double d, Vector3d vector3d) {
        Vector3d vector3d2 = vector3d.normalize();
        this.fromAngleNormalAxis(d, vector3d2);
    }

    public void fromAngleNormalAxis(double d, Vector3d vector3d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double d4 = 1.0 - d2;
        double d5 = vector3d.x * vector3d.x;
        double d6 = vector3d.y * vector3d.y;
        double d7 = vector3d.z * vector3d.z;
        double d8 = vector3d.x * vector3d.y * d4;
        double d9 = vector3d.x * vector3d.z * d4;
        double d10 = vector3d.y * vector3d.z * d4;
        double d11 = vector3d.x * d3;
        double d12 = vector3d.y * d3;
        double d13 = vector3d.z * d3;
        this.m00 = d5 * d4 + d2;
        this.m01 = d8 - d13;
        this.m02 = d9 + d12;
        this.m10 = d8 + d13;
        this.m11 = d6 * d4 + d2;
        this.m12 = d10 - d11;
        this.m20 = d9 - d12;
        this.m21 = d10 + d11;
        this.m22 = d7 * d4 + d2;
    }

    public Matrix3d mult(Matrix3d matrix3d) {
        return this.mult(matrix3d, null);
    }

    public Matrix3d mult(Matrix3d matrix3d, Matrix3d matrix3d2) {
        if (matrix3d2 == null) {
            matrix3d2 = new Matrix3d();
        }
        double d = this.m00 * matrix3d.m00 + this.m01 * matrix3d.m10 + this.m02 * matrix3d.m20;
        double d2 = this.m00 * matrix3d.m01 + this.m01 * matrix3d.m11 + this.m02 * matrix3d.m21;
        double d3 = this.m00 * matrix3d.m02 + this.m01 * matrix3d.m12 + this.m02 * matrix3d.m22;
        double d4 = this.m10 * matrix3d.m00 + this.m11 * matrix3d.m10 + this.m12 * matrix3d.m20;
        double d5 = this.m10 * matrix3d.m01 + this.m11 * matrix3d.m11 + this.m12 * matrix3d.m21;
        double d6 = this.m10 * matrix3d.m02 + this.m11 * matrix3d.m12 + this.m12 * matrix3d.m22;
        double d7 = this.m20 * matrix3d.m00 + this.m21 * matrix3d.m10 + this.m22 * matrix3d.m20;
        double d8 = this.m20 * matrix3d.m01 + this.m21 * matrix3d.m11 + this.m22 * matrix3d.m21;
        double d9 = this.m20 * matrix3d.m02 + this.m21 * matrix3d.m12 + this.m22 * matrix3d.m22;
        matrix3d2.m00 = d;
        matrix3d2.m01 = d2;
        matrix3d2.m02 = d3;
        matrix3d2.m10 = d4;
        matrix3d2.m11 = d5;
        matrix3d2.m12 = d6;
        matrix3d2.m20 = d7;
        matrix3d2.m21 = d8;
        matrix3d2.m22 = d9;
        return matrix3d2;
    }

    public Vector3d mult(Vector3d vector3d) {
        return this.mult(vector3d, null);
    }

    public Vector3d mult(Vector3d vector3d, Vector3d vector3d2) {
        if (null == vector3d2) {
            vector3d2 = new Vector3d();
        }
        double d = vector3d.x;
        double d2 = vector3d.y;
        double d3 = vector3d.z;
        vector3d2.x = this.m00 * d + this.m01 * d2 + this.m02 * d3;
        vector3d2.y = this.m10 * d + this.m11 * d2 + this.m12 * d3;
        vector3d2.z = this.m20 * d + this.m21 * d2 + this.m22 * d3;
        return vector3d2;
    }

    public Matrix3d multLocal(double d) {
        this.m00 *= d;
        this.m01 *= d;
        this.m02 *= d;
        this.m10 *= d;
        this.m11 *= d;
        this.m12 *= d;
        this.m20 *= d;
        this.m21 *= d;
        this.m22 *= d;
        return this;
    }

    public Vector3d multLocal(Vector3d vector3d) {
        if (vector3d == null) {
            return null;
        }
        double d = vector3d.x;
        double d2 = vector3d.y;
        vector3d.x = this.m00 * d + this.m01 * d2 + this.m02 * vector3d.z;
        vector3d.y = this.m10 * d + this.m11 * d2 + this.m12 * vector3d.z;
        vector3d.z = this.m20 * d + this.m21 * d2 + this.m22 * vector3d.z;
        return vector3d;
    }

    public Matrix3d multLocal(Matrix3d matrix3d) {
        return this.mult(matrix3d, this);
    }

    public Matrix3d transposeLocal() {
        double d = this.m01;
        this.m01 = this.m10;
        this.m10 = d;
        d = this.m02;
        this.m02 = this.m20;
        this.m20 = d;
        d = this.m21;
        this.m21 = this.m12;
        this.m12 = d;
        return this;
    }

    public Matrix3d invert() {
        return this.invert(null);
    }

    public Matrix3d invert(Matrix3d matrix3d) {
        double d;
        if (matrix3d == null) {
            matrix3d = new Matrix3d();
        }
        if (Math.abs(d = this.determinant()) <= 2.220446049250313E-16) {
            return matrix3d.zero();
        }
        matrix3d.m00 = this.m11 * this.m22 - this.m12 * this.m21;
        matrix3d.m01 = this.m02 * this.m21 - this.m01 * this.m22;
        matrix3d.m02 = this.m01 * this.m12 - this.m02 * this.m11;
        matrix3d.m10 = this.m12 * this.m20 - this.m10 * this.m22;
        matrix3d.m11 = this.m00 * this.m22 - this.m02 * this.m20;
        matrix3d.m12 = this.m02 * this.m10 - this.m00 * this.m12;
        matrix3d.m20 = this.m10 * this.m21 - this.m11 * this.m20;
        matrix3d.m21 = this.m01 * this.m20 - this.m00 * this.m21;
        matrix3d.m22 = this.m00 * this.m11 - this.m01 * this.m10;
        matrix3d.multLocal(1.0 / d);
        return matrix3d;
    }

    public Matrix3d invertLocal() {
        double d = this.determinant();
        if (Math.abs(d) <= 2.220446049250313E-16) {
            return this.zero();
        }
        double d2 = this.m11 * this.m22 - this.m12 * this.m21;
        double d3 = this.m02 * this.m21 - this.m01 * this.m22;
        double d4 = this.m01 * this.m12 - this.m02 * this.m11;
        double d5 = this.m12 * this.m20 - this.m10 * this.m22;
        double d6 = this.m00 * this.m22 - this.m02 * this.m20;
        double d7 = this.m02 * this.m10 - this.m00 * this.m12;
        double d8 = this.m10 * this.m21 - this.m11 * this.m20;
        double d9 = this.m01 * this.m20 - this.m00 * this.m21;
        double d10 = this.m00 * this.m11 - this.m01 * this.m10;
        this.m00 = d2;
        this.m01 = d3;
        this.m02 = d4;
        this.m10 = d5;
        this.m11 = d6;
        this.m12 = d7;
        this.m20 = d8;
        this.m21 = d9;
        this.m22 = d10;
        this.multLocal(1.0 / d);
        return this;
    }

    public Matrix3d adjoint() {
        return this.adjoint(null);
    }

    public Matrix3d adjoint(Matrix3d matrix3d) {
        if (matrix3d == null) {
            matrix3d = new Matrix3d();
        }
        matrix3d.m00 = this.m11 * this.m22 - this.m12 * this.m21;
        matrix3d.m01 = this.m02 * this.m21 - this.m01 * this.m22;
        matrix3d.m02 = this.m01 * this.m12 - this.m02 * this.m11;
        matrix3d.m10 = this.m12 * this.m20 - this.m10 * this.m22;
        matrix3d.m11 = this.m00 * this.m22 - this.m02 * this.m20;
        matrix3d.m12 = this.m02 * this.m10 - this.m00 * this.m12;
        matrix3d.m20 = this.m10 * this.m21 - this.m11 * this.m20;
        matrix3d.m21 = this.m01 * this.m20 - this.m00 * this.m21;
        matrix3d.m22 = this.m00 * this.m11 - this.m01 * this.m10;
        return matrix3d;
    }

    public double determinant() {
        double d = this.m11 * this.m22 - this.m12 * this.m21;
        double d2 = this.m12 * this.m20 - this.m10 * this.m22;
        double d3 = this.m10 * this.m21 - this.m11 * this.m20;
        double d4 = this.m00 * d + this.m01 * d2 + this.m02 * d3;
        return d4;
    }

    public Matrix3d zero() {
        this.m22 = 0.0;
        this.m21 = 0.0;
        this.m20 = 0.0;
        this.m12 = 0.0;
        this.m11 = 0.0;
        this.m10 = 0.0;
        this.m02 = 0.0;
        this.m01 = 0.0;
        this.m00 = 0.0;
        return this;
    }

    public void add(Matrix3d matrix3d) {
        this.m00 += matrix3d.m00;
        this.m01 += matrix3d.m01;
        this.m02 += matrix3d.m02;
        this.m10 += matrix3d.m10;
        this.m11 += matrix3d.m11;
        this.m12 += matrix3d.m12;
        this.m20 += matrix3d.m20;
        this.m21 += matrix3d.m21;
        this.m22 += matrix3d.m22;
    }

    public Matrix3d transpose() {
        double d = 0.0;
        d = this.m01;
        this.m01 = this.m10;
        this.m10 = d;
        d = this.m02;
        this.m02 = this.m20;
        this.m20 = d;
        d = this.m12;
        this.m12 = this.m21;
        this.m21 = d;
        return this;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("com.jme.math.Matrix3d\n[\n");
        stringBuffer.append(" ");
        stringBuffer.append(this.m00);
        stringBuffer.append("  ");
        stringBuffer.append(this.m01);
        stringBuffer.append("  ");
        stringBuffer.append(this.m02);
        stringBuffer.append(" \n");
        stringBuffer.append(" ");
        stringBuffer.append(this.m10);
        stringBuffer.append("  ");
        stringBuffer.append(this.m11);
        stringBuffer.append("  ");
        stringBuffer.append(this.m12);
        stringBuffer.append(" \n");
        stringBuffer.append(" ");
        stringBuffer.append(this.m20);
        stringBuffer.append("  ");
        stringBuffer.append(this.m21);
        stringBuffer.append("  ");
        stringBuffer.append(this.m22);
        stringBuffer.append(" \n]");
        return stringBuffer.toString();
    }

    public int hashCode() {
        long l = 37L;
        l = 37L * l + Double.doubleToLongBits(this.m00);
        l = 37L * l + Double.doubleToLongBits(this.m01);
        l = 37L * l + Double.doubleToLongBits(this.m02);
        l = 37L * l + Double.doubleToLongBits(this.m10);
        l = 37L * l + Double.doubleToLongBits(this.m11);
        l = 37L * l + Double.doubleToLongBits(this.m12);
        l = 37L * l + Double.doubleToLongBits(this.m20);
        l = 37L * l + Double.doubleToLongBits(this.m21);
        l = 37L * l + Double.doubleToLongBits(this.m22);
        return (int)l;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Matrix3d) || object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        Matrix3d matrix3d = (Matrix3d)object;
        if (Double.compare(this.m00, matrix3d.m00) != 0) {
            return false;
        }
        if (Double.compare(this.m01, matrix3d.m01) != 0) {
            return false;
        }
        if (Double.compare(this.m02, matrix3d.m02) != 0) {
            return false;
        }
        if (Double.compare(this.m10, matrix3d.m10) != 0) {
            return false;
        }
        if (Double.compare(this.m11, matrix3d.m11) != 0) {
            return false;
        }
        if (Double.compare(this.m12, matrix3d.m12) != 0) {
            return false;
        }
        if (Double.compare(this.m20, matrix3d.m20) != 0) {
            return false;
        }
        if (Double.compare(this.m21, matrix3d.m21) != 0) {
            return false;
        }
        return Double.compare(this.m22, matrix3d.m22) == 0;
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.m00, "m00", 1.0);
        outputCapsule.write(this.m01, "m01", 0.0);
        outputCapsule.write(this.m02, "m02", 0.0);
        outputCapsule.write(this.m10, "m10", 0.0);
        outputCapsule.write(this.m11, "m11", 1.0);
        outputCapsule.write(this.m12, "m12", 0.0);
        outputCapsule.write(this.m20, "m20", 0.0);
        outputCapsule.write(this.m21, "m21", 0.0);
        outputCapsule.write(this.m22, "m22", 1.0);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.m00 = inputCapsule.readDouble("m00", 1.0);
        this.m01 = inputCapsule.readDouble("m01", 0.0);
        this.m02 = inputCapsule.readDouble("m02", 0.0);
        this.m10 = inputCapsule.readDouble("m10", 0.0);
        this.m11 = inputCapsule.readDouble("m11", 1.0);
        this.m12 = inputCapsule.readDouble("m12", 0.0);
        this.m20 = inputCapsule.readDouble("m20", 0.0);
        this.m21 = inputCapsule.readDouble("m21", 0.0);
        this.m22 = inputCapsule.readDouble("m22", 1.0);
    }

    public Class getClassTag() {
        return this.getClass();
    }

    public void fromStartEndVectors(Vector3d vector3d, Vector3d vector3d2) {
        double d;
        Vector3d vector3d3 = new Vector3d();
        vector3d.cross(vector3d2, vector3d3);
        double d2 = vector3d.dot(vector3d2);
        double d3 = d = d2 < 0.0 ? -d2 : d2;
        if (d > 1.0) {
            Vector3d vector3d4 = new Vector3d();
            Vector3d vector3d5 = new Vector3d();
            vector3d5.x = vector3d.x > 0.0 ? vector3d.x : -vector3d.x;
            vector3d5.y = vector3d.y > 0.0 ? vector3d.y : -vector3d.y;
            double d4 = vector3d5.z = vector3d.z > 0.0 ? vector3d.z : -vector3d.z;
            if (vector3d5.x < vector3d5.y) {
                if (vector3d5.x < vector3d5.z) {
                    vector3d5.x = 1.0;
                    vector3d5.z = 0.0;
                    vector3d5.y = 0.0;
                } else {
                    vector3d5.z = 1.0;
                    vector3d5.y = 0.0;
                    vector3d5.x = 0.0;
                }
            } else if (vector3d5.y < vector3d5.z) {
                vector3d5.y = 1.0;
                vector3d5.z = 0.0;
                vector3d5.x = 0.0;
            } else {
                vector3d5.z = 1.0;
                vector3d5.y = 0.0;
                vector3d5.x = 0.0;
            }
            vector3d4.x = vector3d5.x - vector3d.x;
            vector3d4.y = vector3d5.y - vector3d.y;
            vector3d4.z = vector3d5.z - vector3d.z;
            vector3d3.x = vector3d5.x - vector3d2.x;
            vector3d3.y = vector3d5.y - vector3d2.y;
            vector3d3.z = vector3d5.z - vector3d2.z;
            double d5 = 2.0 / vector3d4.dot(vector3d4);
            double d6 = 2.0 / vector3d3.dot(vector3d3);
            double d7 = d5 * d6 * vector3d4.dot(vector3d3);
            for (int i = 0; i < 3; ++i) {
                double d8;
                for (int j = 0; j < 3; ++j) {
                    d8 = -d5 * vector3d4.get(i) * vector3d4.get(j) - d6 * vector3d3.get(i) * vector3d3.get(j) + d7 * vector3d3.get(i) * vector3d4.get(j);
                    this.set(i, j, d8);
                }
                d8 = this.get(i, i);
                this.set(i, i, d8 + 1.0);
            }
        } else {
            double d9 = 1.0 / (1.0 + d2);
            double d10 = d9 * vector3d3.x;
            double d11 = d9 * vector3d3.z;
            double d12 = d10 * vector3d3.y;
            double d13 = d10 * vector3d3.z;
            double d14 = d11 * vector3d3.y;
            this.set(0, 0, d2 + d10 * vector3d3.x);
            this.set(0, 1, d12 - vector3d3.z);
            this.set(0, 2, d13 + vector3d3.y);
            this.set(1, 0, d12 + vector3d3.z);
            this.set(1, 1, d2 + d9 * vector3d3.y * vector3d3.y);
            this.set(1, 2, d14 - vector3d3.x);
            this.set(2, 0, d13 - vector3d3.y);
            this.set(2, 1, d14 + vector3d3.x);
            this.set(2, 2, d2 + d11 * vector3d3.z);
        }
    }
}

