/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.utils.controllers;

import com.jme.math.Vector3f;
import com.jme.scene.Spatial;
import com.turborilla.utils.controllers.AbstractSpatialController;
import java.util.ArrayList;

public class SpatialTranslationController
extends AbstractSpatialController {
    private ArrayList<TranslationInfo> translationQueue;
    private TranslationInfo currentTranslation = null;
    private TranslationInfo remainingTranslation = null;
    private int currentTranslationIndex = -1;
    private float curTime = 0.0f;
    private boolean inReverse = false;
    private Vector3f position = new Vector3f();
    private boolean snapToWholePixels = true;
    private Vector3f speed = new Vector3f();
    private Vector3f deltaSpeed = new Vector3f();
    private float damping = 0.08f;
    private Vector3f averageSpeedNeeded = new Vector3f();

    public SpatialTranslationController(Spatial spatial) {
        super(spatial);
        this.translationQueue = new ArrayList();
        this.position.set(spatial.getLocalTranslation());
    }

    public void update(float f) {
        if (f > 0.04f) {
            f = 0.04f;
        }
        if (this.currentTranslation == null) {
            this.currentTranslation = this.getNextTranslation();
        }
        if (this.currentTranslation != null) {
            boolean bl = false;
            this.curTime += f;
            if (this.curTime > this.currentTranslation.minimumTimeBeforeNextTarget) {
                bl = true;
            } else if (!this.inReverse) {
                this.doTranslation(this.currentTranslation.finalPosition, this.currentTranslation.invTime, f);
            } else {
                this.doTranslation(this.currentTranslation.beginPosition, this.currentTranslation.invTime, f);
            }
            this.applyPosition();
            if (bl) {
                this.remainingTranslation = this.currentTranslation;
                this.currentTranslation = this.getNextTranslation();
                if (this.currentTranslation == null && this.remainingTranslation == null) {
                    this.done();
                    this.snapToWholePixels();
                }
            }
        } else if (this.remainingTranslation != null) {
            boolean bl = false;
            bl = !this.inReverse ? this.doTranslation(this.remainingTranslation.finalPosition, this.remainingTranslation.invTime, f) : this.doTranslation(this.remainingTranslation.beginPosition, this.remainingTranslation.invTime, f);
            this.applyPosition();
            if (bl) {
                this.done();
                this.remainingTranslation = null;
                this.snapToWholePixels();
            }
        }
    }

    private void snapToWholePixels() {
        if (this.snapToWholePixels) {
            Vector3f vector3f = this.getSpatial().getLocalTranslation();
            vector3f.x = Math.round(vector3f.x);
            vector3f.y = Math.round(vector3f.y);
            vector3f.z = Math.round(vector3f.z);
        }
    }

    private boolean doTranslation(Vector3f vector3f, float f, float f2) {
        this.recalcAverageSpeed(vector3f, f);
        this.deltaSpeed.set(this.averageSpeedNeeded).multLocal(2.0f).subtractLocal(this.speed);
        this.deltaSpeed.multLocal(f2);
        this.averageSpeedNeeded.set(this.speed);
        this.deltaSpeed.subtractLocal(this.averageSpeedNeeded.multLocal(this.damping));
        this.speed.addLocal(this.deltaSpeed);
        this.position.addLocal(this.speed);
        return this.speed.lengthSquared() < 1.0E-4f && this.deltaSpeed.lengthSquared() < 1.0E-4f;
    }

    private void clamp(Vector3f vector3f, float f) {
        if (vector3f.x > f) {
            vector3f.x = f;
        } else if (vector3f.x < -f) {
            vector3f.x = -f;
        }
        if (vector3f.y > f) {
            vector3f.y = f;
        } else if (vector3f.y < -f) {
            vector3f.y = -f;
        }
        if (vector3f.z > f) {
            vector3f.z = f;
        } else if (vector3f.z < -f) {
            vector3f.z = -f;
        }
    }

    private void recalcAverageSpeed(Vector3f vector3f, float f) {
        this.averageSpeedNeeded.set(vector3f).subtractLocal(this.position);
        this.averageSpeedNeeded.multLocal(f);
    }

    public void setPosition(Vector3f vector3f) {
        this.position.set(vector3f);
        this.applyPosition();
        this.snapToWholePixels();
    }

    public void setPosition(float f, float f2, float f3) {
        this.position.set(f, f2, f3);
        this.applyPosition();
        this.snapToWholePixels();
    }

    public void translateTo(Vector3f vector3f, float f, float f2) {
        this.translate(null, vector3f, f, f2);
    }

    public void translate(Vector3f vector3f, Vector3f vector3f2, float f, float f2) {
        this.clearTranslationQueue();
        this.addTranslationToQueue(vector3f, vector3f2, f, f2);
    }

    public void addTranslationToQueue(Vector3f vector3f, float f, float f2) {
        this.addTranslationToQueue(null, vector3f, f, f2);
    }

    public void addTranslationToQueue(Vector3f vector3f, Vector3f vector3f2, float f, float f2) {
        TranslationInfo translationInfo = new TranslationInfo();
        if (vector3f != null) {
            translationInfo.beginPosition = new Vector3f(vector3f);
        }
        if (vector3f2 != null) {
            translationInfo.finalPosition = new Vector3f(vector3f2);
        }
        translationInfo.time = f;
        translationInfo.invTime = 1.0f / f;
        translationInfo.minimumTimeBeforeNextTarget = f2;
        if (translationInfo.beginPosition == null) {
            translationInfo.beginPosition = this.translationQueue.size() > 0 ? new Vector3f(this.translationQueue.get((int)(this.translationQueue.size() - 1)).finalPosition) : new Vector3f(this.position);
        }
        this.translationQueue.add(translationInfo);
    }

    public void clearTranslationQueue() {
        this.translationQueue.clear();
        this.inReverse = false;
        this.currentTranslation = null;
        this.currentTranslationIndex = -1;
        this.remainingTranslation = null;
    }

    public boolean isTranslating() {
        return this.currentTranslation != null;
    }

    public void restart() {
        this.currentTranslationIndex = -1;
        this.curTime = 0.0f;
        this.currentTranslation = null;
        this.inReverse = false;
    }

    public void setRepeatType(int n) {
        super.setRepeatType(n);
        this.inReverse = false;
    }

    private void applyPosition() {
        this.getSpatial().getLocalTranslation().set(this.position);
    }

    private TranslationInfo getNextTranslation() {
        if (this.translationQueue.size() <= 0) {
            return null;
        }
        if (this.getRepeatType() == 0 && this.currentTranslationIndex + 1 >= this.translationQueue.size()) {
            return null;
        }
        this.curTime = 0.0f;
        if (this.currentTranslationIndex == -1) {
            this.currentTranslationIndex = 0;
        } else {
            this.currentTranslationIndex = !this.inReverse ? ++this.currentTranslationIndex : --this.currentTranslationIndex;
            if (this.currentTranslationIndex >= this.translationQueue.size()) {
                if (this.getRepeatType() == 2) {
                    this.currentTranslationIndex = this.translationQueue.size() - 1;
                    this.inReverse = true;
                } else if (this.getRepeatType() == 1) {
                    this.currentTranslationIndex = 0;
                    this.inReverse = false;
                }
            } else if (this.currentTranslationIndex < 0) {
                this.currentTranslationIndex = 0;
                this.inReverse = false;
            }
        }
        return this.translationQueue.get(this.currentTranslationIndex);
    }

    public float getDamping() {
        return this.damping;
    }

    public void setDamping(float f) {
        this.damping = f;
    }

    public boolean isSnapToWholePixels() {
        return this.snapToWholePixels;
    }

    public void setSnapToWholePixels(boolean bl) {
        this.snapToWholePixels = bl;
    }

    private class TranslationInfo {
        Vector3f beginPosition = null;
        Vector3f finalPosition = null;
        float time;
        float invTime;
        float minimumTimeBeforeNextTarget;

        private TranslationInfo() {
        }

        public TranslationInfo copy(TranslationInfo translationInfo) {
            this.beginPosition = translationInfo.beginPosition;
            this.finalPosition = translationInfo.finalPosition;
            this.time = translationInfo.time;
            this.invTime = translationInfo.invTime;
            this.minimumTimeBeforeNextTarget = translationInfo.minimumTimeBeforeNextTarget;
            return this;
        }
    }
}

