/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.utils.controllers;

import com.jme.renderer.ColorRGBA;
import com.jme.scene.Spatial;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.LightState;
import com.jme.scene.state.MaterialState;
import com.jme.system.DisplaySystem;
import com.turborilla.utils.controllers.AbstractSpatialController;
import java.util.ArrayList;

public class SpatialFadeController
extends AbstractSpatialController {
    private ColorRGBA color = new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
    private FadeInfo currentFade = null;
    private int currentFadeIndex = -1;
    private float curFadeTime = 0.0f;
    private MaterialState material = DisplaySystem.getDisplaySystem().getRenderer().createMaterialState();
    private boolean inReverse = false;
    private ArrayList<FadeInfo> fadeQueue;

    public SpatialFadeController(Spatial spatial) {
        super(spatial);
        this.material.setEnabled(true);
        this.material.setEmissive(this.color);
        this.material.setDiffuse(this.color);
        this.getSpatial().setRenderState(this.material);
        this.getSpatial().updateRenderState();
        this.applyColor();
        this.fadeQueue = new ArrayList();
    }

    public void update(float f) {
        if (this.currentFade == null) {
            this.currentFade = this.getNextFade();
        }
        if (this.currentFade != null) {
            boolean bl = false;
            this.curFadeTime += f;
            if (this.curFadeTime > this.currentFade.fadeTime) {
                bl = true;
                if (!this.inReverse) {
                    this.color.set(this.currentFade.finalColor);
                } else {
                    this.color.set(this.currentFade.beginColor);
                }
            } else if (!this.inReverse) {
                this.color.interpolate(this.currentFade.beginColor, this.currentFade.finalColor, this.curFadeTime * this.currentFade.invFadeTime);
            } else {
                this.color.interpolate(this.currentFade.finalColor, this.currentFade.beginColor, this.curFadeTime * this.currentFade.invFadeTime);
            }
            this.applyColor();
            if (bl) {
                this.currentFade = this.getNextFade();
                if (this.currentFade == null) {
                    this.done();
                }
            }
        }
    }

    public void initRenderStates() {
        this.getSpatial().setLightCombineMode(5);
        AlphaState alphaState = DisplaySystem.getDisplaySystem().getRenderer().createAlphaState();
        alphaState.setBlendEnabled(true);
        alphaState.setSrcFunction(4);
        alphaState.setDstFunction(5);
        this.getSpatial().setRenderState(alphaState);
        LightState lightState = DisplaySystem.getDisplaySystem().getRenderer().createLightState();
        lightState.setEnabled(true);
        this.getSpatial().setRenderState(lightState);
        this.getSpatial().updateRenderState();
    }

    public void setColor(ColorRGBA colorRGBA) {
        this.setColor(colorRGBA.r, colorRGBA.g, colorRGBA.b, colorRGBA.a);
    }

    public void setColor(float f, float f2, float f3, float f4) {
        this.color.set(f, f2, f3, f4);
        this.applyColor();
    }

    private void applyColor() {
        this.material.setDiffuse(this.color);
        this.material.setEmissive(this.color);
    }

    public ColorRGBA getColor() {
        return this.color;
    }

    public void fadeTo(ColorRGBA colorRGBA, float f) {
        this.fade(null, colorRGBA, f);
    }

    public void fade(ColorRGBA colorRGBA, ColorRGBA colorRGBA2, float f) {
        this.clearFadeQueue();
        this.addFadeToQueue(colorRGBA, colorRGBA2, f);
    }

    public void addFadeToQueue(ColorRGBA colorRGBA, float f) {
        this.addFadeToQueue(null, colorRGBA, f);
    }

    public void addFadeToQueue(ColorRGBA colorRGBA, ColorRGBA colorRGBA2, float f) {
        FadeInfo fadeInfo = new FadeInfo();
        fadeInfo.beginColor = colorRGBA;
        fadeInfo.finalColor = colorRGBA2;
        fadeInfo.fadeTime = f;
        fadeInfo.invFadeTime = 1.0f / f;
        if (fadeInfo.beginColor == null) {
            fadeInfo.beginColor = this.fadeQueue.size() > 0 ? new ColorRGBA(this.fadeQueue.get((int)(this.fadeQueue.size() - 1)).finalColor) : new ColorRGBA(this.color);
        }
        this.fadeQueue.add(fadeInfo);
    }

    public void clearFadeQueue() {
        this.fadeQueue.clear();
        this.inReverse = false;
        this.currentFade = null;
        this.currentFadeIndex = -1;
    }

    public boolean isFading() {
        return this.currentFade != null;
    }

    public void restart() {
        this.currentFadeIndex = -1;
        this.curFadeTime = 0.0f;
        this.currentFade = null;
        this.inReverse = false;
    }

    public void setRepeatType(int n) {
        super.setRepeatType(n);
        this.inReverse = false;
    }

    private FadeInfo getNextFade() {
        if (this.fadeQueue.size() <= 0) {
            return null;
        }
        if (this.getRepeatType() == 0 && this.currentFadeIndex + 1 >= this.fadeQueue.size()) {
            return null;
        }
        this.curFadeTime = 0.0f;
        if (this.currentFadeIndex == -1) {
            this.currentFadeIndex = 0;
        } else {
            this.currentFadeIndex = !this.inReverse ? ++this.currentFadeIndex : --this.currentFadeIndex;
            if (this.currentFadeIndex >= this.fadeQueue.size()) {
                if (this.getRepeatType() == 2) {
                    this.currentFadeIndex = this.fadeQueue.size() - 1;
                    this.inReverse = true;
                } else if (this.getRepeatType() == 1) {
                    this.currentFadeIndex = 0;
                    this.inReverse = false;
                }
            } else if (this.currentFadeIndex < 0) {
                this.currentFadeIndex = 0;
                this.inReverse = false;
            }
        }
        return this.fadeQueue.get(this.currentFadeIndex);
    }

    private class FadeInfo {
        ColorRGBA beginColor;
        ColorRGBA finalColor;
        float fadeTime;
        float invFadeTime;

        private FadeInfo() {
        }
    }
}

