/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.utils.controllers;

import com.jme.scene.Controller;
import com.jme.scene.Spatial;
import com.turborilla.utils.controllers.IControllerListener;
import java.util.ArrayList;

public abstract class AbstractSpatialController
extends Controller {
    private Spatial spatial;
    private ArrayList<IControllerListener> listeners;

    public AbstractSpatialController(Spatial spatial) {
        this.spatial = spatial;
        if (spatial != null) {
            spatial.addController(this);
        }
        this.listeners = new ArrayList();
    }

    public abstract void update(float var1);

    public abstract void restart();

    protected final void done() {
        IControllerListener[] iControllerListenerArray = this.listeners.toArray(new IControllerListener[0]);
        this.clearListeners();
        for (int i = 0; i < iControllerListenerArray.length; ++i) {
            iControllerListenerArray[i].controllerTaskFinished(this);
        }
    }

    public boolean add(IControllerListener iControllerListener) {
        return this.listeners.add(iControllerListener);
    }

    public void clearListeners() {
        this.listeners.clear();
    }

    public boolean remove(IControllerListener iControllerListener) {
        return this.listeners.remove(iControllerListener);
    }

    public Spatial getSpatial() {
        return this.spatial;
    }

    public void setSpatial(Spatial spatial) {
        this.detachController();
        this.spatial = spatial;
        if (spatial != null) {
            spatial.addController(this);
        }
    }

    public void detachController() {
        if (this.spatial != null) {
            this.spatial.removeController(this);
        }
    }
}

