/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.utils;

import com.turborilla.Updatable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Scheduling
implements Updatable {
    private List<Task> tasks;
    private boolean paused = false;
    ArrayList<Task> tasksToExecute = new ArrayList();

    public Scheduling() {
        this.tasks = new LinkedList<Task>();
    }

    public void add(Runnable runnable, float f) {
        this.tasks.add(new Task(runnable, f));
    }

    public void clearSchedule() {
        this.tasks.clear();
    }

    public void setPaused(boolean bl) {
        this.paused = bl;
    }

    public void update(float f) {
        if (this.paused || this.tasks.isEmpty()) {
            return;
        }
        Iterator<Task> iterator = this.tasks.iterator();
        while (iterator.hasNext()) {
            Task task = iterator.next();
            task.elapsedTime += f;
            if (!(task.elapsedTime >= task.timeFromNow)) continue;
            iterator.remove();
            this.tasksToExecute.add(task);
        }
        for (int i = 0; i < this.tasksToExecute.size(); ++i) {
            this.tasksToExecute.get(i).call();
        }
        this.tasksToExecute.clear();
    }

    public boolean isPaused() {
        return this.paused;
    }

    private class Task {
        public Runnable callAtTime;
        public float timeFromNow;
        public float elapsedTime;

        public Task(Runnable runnable, float f) {
            this.callAtTime = runnable;
            this.timeFromNow = f;
            this.elapsedTime = 0.0f;
        }

        public void call() {
            this.callAtTime.run();
        }
    }
}

