/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.utils;

import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.scene.Node;
import com.jme.scene.TriMesh;
import com.jme.system.dummy.DummyDisplaySystem;
import com.jme.util.export.Savable;
import com.jme.util.export.binary.BinaryExporter;
import com.jme.util.export.binary.BinaryImporter;
import com.jme.util.geom.BufferUtils;
import com.jmex.model.converters.AseToJme;
import com.jmex.model.converters.MilkToJme;
import com.jmex.model.converters.ObjToJme;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ModelFormatConverter {
    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void convert(URL uRL, String string, String string2) throws IOException {
        InputStream inputStream;
        Logger logger = Logger.getLogger(ModelFormatConverter.class.getName());
        try {
            inputStream = uRL.openStream();
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, "Could not load model file: " + uRL.toString());
            throw iOException;
        }
        if (string == null) {
            logger.log(Level.SEVERE, "Must supply type to model converter, e.g. \"ms3d\"");
            return;
        }
        if (string.equals("ms3d")) {
            MilkToJme milkToJme = new MilkToJme();
        } else if (string.equals("obj")) {
            ObjToJme objToJme = new ObjToJme();
        } else {
            if (!string.equals("ase")) {
                logger.log(Level.SEVERE, "Not a recognized model type: " + string);
                throw new IOException("Not a recognized model type: " + string);
            }
            AseToJme aseToJme = new AseToJme();
        }
        try {
            void var5_9;
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            var5_9.convert(inputStream, fileOutputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.log(Level.SEVERE, "FileNotFoundException thrown");
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, "IOException thrown");
            throw iOException;
        }
        logger.log(Level.INFO, "Saved converted model to: " + string2);
        Node node = (Node)BinaryImporter.getInstance().load(new File(string2));
        TriMesh triMesh = (TriMesh)node.getChild(0);
        System.out.println("vertcount: " + triMesh.getBatch(0).getVertexCount());
        System.out.println("facecount: " + triMesh.getBatch(0).getTriangleCount());
        FloatBuffer floatBuffer = triMesh.getVertexBuffer(0);
        FloatBuffer floatBuffer2 = triMesh.getNormalBuffer(0);
        FloatBuffer floatBuffer3 = triMesh.getTextureBuffer(0, 0);
        IntBuffer intBuffer = triMesh.getIndexBuffer(0);
        floatBuffer.rewind();
        floatBuffer2.rewind();
        intBuffer.rewind();
        floatBuffer3.rewind();
        ArrayList<Vector3f> arrayList = new ArrayList<Vector3f>();
        ArrayList<Vector3f> arrayList2 = new ArrayList<Vector3f>();
        ArrayList<Vector2f> arrayList3 = new ArrayList<Vector2f>();
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Vector2f vector2f = new Vector2f();
        Vector3f vector3f3 = new Vector3f(0.01f, 0.01f, 0.01f);
        int n = 0;
        while (true) {
            int n2;
            int n3;
            boolean bl;
            if (n < triMesh.getBatch(0).getVertexCount()) {
                bl = false;
                n3 = -1;
                BufferUtils.populateFromBuffer(vector3f, floatBuffer, n);
            } else {
                floatBuffer = BufferUtils.createVector3Buffer(arrayList.size());
                floatBuffer2 = BufferUtils.createVector3Buffer(arrayList.size());
                floatBuffer3 = BufferUtils.createVector2Buffer(arrayList.size());
                for (n = 0; n < arrayList.size(); ++n) {
                    vector3f = (Vector3f)arrayList.get(n);
                    BufferUtils.setInBuffer(vector3f, floatBuffer, n);
                    vector3f = (Vector3f)arrayList2.get(n);
                    BufferUtils.setInBuffer(vector3f, floatBuffer2, n);
                    vector2f = (Vector2f)arrayList3.get(n);
                    BufferUtils.setInBuffer(vector2f, floatBuffer3, n);
                }
                floatBuffer.flip();
                floatBuffer2.flip();
                floatBuffer3.flip();
                triMesh.reconstruct(floatBuffer, floatBuffer2, null, floatBuffer3, intBuffer);
                triMesh.getBatch(0).setVertexCount(arrayList.size());
                System.out.println("vertcount: " + triMesh.getBatch(0).getVertexCount());
                System.out.println("facecount: " + triMesh.getBatch(0).getTriangleCount());
                n = 0;
                while (true) {
                    if (n >= intBuffer.limit()) {
                        BinaryExporter.getInstance().save((Savable)node, new File(string2));
                        return;
                    }
                    System.out.println(intBuffer.get(n));
                    ++n;
                }
            }
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                vector3f2.set((Vector3f)arrayList.get(n2)).subtractLocal(vector3f);
                if (!(Math.abs(vector3f2.x) < vector3f3.x) || !(Math.abs(vector3f2.y) < vector3f3.y) || !(Math.abs(vector3f2.z) < vector3f3.z)) continue;
                bl = true;
                n3 = n2;
                break;
            }
            if (!bl) {
                Vector3f vector3f4 = new Vector3f(vector3f);
                arrayList.add(vector3f4);
                n3 = arrayList.indexOf(vector3f4);
                Vector3f vector3f5 = new Vector3f();
                BufferUtils.populateFromBuffer(vector3f5, floatBuffer2, n);
                arrayList2.add(vector3f5);
                Vector2f vector2f2 = new Vector2f();
                BufferUtils.populateFromBuffer(vector2f2, floatBuffer3, n);
                arrayList3.add(vector2f2);
            }
            for (n2 = 0; n2 < intBuffer.limit(); ++n2) {
                int n4 = intBuffer.get(n2);
                if (n4 != n) continue;
                intBuffer.put(n2, n3);
            }
            intBuffer.rewind();
            ++n;
        }
    }

    public static void convert(URL uRL, String string) throws IOException {
        String string2 = uRL.getFile().substring(uRL.getFile().lastIndexOf(".") + 1, uRL.getFile().length());
        System.out.println("#" + string2 + "#");
        ModelFormatConverter.convert(uRL, string2, string);
    }

    public static void main(String[] stringArray) throws IOException {
        new DummyDisplaySystem();
        if (stringArray.length < 2) {
            System.out.println("Usage: ModelFormatConverter <infile> [type] <outfile>");
            System.out.println("Example: ModelFormatConverter model.ms3d model.jme");
        } else if (stringArray.length == 2) {
            ModelFormatConverter.convert(ModelFormatConverter.class.getClassLoader().getResource(stringArray[0]), stringArray[1]);
        } else if (stringArray.length > 2) {
            ModelFormatConverter.convert(ModelFormatConverter.class.getClassLoader().getResource(stringArray[0]), stringArray[1], stringArray[2]);
        }
    }
}

