/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.utils;

import com.jme.image.Texture;
import com.jme.util.TextureKey;
import com.jme.util.TextureManager;
import com.jme.util.geom.BufferUtils;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import org.lwjgl.opengl.Util;
import org.lwjgl.util.glu.MipMap;

public class ImageUtils {
    private static byte[][] interPixels = new byte[4][4];
    private static int[] imageFormats = new int[]{6408, 6407, 6408, 6408, 6410, 6407, 6408, 6408, 6408};

    public static com.jme.image.Image[] split(com.jme.image.Image image, int n, int n2, boolean bl) {
        return ImageUtils.split(image, n, n2, bl, null);
    }

    public static com.jme.image.Image[] split(com.jme.image.Image image, int n, int n2, boolean bl, com.jme.image.Image[] imageArray) {
        int n3;
        com.jme.image.Image[] imageArray2;
        int n4 = image.getWidth() / n;
        int n5 = image.getHeight() / n2;
        if (image.getWidth() % n != 0) {
            ++n4;
        }
        if (image.getHeight() % n2 != 0) {
            ++n5;
        }
        if (imageArray != null && imageArray.length == n4 * n5) {
            imageArray2 = imageArray;
        } else {
            imageArray2 = new com.jme.image.Image[n4 * n5];
            if (imageArray != null) {
                for (n3 = 0; n3 < Math.min(imageArray.length, n4 * n5); ++n3) {
                    imageArray2[n3] = imageArray[n3];
                }
            }
        }
        for (n3 = n5 - 1; n3 >= 0; --n3) {
            for (int i = 0; i < n4; ++i) {
                int n6 = n3 * n4 + i;
                imageArray2[n6] = ImageUtils.extractRectangle(image, i * n, n3 * n2, (i + 1) * n - 1, (n3 + 1) * n2 - 1, bl, imageArray2[n6]);
            }
        }
        return imageArray2;
    }

    public static com.jme.image.Image extractRectangle(com.jme.image.Image image, int n, int n2, int n3, int n4, boolean bl) {
        return ImageUtils.extractRectangle(image, n, n2, n3, n4, bl, null);
    }

    public static com.jme.image.Image extractRectangle(com.jme.image.Image image, int n, int n2, int n3, int n4, boolean bl, com.jme.image.Image image2) {
        if (image.getType() != 3 && image.getType() != 1) {
            Logger.getLogger(ImageUtils.class.getName()).severe("Not a RGBA8888 or RGB888 image");
            return null;
        }
        int n5 = image.getType() == 3 ? 4 : 3;
        if (!bl) {
            if (n3 >= image.getWidth()) {
                n3 = image.getWidth() - 1;
            }
            if (n4 >= image.getHeight()) {
                n4 = image.getHeight() - 1;
            }
        }
        int n6 = n3 - n + 1;
        int n7 = n4 - n2 + 1;
        int n8 = image.getWidth();
        int n9 = image.getHeight();
        com.jme.image.Image image3 = null;
        ByteBuffer byteBuffer = null;
        image3 = image2 != null ? image2 : new com.jme.image.Image();
        byteBuffer = BufferUtils.createByteBuffer(image3.getData(), n6 * n7 * n5);
        byteBuffer.clear();
        image3.setType(image.getType());
        image3.setWidth(n6);
        image3.setHeight(n7);
        ByteBuffer byteBuffer2 = image.getData();
        byteBuffer2.rewind();
        byte[] byArray = new byte[n6 * n5];
        int n10 = 0;
        int n11 = n2;
        while (n11 <= n4) {
            if (n9 > n11) {
                byteBuffer2.position((n11 * n8 + n) * n5);
                if (n8 > n3) {
                    byteBuffer2.get(byArray, 0, n6 * n5);
                } else {
                    byteBuffer2.get(byArray, 0, (n8 - n) * n5);
                    for (int i = (n8 - n) * n5; i < n6 * n5; ++i) {
                        byArray[i] = i < n5 ? -1 : byArray[i - n5];
                    }
                }
            }
            byteBuffer.put(byArray, 0, n6 * n5);
            ++n11;
            ++n10;
        }
        byteBuffer.flip();
        image3.setData(byteBuffer);
        return image3;
    }

    public static void flipVertically(com.jme.image.Image image) {
        ByteBuffer byteBuffer = image.getData();
        ByteBuffer byteBuffer2 = BufferUtils.createByteBuffer(byteBuffer.capacity());
        byte[] byArray = new byte[byteBuffer.capacity() / image.getHeight()];
        byteBuffer.rewind();
        byteBuffer2.clear();
        for (int i = 0; i < image.getHeight(); ++i) {
            if (byteBuffer.remaining() < byArray.length) continue;
            byteBuffer.get(byArray);
            byteBuffer2.position((image.getHeight() - 1 - i) * byArray.length);
            byteBuffer2.put(byArray);
        }
        image.setData(byteBuffer2);
        byteBuffer = null;
    }

    public static Texture loadTexture(com.jme.image.Image image, int n, int n2, float f, int n3, boolean bl) {
        TextureKey textureKey = new TextureKey(null, bl, n3);
        if (image != null) {
            textureKey.setFileType("" + image.hashCode());
        }
        return TextureManager.loadTexture(null, textureKey, image, n, n2, f);
    }

    public static Texture loadTexture(com.jme.image.Image image, int n, int n2, boolean bl) {
        if (bl) {
            ImageUtils.flipVertically(image);
        }
        return ImageUtils.loadTexture(image, n, n2, 1.0f, TextureManager.COMPRESS_BY_DEFAULT ? -1 : -2, bl);
    }

    public static Texture loadTexture(com.jme.image.Image image, int n, int n2, float f, boolean bl) {
        return ImageUtils.loadTexture(image, n, n2, f, TextureManager.COMPRESS_BY_DEFAULT ? -1 : -2, bl);
    }

    public static com.jme.image.Image composeImage(com.jme.image.Image image, Image image2, boolean bl) {
        BufferedImage bufferedImage = null;
        if (image2 instanceof BufferedImage) {
            bufferedImage = (BufferedImage)image2;
        } else {
            try {
                bufferedImage = new BufferedImage(image.getWidth(), image.getHeight(), 10);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logger.getLogger(ImageUtils.class.getName()).warning("Problem creating buffered Image: " + illegalArgumentException.getMessage());
                return image;
            }
        }
        byte[] byArray = (byte[])bufferedImage.getRaster().getDataElements(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null);
        ByteBuffer byteBuffer = image.getData();
        ByteBuffer byteBuffer2 = BufferUtils.createByteBuffer(image.getWidth() * image.getHeight() * 4);
        byteBuffer.rewind();
        byteBuffer2.clear();
        for (int i = 0; i < image.getWidth() * image.getHeight(); ++i) {
            byteBuffer2.put(byteBuffer.get()).put(byteBuffer.get()).put(byteBuffer.get());
            int n = i / image.getWidth();
            int n2 = image.getHeight() - n - 1;
            int n3 = i % image.getWidth();
            int n4 = i;
            if (bl) {
                n4 = n2 * image.getWidth() + n3;
            }
            byteBuffer2.put(byArray[n4]);
        }
        com.jme.image.Image image3 = new com.jme.image.Image();
        image3.setType(3);
        image3.setWidth(image.getWidth());
        image3.setHeight(image.getHeight());
        image3.setData(byteBuffer2);
        return image3;
    }

    public static void gluScaleImage(com.jme.image.Image image, float f, int n) {
        int n2 = imageFormats[image.getType()];
        int n3 = 5121;
        int n4 = (int)((float)image.getWidth() * f);
        int n5 = (int)((float)image.getHeight() * f);
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer((n4 + 4) * n5 * n);
        int n6 = MipMap.gluScaleImage(n2, image.getWidth(), image.getHeight(), n3, image.getData(), n4, n5, n3, byteBuffer);
        if (n6 != 0) {
            Util.checkGLError();
        }
        Logger.getLogger(ImageUtils.class.getName()).info("Resized image from " + image.getWidth() + "x" + image.getHeight() + " to " + n4 + "x" + n5);
        image.setWidth(n4);
        image.setHeight(n5);
        image.setData(byteBuffer);
    }

    public static void scaleImage(com.jme.image.Image image, float f) {
        float f2 = 1.0f / f;
        int n = 4;
        if (image.getType() == 1) {
            n = 3;
        }
        byte[] byArray = new byte[n];
        int n2 = (int)((float)image.getWidth() * f);
        int n3 = (int)((float)image.getHeight() * f);
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(n2 * n3 * n);
        for (int i = 0; i < n3; ++i) {
            int n4 = i * n2;
            float f3 = (float)i * f2;
            for (int j = 0; j < n2; ++j) {
                ImageUtils.getPixelBilinear(image, (float)j * f2, f3, byArray);
                byteBuffer.position((n4 + j) * n);
                byteBuffer.put(byArray);
            }
        }
        image.setData(byteBuffer);
        image.setHeight(n3);
        image.setWidth(n2);
    }

    private static final void getPixelNearest(com.jme.image.Image image, float f, float f2, byte[] byArray) {
        int n = byArray.length;
        int n2 = (int)f;
        int n3 = (int)f2;
        int n4 = n3 * image.getWidth();
        image.getData().position((n4 + n2) * n);
        image.getData().get(byArray);
    }

    private static final void getPixelBilinear(com.jme.image.Image image, float f, float f2, byte[] byArray) {
        int n = byArray.length;
        int n2 = (int)f;
        int n3 = n2 + 1;
        int n4 = (int)f2;
        int n5 = n4 + 1;
        n3 = Math.min(n3, image.getWidth() - 1);
        n5 = Math.min(n5, image.getHeight() - 1);
        int n6 = n4 * image.getWidth();
        int n7 = n5 * image.getWidth();
        image.getData().position((n6 + n2) * n);
        image.getData().get(interPixels[0], 0, n);
        image.getData().position((n6 + n3) * n);
        image.getData().get(interPixels[1], 0, n);
        image.getData().position((n7 + n2) * n);
        image.getData().get(interPixels[2], 0, n);
        image.getData().position((n7 + n3) * n);
        image.getData().get(interPixels[3], 0, n);
        float f3 = f - (float)n2;
        float f4 = f2 - (float)n4;
        float f5 = 1.0f - f3;
        float f6 = 1.0f - f4;
        for (int i = 0; i < n; ++i) {
            byArray[i] = ImageUtils.floatToUnsignedByte(((float)ImageUtils.unsignedByteToInt(interPixels[0][i]) * f5 + (float)ImageUtils.unsignedByteToInt(interPixels[1][i]) * f3) * f6 + ((float)ImageUtils.unsignedByteToInt(interPixels[2][i]) * f5 + (float)ImageUtils.unsignedByteToInt(interPixels[3][i]) * f3) * f4);
        }
    }

    public BufferedImage getScaledInstance(BufferedImage bufferedImage, int n, int n2, Object object, boolean bl) {
        int n3;
        int n4;
        int n5 = bufferedImage.getTransparency() == 1 ? 1 : 2;
        BufferedImage bufferedImage2 = bufferedImage;
        if (bl) {
            n4 = bufferedImage.getWidth();
            n3 = bufferedImage.getHeight();
        } else {
            n4 = n;
            n3 = n2;
        }
        do {
            if (bl && n4 > n && (n4 /= 2) < n) {
                n4 = n;
            }
            if (bl && n3 > n2 && (n3 /= 2) < n2) {
                n3 = n2;
            }
            BufferedImage bufferedImage3 = new BufferedImage(n4, n3, n5);
            Graphics2D graphics2D = bufferedImage3.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object);
            graphics2D.drawImage(bufferedImage2, 0, 0, n4, n3, null);
            graphics2D.dispose();
            bufferedImage2 = bufferedImage3;
        } while (n4 != n || n3 != n2);
        return bufferedImage2;
    }

    public static int unsignedByteToInt(byte by) {
        return by & 0xFF;
    }

    public static byte intToUnsignedByte(int n) {
        if (n < 128) {
            return (byte)n;
        }
        return (byte)(n - 256);
    }

    public static byte floatToUnsignedByte(float f) {
        if (f < 128.0f) {
            return (byte)f;
        }
        return (byte)(f - 256.0f);
    }

    public static int getNextPowerOfTwo(int n) {
        if (n <= 0) {
            return 0;
        }
        if (n <= 1) {
            return 1;
        }
        if (n <= 2) {
            return 2;
        }
        if (n <= 4) {
            return 4;
        }
        if (n <= 8) {
            return 8;
        }
        if (n <= 16) {
            return 16;
        }
        if (n <= 32) {
            return 32;
        }
        if (n <= 64) {
            return 64;
        }
        if (n <= 128) {
            return 128;
        }
        if (n <= 256) {
            return 256;
        }
        if (n <= 512) {
            return 512;
        }
        if (n <= 1024) {
            return 1024;
        }
        if (n <= 2048) {
            return 2048;
        }
        if (n <= 4096) {
            return 4096;
        }
        if (n <= 8192) {
            return 8192;
        }
        if (n <= 16384) {
            return 16384;
        }
        if (n <= 32768) {
            return 32768;
        }
        if (n <= 65536) {
            return 65536;
        }
        return 0;
    }
}

