/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.utils;

import com.jme.image.Image;
import com.jme.image.util.PNGLoader;
import com.jme.image.util.TGALoader;
import com.jme.math.Vector2f;
import com.jme.scene.Node;
import com.jme.scene.SharedMesh;
import com.jme.scene.shape.Quad;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.turborilla.utils.ImageUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.FloatBuffer;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public class Font {
    private Image font;
    public CharDef[] chars = new CharDef[256];
    private int[][] kerning = new int[256][256];
    private int lineHeight = 32;
    private int base = 10;

    public Font(URL uRL, URL uRL2) throws IOException {
        if (uRL2.toString().endsWith(".tga")) {
            this.font = TGALoader.loadImage(uRL2.openStream());
        } else if (uRL2.toString().endsWith(".png")) {
            this.font = PNGLoader.loadImage(uRL2.openStream());
        }
        if (this.font == null) {
            throw new IOException("Could not load font image: " + uRL2);
        }
        this.parseFnt(uRL.openStream());
    }

    public Font(URL uRL, Image image) throws IOException {
        this.font = image;
        this.parseFnt(uRL.openStream());
    }

    private void parseFnt(InputStream inputStream) throws IOException {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string = bufferedReader.readLine();
            String string2 = bufferedReader.readLine();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " =");
            String string3 = "";
            while (stringTokenizer.hasMoreTokens() && !"lineHeight".equals(string3)) {
                string3 = stringTokenizer.nextToken();
            }
            if ("lineHeight".equals(string3) && stringTokenizer.hasMoreTokens()) {
                this.lineHeight = Integer.parseInt(stringTokenizer.nextToken());
            }
            while (stringTokenizer.hasMoreTokens() && !"base".equals(string3)) {
                string3 = stringTokenizer.nextToken();
            }
            if ("base".equals(string3) && stringTokenizer.hasMoreTokens()) {
                this.base = Integer.parseInt(stringTokenizer.nextToken());
            }
            String string4 = bufferedReader.readLine();
            boolean bl = false;
            while (!bl) {
                int n;
                Object object;
                String string5 = bufferedReader.readLine();
                if (string5 == null) {
                    bl = true;
                    continue;
                }
                if (!string5.startsWith("chars c") && string5.startsWith("char") && (object = this.parseChar(string5)) != null) {
                    this.chars[((CharDef)object).id] = object;
                }
                if (string5.startsWith("kernings c") || !string5.startsWith("kerning")) continue;
                object = new StringTokenizer(string5, " =");
                ((StringTokenizer)object).nextToken();
                ((StringTokenizer)object).nextToken();
                int n2 = Integer.parseInt(((StringTokenizer)object).nextToken());
                ((StringTokenizer)object).nextToken();
                int n3 = Integer.parseInt(((StringTokenizer)object).nextToken());
                ((StringTokenizer)object).nextToken();
                this.kerning[n2][n3] = n = Integer.parseInt(((StringTokenizer)object).nextToken());
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(Font.class.getName()).warning(iOException.getMessage());
            throw new IOException("Failed to parse font file: " + inputStream);
        }
    }

    public void multiplyWithCharSpacing(float f) {
        for (CharDef charDef : this.chars) {
            if (charDef == null) continue;
            charDef.xadvance = (int)((float)charDef.xadvance * f);
        }
    }

    private CharDef parseChar(String string) {
        CharDef charDef = new CharDef();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " =");
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        charDef.id = Integer.parseInt(stringTokenizer.nextToken());
        if (charDef.id < 0) {
            return null;
        }
        stringTokenizer.nextToken();
        charDef.x = Integer.parseInt(stringTokenizer.nextToken());
        stringTokenizer.nextToken();
        charDef.y = Integer.parseInt(stringTokenizer.nextToken());
        stringTokenizer.nextToken();
        charDef.width = Integer.parseInt(stringTokenizer.nextToken());
        stringTokenizer.nextToken();
        charDef.height = Integer.parseInt(stringTokenizer.nextToken());
        stringTokenizer.nextToken();
        charDef.xoffset = Integer.parseInt(stringTokenizer.nextToken());
        stringTokenizer.nextToken();
        charDef.yoffset = Integer.parseInt(stringTokenizer.nextToken());
        stringTokenizer.nextToken();
        charDef.xadvance = Integer.parseInt(stringTokenizer.nextToken());
        TextureState textureState = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
        textureState.setTexture(ImageUtils.loadTexture(this.font, 5, 1, false));
        charDef.init(textureState);
        return charDef;
    }

    public int getHeight(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= this.chars.length || this.chars[c] == null) continue;
            n = Math.max(this.chars[c].height, n);
        }
        return n;
    }

    public int getWidth(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c < this.chars.length && this.chars[c] != null) {
                n += this.chars[c].xadvance;
            }
            if (i >= string.length() - 1 || c >= this.chars.length) continue;
            n += this.kerning[c][string.charAt(i + 1)];
        }
        return n;
    }

    public SharedMesh getChar(int n, int n2, Vector2f vector2f, SharedMesh sharedMesh) {
        if (this.chars[n] != null) {
            if (sharedMesh == null) {
                sharedMesh = new SharedMesh();
            }
            sharedMesh.setTarget(this.chars[n]);
            sharedMesh.getLocalTranslation().set(vector2f.x + (float)this.chars[n].xoffset, vector2f.y - (float)this.chars[n].yoffset, sharedMesh.getLocalTranslation().z);
            vector2f.x += (float)this.chars[n].xadvance;
            if (n2 > 0) {
                vector2f.x += (float)this.kerning[n][n2];
            }
        }
        return sharedMesh;
    }

    public SharedMesh getCharRightToLeft(int n, int n2, Vector2f vector2f, SharedMesh sharedMesh) {
        if (this.chars[n] != null) {
            if (sharedMesh == null) {
                sharedMesh = new SharedMesh();
            }
            sharedMesh.setTarget(this.chars[n]);
            vector2f.x -= (float)this.chars[n].xadvance;
            if (n2 > 0) {
                vector2f.x -= (float)this.kerning[n2][n];
            }
            sharedMesh.getLocalTranslation().set(vector2f.x + (float)this.chars[n].xoffset, vector2f.y - (float)this.chars[n].yoffset, sharedMesh.getLocalTranslation().z);
        }
        return sharedMesh;
    }

    public void drawString(String string, Node node, Vector2f vector2f) {
        int n = string.length();
        if (n > 0) {
            for (int i = 0; i < n - 1; ++i) {
                if (string.charAt(i) == '\n') {
                    this.crlf(vector2f);
                    continue;
                }
                node.attachChild(this.getChar(string.charAt(i), string.charAt(i + 1), vector2f, null));
            }
            node.attachChild(this.getChar(string.charAt(n - 1), -1, vector2f, null));
        }
    }

    public boolean isValidChar(char c) {
        char c2 = c;
        return c2 < this.chars.length && this.chars[c2] != null;
    }

    public void crlf(Vector2f vector2f) {
        vector2f.set(0.0f, vector2f.y - (float)this.lineHeight);
    }

    public int getLineHeight() {
        return this.lineHeight;
    }

    public void setLineHeight(int n) {
        this.lineHeight = n;
    }

    public void saveAsFengFont(URL uRL, String string) {
        File file = null;
        try {
            file = new File(uRL.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        File file2 = new File(file, string);
        file2.delete();
        PrintWriter printWriter = null;
        try {
            file2.createNewFile();
            printWriter = new PrintWriter((Writer)new BufferedWriter(new FileWriter(file2, false)), true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (printWriter != null) {
            printWriter.println("<?xml version='1.0' encoding='utf-8'?>");
            printWriter.println("<Font>");
            for (CharDef charDef : this.chars) {
                if (charDef == null) continue;
                printWriter.println("<CharacterPixmap x=\"" + charDef.x + "\"" + " y=\"" + charDef.y + "\"" + " width=\"" + charDef.width + "\"" + " height=\"" + charDef.height + "\"" + " charWidth=\"" + charDef.xadvance + "\"" + " xOffset=\"" + charDef.xoffset + "\"" + " yOffset=\"" + charDef.yoffset + "\"" + ">");
                printWriter.println("<character><![CDATA[" + (char)charDef.id + "]]></character>");
                printWriter.println("</CharacterPixmap>");
            }
            printWriter.println("</Font>");
        }
        printWriter.flush();
        printWriter.close();
    }

    public int getBase() {
        return this.base;
    }

    private class CharDef
    extends Quad {
        public int id;
        public int x;
        public int y;
        public int width;
        public int height;
        public int xoffset;
        public int yoffset;
        public int xadvance;

        private CharDef() {
        }

        public void init(TextureState textureState) {
            this.setName("CharDef:" + this.id);
            this.initialize(this.width, this.height);
            FloatBuffer floatBuffer = this.getTextureBuffer(0, 0);
            this.getBatch(0).getVertexBuffer().rewind();
            this.getBatch(0).getVertexBuffer().put(0.0f).put(0.0f).put(0.0f);
            this.getBatch(0).getVertexBuffer().put(0.0f).put(-this.height).put(0.0f);
            this.getBatch(0).getVertexBuffer().put(this.width).put(-this.height).put(0.0f);
            this.getBatch(0).getVertexBuffer().put(this.width).put(0.0f).put(0.0f);
            floatBuffer.rewind();
            floatBuffer.put((float)this.x / (float)Font.this.font.getWidth()).put((float)this.y / (float)Font.this.font.getHeight());
            floatBuffer.put((float)this.x / (float)Font.this.font.getWidth()).put((float)(this.y + this.height) / (float)Font.this.font.getHeight());
            floatBuffer.put((float)(this.x + this.width) / (float)Font.this.font.getWidth()).put((float)(this.y + this.height) / (float)Font.this.font.getHeight());
            floatBuffer.put((float)(this.x + this.width) / (float)Font.this.font.getWidth()).put((float)this.y / (float)Font.this.font.getHeight());
            this.setRenderState(textureState);
            this.updateRenderState();
        }

        public String toString() {
            return "[CharDef id=" + this.id + " x=" + this.x + " y=" + this.y + "]";
        }
    }
}

