/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.terrain;

import com.jme.system.JmeException;
import com.jme.util.LittleEndien;
import com.jmex.terrain.util.AbstractHeightMap;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Logger;

public class RawHeightMap
extends AbstractHeightMap {
    private static final Logger logger = Logger.getLogger(RawHeightMap.class.getName());
    private String filename;
    private Format format;
    private int xsize;
    private int ysize;

    public RawHeightMap(String string, int n, int n2) {
        this(string, n, n2, Format._8BIT);
    }

    public RawHeightMap(int[] nArray, int n, int n2) {
        this.heightData = nArray;
        this.xsize = n;
        this.ysize = n2;
        this.size = n;
    }

    public RawHeightMap(String string, int n, int n2, Format format) {
        if (null == string || this.size <= 0) {
            throw new JmeException("Must supply valid filename and size (> 0)");
        }
        this.filename = string;
        this.xsize = n;
        this.ysize = n2;
        this.size = n;
        this.format = format;
        this.load();
    }

    public boolean load() {
        if (null == this.filename || this.xsize <= 0 || this.ysize <= 0) {
            throw new JmeException("Must supply valid filename and size (> 0)");
        }
        if (null != this.heightData) {
            this.unloadHeightMap();
        }
        this.heightData = new int[this.xsize * this.ysize];
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.filename);
            int n = this.format == Format._16BITLE || this.format == Format._16BITBE ? 2 : 1;
            if (this.format == Format._16BITLE) {
                LittleEndien littleEndien = new LittleEndien(fileInputStream);
                if (this.heightData.length != littleEndien.available() / n) {
                    logger.warning("Incorrect map size. Aborting raw load.");
                }
                for (int i = 0; i < this.xsize; ++i) {
                    for (int j = 0; j < this.ysize; ++j) {
                        this.heightData[j * this.xsize + i] = littleEndien.readShort();
                    }
                }
                littleEndien.close();
            } else {
                DataInputStream dataInputStream = new DataInputStream(fileInputStream);
                if (this.heightData.length != dataInputStream.available() / n) {
                    logger.warning("Incorrect map size. Aborting raw load.");
                }
                for (int i = 0; i < this.xsize; ++i) {
                    for (int j = 0; j < this.ysize; ++j) {
                        this.heightData[j * this.xsize + i] = this.format == Format._16BITBE ? (int)dataInputStream.readShort() : dataInputStream.readUnsignedByte();
                    }
                }
                dataInputStream.close();
            }
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.warning("Heightmap file" + this.filename + " not found.");
            return false;
        }
        catch (IOException iOException) {
            logger.warning("Error reading data from " + this.filename);
            return false;
        }
        logger.info("Successfully loaded " + this.filename);
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Format {
        _8BIT,
        _16BITLE,
        _16BITBE;

    }
}

