/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.terrain;

import com.jme.image.Image;
import com.jme.image.util.TGALoader;
import com.jme.math.Vector3f;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import com.jmex.terrain.util.AbstractHeightMap;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.logging.Logger;

public class ImageHeightMap
extends AbstractHeightMap
implements Externalizable,
Savable {
    private static final long serialVersionUID = -2796443908164985161L;
    private static final Logger logger = Logger.getLogger(ImageHeightMap.class.getName());
    private int xsize;
    private int ysize;
    private transient URL file = null;
    private Vector3f stepScale;
    private static final int version = 1;

    public ImageHeightMap() {
        this.xsize = 0;
        this.ysize = 0;
    }

    public ImageHeightMap(URL uRL) {
        this.file = uRL;
    }

    public boolean load(InputStream inputStream, String string) {
        return this.load(inputStream, string, 0);
    }

    public boolean load(InputStream inputStream, String string, int n) {
        int n2;
        Image image = null;
        try {
            if (".tga".equals(string)) {
                image = TGALoader.loadImage(inputStream, false, false);
            } else if (!".png".equals(string)) {
                logger.severe("Unsupported image format: " + string);
                return false;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (image == null) {
            logger.severe("Could not load image " + string);
            return false;
        }
        this.xsize = image.getWidth();
        this.ysize = image.getHeight();
        ByteBuffer byteBuffer = image.getData();
        this.heightData = new int[this.xsize * this.ysize];
        if (n == 0) {
            for (n2 = 0; n2 < this.xsize * this.ysize; ++n2) {
                this.heightData[n2] = byteBuffer.get();
                if (this.heightData[n2] < 0) {
                    int n3 = n2;
                    this.heightData[n3] = this.heightData[n3] + 256;
                }
                byteBuffer.get();
                byteBuffer.get();
            }
        }
        if (n == 1) {
            for (n2 = 0; n2 < this.xsize * this.ysize; ++n2) {
                byteBuffer.get();
                this.heightData[n2] = byteBuffer.get();
                if (this.heightData[n2] < 0) {
                    int n4 = n2;
                    this.heightData[n4] = this.heightData[n4] + 256;
                }
                byteBuffer.get();
            }
        }
        if (n == 2) {
            for (n2 = 0; n2 < this.xsize * this.ysize; ++n2) {
                byteBuffer.get();
                byteBuffer.get();
                this.heightData[n2] = byteBuffer.get();
                if (this.heightData[n2] >= 0) continue;
                int n5 = n2;
                this.heightData[n5] = this.heightData[n5] + 256;
            }
        }
        return true;
    }

    public boolean load() {
        if (this.file == null) {
            return false;
        }
        try {
            this.load(this.file.openStream(), this.file.getFile().substring(this.file.getFile().lastIndexOf(46)));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return true;
    }

    public int getXsize() {
        return this.xsize;
    }

    public void setXsize(int n) {
        this.xsize = n;
    }

    public int getYsize() {
        return this.ysize;
    }

    public void setYsize(int n) {
        this.ysize = n;
    }

    public void setHeightData(int[] nArray, int n, int n2) {
        this.heightData = nArray;
        this.xsize = n;
        this.ysize = n2;
    }

    public void extendHeightMap(int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8 = this.xsize + n + n2;
        int n9 = this.ysize + n3 + n4;
        int[] nArray = new int[n8 * n9];
        for (n7 = 0; n7 < this.ysize; ++n7) {
            for (n6 = 0; n6 < this.xsize; ++n6) {
                nArray[(n7 + n3) * n8 + (n6 + n)] = this.heightData[n7 * this.xsize + n6];
            }
        }
        if (n > 0) {
            this.setCol(nArray, 0, n8, n9, n5);
            this.setCol(nArray, 1, n8, n9, n5);
            for (n7 = 2; n7 < n; ++n7) {
                for (n6 = 0; n6 < this.ysize; ++n6) {
                    nArray[(n6 + n3) * n8 + n7] = this.hermiteInterpolate(nArray[(n6 + n3) * n8 + 0], nArray[(n6 + n3) * n8 + 1], nArray[(n6 + n3) * n8 + n], nArray[(n6 + n3) * n8 + n + 1], ((double)n7 - 2.0) / (double)(n - 2));
                }
            }
        }
        if (n2 > 0) {
            this.setCol(nArray, n8 - 1, n8, n9, n5);
            this.setCol(nArray, n8 - 2, n8, n9, n5);
            for (n7 = 0; n7 < n2 - 2; ++n7) {
                for (n6 = 0; n6 < this.ysize; ++n6) {
                    nArray[(n6 + n3) * n8 + (n7 + n8 - n2)] = this.hermiteInterpolate(nArray[(n6 + n3) * n8 + n8 - n2 - 2], nArray[(n6 + n3) * n8 + n8 - n2 - 1], nArray[(n6 + n3) * n8 + n8 - 2], nArray[(n6 + n3) * n8 + n8 - 1], (double)n7 / (double)(n2 - 2));
                }
            }
        }
        if (n3 > 0) {
            this.setRow(nArray, 0, n8, n5);
            this.setRow(nArray, 1, n8, n5);
            for (n7 = 0; n7 < n8; ++n7) {
                for (n6 = 2; n6 < n3; ++n6) {
                    nArray[n6 * n8 + n7] = this.hermiteInterpolate(nArray[0 * n8 + n7], nArray[1 * n8 + n7], nArray[n3 * n8 + n7], nArray[n3 + 1 * n8 + n7], ((double)n6 - 2.0) / (double)(n3 - 2));
                }
            }
        }
        if (n4 > 0) {
            this.setRow(nArray, n9 - 1, n8, n5);
            this.setRow(nArray, n9 - 2, n8, n5);
            for (n7 = 0; n7 < n8; ++n7) {
                for (n6 = 0; n6 < n4 - 2; ++n6) {
                    int n10 = nArray[(n9 - n4 - 2) * n8 + n7];
                    if (n10 < 0) {
                        nArray[(n9 - 2) * n8 + n7] = (int)((float)n10 * 0.8f);
                        nArray[(n9 - 1) * n8 + n7] = (int)((float)n10 * 0.8f);
                    }
                    nArray[(n6 + (n9 - n4)) * n8 + n7] = this.hermiteInterpolate(nArray[(n9 - n4 - 2) * n8 + n7], nArray[(n9 - n4 - 1) * n8 + n7], nArray[(n9 - 2) * n8 + n7], nArray[(n9 - 1) * n8 + n7], (double)n6 / (double)(n4 - 2));
                }
            }
        }
        this.setHeightData(nArray, n8, n9);
    }

    public void cutHeightMap(int n) {
        int n2 = this.xsize - n;
        int n3 = this.ysize;
        int[] nArray = new int[n2 * n3];
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                nArray[i * n2 + j] = this.heightData[i * this.xsize + j];
            }
        }
        this.setHeightData(nArray, n2, n3);
    }

    public void extendHeightMap(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7 = this.xsize + n + n2;
        int n8 = this.ysize + n3 + n4;
        int[] nArray = new int[n7 * n8];
        for (n6 = 0; n6 < this.ysize; ++n6) {
            for (n5 = 0; n5 < this.xsize; ++n5) {
                nArray[(n6 + n3) * n7 + (n5 + n)] = this.heightData[n6 * this.xsize + n5];
            }
        }
        if (n > 0) {
            for (n6 = 0; n6 < n; ++n6) {
                for (n5 = 0; n5 < this.ysize; ++n5) {
                    nArray[(n5 + n3) * n7 + n6] = nArray[(n5 + n3) * n7 + n];
                }
            }
        }
        if (n2 > 0) {
            for (n6 = 0; n6 < n2; ++n6) {
                for (n5 = 0; n5 < this.ysize; ++n5) {
                    nArray[(n5 + n3) * n7 + (n7 - n2) - 1] = nArray[(n5 + n3) * n7 + (n7 - n2) - 1];
                }
            }
        }
        if (n3 > 0) {
            for (n6 = 0; n6 < n7; ++n6) {
                for (n5 = 0; n5 < n3; ++n5) {
                    nArray[n5 * n7 + n6] = nArray[n3 * n7 + n6];
                }
            }
        }
        if (n4 > 0) {
            for (n6 = 0; n6 < n7; ++n6) {
                for (n5 = 0; n5 < n4; ++n5) {
                    nArray[(n5 + (n8 - n4)) * n7 + n6] = nArray[(n8 - n4 - 1) * n7 + n6];
                }
            }
        }
        this.setHeightData(nArray, n7, n8);
    }

    public void loopHoriz(int n) {
        int n2 = this.xsize * n;
        int n3 = this.ysize;
        int[] nArray = new int[n2 * n3];
        int[] nArray2 = this.getHeightMap();
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < n3; ++i) {
            n5 = i * n2;
            for (int j = 0; j < n2; ++j) {
                nArray[n5 + j] = nArray2[n5 + n4];
                if (++n4 < this.xsize) continue;
                n4 = 0;
            }
        }
        this.setHeightData(nArray, n2, n3);
    }

    private void setRow(int[] nArray, int n, int n2, int n3) {
        for (int i = 0; i < n2; ++i) {
            nArray[n * n2 + i] = n3;
        }
    }

    private void setCol(int[] nArray, int n, int n2, int n3, int n4) {
        for (int i = 0; i < n3; ++i) {
            nArray[i * n2 + n] = n4;
        }
    }

    private int cubicInterpolate(double d, double d2, double d3, double d4, double d5) {
        double d6 = d5 * d5;
        double d7 = d4 - d3 - d + d2;
        double d8 = d - d2 - d7;
        double d9 = d3 - d;
        double d10 = d2;
        return (int)(d7 * d5 * d6 + d8 * d6 + d9 * d5 + d10);
    }

    private int hermiteInterpolate(double d, double d2, double d3, double d4, double d5) {
        double d6 = 1.0;
        double d7 = 0.0;
        double d8 = d5 * d5;
        double d9 = d8 * d5;
        double d10 = (d2 - d) * (1.0 + d7) * (1.0 - d6) / 2.0;
        d10 += (d3 - d2) * (1.0 - d7) * (1.0 - d6) / 2.0;
        double d11 = (d3 - d2) * (1.0 + d7) * (1.0 - d6) / 2.0;
        double d12 = 2.0 * d9 - 3.0 * d8 + 1.0;
        double d13 = d9 - 2.0 * d8 + d5;
        double d14 = d9 - d8;
        double d15 = -2.0 * d9 + 3.0 * d8;
        return (int)(d12 * d2 + d13 * d10 + d14 * (d11 += (d4 - d3) * (1.0 - d7) * (1.0 - d6) / 2.0) + d15 * d3);
    }

    public Vector3f getStepScale() {
        if (this.stepScale == null) {
            this.stepScale = new Vector3f();
        }
        return this.stepScale;
    }

    public void setStepScale(Vector3f vector3f) {
        this.stepScale = vector3f;
    }

    public ImageHeightMap clone() throws CloneNotSupportedException {
        ImageHeightMap imageHeightMap = new ImageHeightMap();
        int[] nArray = new int[this.getHeightMap().length];
        System.arraycopy(this.getHeightMap(), 0, nArray, 0, this.getHeightMap().length);
        imageHeightMap.setHeightData(nArray, this.getXsize(), this.getYsize());
        imageHeightMap.setStepScale(new Vector3f(this.getStepScale()));
        imageHeightMap.file = this.file;
        imageHeightMap.size = this.size;
        imageHeightMap.heightScale = this.heightScale;
        return imageHeightMap;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.xsize);
        objectOutput.writeInt(this.ysize);
        objectOutput.writeObject(this.stepScale);
        objectOutput.writeObject(this.heightData);
        objectOutput.writeInt(this.size);
        objectOutput.writeFloat(this.heightScale);
        objectOutput.writeFloat(this.filter);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.xsize = objectInput.readInt();
        this.ysize = objectInput.readInt();
        this.stepScale = (Vector3f)objectInput.readObject();
        this.heightData = (int[])objectInput.readObject();
        this.size = objectInput.readInt();
        this.heightScale = objectInput.readFloat();
        this.filter = objectInput.readFloat();
    }

    public Class getClassTag() {
        return this.getClass();
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        int n = inputCapsule.readInt("version", 0);
        if (n != 1) {
            logger.warning("Loading a different version of " + this.getClassTag() + ". Version on file: " + n + " current version: " + 1);
        }
        this.read(n, inputCapsule);
    }

    private void read(int n, InputCapsule inputCapsule) throws IOException {
        switch (n) {
            case 1: {
                this.xsize = inputCapsule.readInt("xsize", 0);
                this.ysize = inputCapsule.readInt("ysize", 0);
                this.stepScale = (Vector3f)inputCapsule.readSavable("stepScale", null);
                this.heightData = inputCapsule.readIntArray("heightData", null);
                this.size = inputCapsule.readInt("size", 0);
                this.heightScale = inputCapsule.readFloat("heightScale", 0.0f);
                this.filter = inputCapsule.readFloat("filter", 0.0f);
                break;
            }
            default: {
                throw new IOException("Do not know how to load version " + n + " of " + this.getClassTag());
            }
        }
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(1, "version", 0);
        outputCapsule.write(this.xsize, "xsize", 0);
        outputCapsule.write(this.ysize, "ysize", 0);
        outputCapsule.write(this.stepScale, "stepScale", null);
        outputCapsule.write(this.heightData, "heightData", (int[])null);
        outputCapsule.write(this.size, "size", 0);
        outputCapsule.write(this.heightScale, "heightScale", 0.0f);
        outputCapsule.write(this.filter, "filter", 0.0f);
    }
}

