/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.sound;

import com.jme.scene.Spatial;
import com.turborilla.TransformationProvider;
import com.turborilla.WeakSpatialTransformationProvider;
import com.turborilla.sound.TurboSoundSystem;
import paulscode.sound.SoundSystemConfig;

public class SFX {
    private String track;
    protected float pitch = 1.0f;
    protected float volume = 1.0f;
    private TurboSoundSystem soundSystem;
    private String volumeCategory;
    private TransformationProvider provider;
    private int attenuation;
    private float distOrRoll;
    private String sourcename = "";
    private boolean looping = false;

    public SFX(TurboSoundSystem turboSoundSystem, String string) {
        this.setSoundSystem(turboSoundSystem);
        this.setMaxAudibleDistance(-1.0f);
        this.setRolloff(-1.0f);
        this.track = string;
        this.attenuation = SoundSystemConfig.getDefaultAttenuation();
    }

    public void setVolumeCategory(String string) {
        this.volumeCategory = string;
    }

    public String getVolumeCategory() {
        return this.volumeCategory;
    }

    public void setSoundSystem(TurboSoundSystem turboSoundSystem) {
        this.soundSystem = turboSoundSystem;
    }

    public TurboSoundSystem getSoundSystem() {
        return this.soundSystem;
    }

    public void setRolloff(float f) {
        this.distOrRoll = f;
        if (this.distOrRoll < 0.0f) {
            this.distOrRoll = SoundSystemConfig.getDefaultRolloff();
        }
        this.attenuation = 1;
    }

    public void setMaxAudibleDistance(float f) {
        this.distOrRoll = f;
        if (this.distOrRoll < 0.0f) {
            this.distOrRoll = SoundSystemConfig.getDefaultFadeDistance();
        }
        this.attenuation = 2;
    }

    public void setProviderToTrack(TransformationProvider transformationProvider) {
        this.provider = transformationProvider;
    }

    public void setSpatialToTrack(Spatial spatial) {
        if (spatial == null) {
            this.setProviderToTrack(null);
        } else {
            this.setProviderToTrack(new WeakSpatialTransformationProvider(spatial));
        }
    }

    public void play() {
        this.play(1.0f);
    }

    public void fadeIn(float f) {
        if (!this.isPlaying()) {
            this.play();
        }
        if (this.sourcename != null) {
            this.soundSystem.fadeIn(this.sourcename, f);
        }
    }

    public void play(float f) {
        this.play(f, this.track);
    }

    protected void play(float f, String string) {
        this.sourcename = this.getSoundSystem().playSFX(string, this.provider, this.isLooping(), this.attenuation, this.distOrRoll, this.volumeCategory, this.getPitch() * f);
    }

    public void stop() {
        if (this.sourcename != null) {
            this.getSoundSystem().stop(this.sourcename);
        }
    }

    public void fadeOut(float f) {
        if (this.sourcename != null) {
            this.getSoundSystem().fadeOutAndStop(this.sourcename, f);
        }
    }

    public boolean isPlaying() {
        return this.sourcename != null && this.getSoundSystem().playing(this.sourcename);
    }

    public void pause() {
        if (this.sourcename != null) {
            this.getSoundSystem().pause(this.sourcename);
        }
    }

    public float getPitch() {
        return this.pitch;
    }

    public void setPitch(float f) {
        if (this.sourcename != null) {
            this.getSoundSystem().setPitch(this.sourcename, f);
        }
        this.pitch = f;
    }

    public float getVolume() {
        return this.volume;
    }

    public void setVolume(float f) {
        if (this.sourcename != null) {
            this.getSoundSystem().setVolume(this.sourcename, f);
        }
        this.volume = f;
    }

    public void fadePitch(float f, float f2) {
        this.setPitch(f2);
    }

    public void setPitchChangeRate(float f) {
    }

    public void setTargetPitch(float f) {
        this.setPitch(f);
    }

    public void setVolumeChangeRate(float f) {
    }

    public boolean isLooping() {
        return this.looping;
    }

    public void setLooping(boolean bl) {
        this.looping = bl;
    }
}

