/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.sound;

import com.turborilla.sound.SFX;
import com.turborilla.sound.TurboSoundSystem;

public class CompositeSFX
extends SFX {
    private String[] tracks;
    protected double[] probabilities = null;
    protected String lastPlayed = null;
    protected double totalProbability = 0.0;

    public CompositeSFX(TurboSoundSystem turboSoundSystem) {
        super(turboSoundSystem, null);
    }

    public void setTracks(String[] stringArray, double[] dArray) {
        this.tracks = stringArray;
        this.probabilities = dArray;
        this.totalProbability = 0.0;
        if (dArray != null) {
            for (int i = 0; i < dArray.length; ++i) {
                this.totalProbability += dArray[i];
            }
        }
    }

    public void play(float f) {
        String string;
        int n = 0;
        if (this.probabilities != null) {
            double d = Math.random() * this.totalProbability;
            double d2 = 0.0;
            for (n = 0; n < this.getTracks().length && !(d <= (d2 += this.probabilities[n])); ++n) {
            }
            string = this.getTracks()[n];
        } else {
            n = (int)(Math.random() * (double)this.getTracks().length);
            string = this.getTracks()[n];
        }
        this.play(f, string);
    }

    public String[] getTracks() {
        return this.tracks;
    }

    public double[] getProbabilities() {
        return this.probabilities;
    }

    public String getLastPlayed() {
        return this.lastPlayed;
    }
}

