/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.scrolling;

import com.jme.image.Image;
import com.jme.renderer.pass.RenderPass;
import com.jme.scene.Node;
import com.turborilla.TransformationProvider;
import com.turborilla.Updatable;
import com.turborilla.scrolling.Layer;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parallax
extends RenderPass
implements Updatable {
    ArrayList<Layer> layers;
    TransformationProvider transformationProvider;
    int maxTextureWidth = 512;
    int maxTextureHeight = 512;
    boolean wholePixels = false;
    boolean alphaEnabled = true;
    protected Node node;
    private String name;
    private boolean paused;
    private float yTransformationBias;

    public Parallax(String string) {
        this.name = string;
        this.node = new Node(string + ":Node");
        this.add(this.node);
        this.layers = new ArrayList();
    }

    public Layer addLayer(String string, Image image, int n, float f) {
        return this.addLayer(string, image, 0.0f, n, f, this.alphaEnabled, Layer.Wrap.NORMAL, this.wholePixels);
    }

    public Layer addLayer(String string, Image image, float f, int n, float f2) {
        return this.addLayer(string, image, f, n, f2, this.alphaEnabled, Layer.Wrap.NORMAL, this.wholePixels);
    }

    public Layer addLayer(String string, Image image, float f, int n, float f2, boolean bl, Layer.Wrap wrap, boolean bl2) {
        return this.addLayer(string, image, f, n, f2, bl, wrap, bl2, false);
    }

    public Layer addLayer(String string, Image image, float f, int n, float f2, boolean bl, Layer.Wrap wrap, boolean bl2, boolean bl3) {
        Layer layer = new Layer(this.name + ":" + string, this.maxTextureWidth, this.maxTextureHeight, this.transformationProvider, bl, wrap, bl2, bl3);
        layer.init(image);
        layer.setTransformationFactor(f2);
        layer.setZOrder(n);
        layer.setVerticalPos(f);
        layer.setYTransformationBias(this.yTransformationBias);
        this.layers.add(layer);
        this.node.attachChild(layer);
        this.node.updateRenderState();
        return layer;
    }

    public void removeLayer(String string) {
        this.node.detachChildNamed(string);
        this.layers.remove(this.getLayer(string));
    }

    public void removeLayer(Layer layer) {
        this.node.detachChild(layer);
        this.layers.remove(layer);
    }

    public Layer getLayer(String string) {
        if (string == null) {
            return null;
        }
        Layer layer = null;
        for (int i = 0; i < this.layers.size(); ++i) {
            layer = this.layers.get(i);
            if (!string.equals(layer.getName()) && !(this.getName() + ":" + string).equals(layer.getName())) continue;
            return layer;
        }
        return null;
    }

    public Layer getFrontLayer() {
        if (this.layers.size() <= 0) {
            return null;
        }
        Layer layer = this.layers.get(0);
        for (int i = 1; i < this.layers.size(); ++i) {
            if (this.layers.get(i).getZOrder() > layer.getZOrder()) continue;
            layer = this.layers.get(i);
        }
        return layer;
    }

    public Layer getBackLayer() {
        if (this.layers.size() <= 0) {
            return null;
        }
        Layer layer = this.layers.get(0);
        for (int i = 1; i < this.layers.size(); ++i) {
            if (this.layers.get(i).getZOrder() <= layer.getZOrder()) continue;
            layer = this.layers.get(i);
        }
        return layer;
    }

    public Layer getLayer(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n >= this.layers.size()) {
            n = this.layers.size() - 1;
        }
        return this.layers.get(n);
    }

    public Iterator<Layer> getLayerIterator() {
        return this.layers.iterator();
    }

    public void removeAllLayers() {
        Layer layer = null;
        for (int i = 0; i < this.layers.size(); ++i) {
            layer = this.layers.get(i);
            layer.cleanup();
            this.node.detachChild(layer);
        }
        this.layers.clear();
    }

    @Override
    public void update(float f) {
        this.doUpdate(f);
    }

    @Override
    protected void doUpdate(float f) {
        if (this.paused) {
            return;
        }
        for (Layer layer : this.layers) {
            layer.update(f);
        }
        this.node.updateGeometricState(f, true);
        super.doUpdate(f);
    }

    @Override
    public void setPaused(boolean bl) {
        this.paused = bl;
    }

    public TransformationProvider getTransformationProvider() {
        return this.transformationProvider;
    }

    public void setTransformationProvider(TransformationProvider transformationProvider) {
        this.transformationProvider = transformationProvider;
        for (Layer layer : this.layers) {
            layer.setTransformationProvider(transformationProvider);
        }
    }

    public boolean isAlphaEnabled() {
        return this.alphaEnabled;
    }

    public void setAlphaEnabled(boolean bl) {
        this.alphaEnabled = bl;
    }

    public int getMaxTextureHeight() {
        return this.maxTextureHeight;
    }

    public void setMaxTextureHeight(int n) {
        this.maxTextureHeight = n;
    }

    public int getMaxTextureWidth() {
        return this.maxTextureWidth;
    }

    public void setMaxTextureWidth(int n) {
        this.maxTextureWidth = n;
    }

    public void changeSpeed(float f) {
        for (Layer layer : this.layers) {
            layer.setTransformationFactor(layer.getTransformationFactor() * f);
        }
    }

    public void setYTransformationBias(float f) {
        this.yTransformationBias = f;
        for (Layer layer : this.layers) {
            layer.setYTransformationBias(f);
        }
    }

    public boolean isWholePixels() {
        return this.wholePixels;
    }

    public void setWholePixels(boolean bl) {
        this.wholePixels = bl;
        for (Layer layer : this.layers) {
            layer.setWholePixels(bl);
        }
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
        this.node.setName(string + ":Node");
    }

    @Override
    public void cleanUp() {
        this.removeAllLayers();
        super.cleanUp();
    }
}

